/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.dataset.json;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import me.prettyprint.hector.api.ddl.ColumnType;
import me.prettyprint.hector.api.ddl.ComparatorType;
import org.cassandraunit.dataset.DataSet;
import org.cassandraunit.dataset.ParseException;
import org.cassandraunit.dataset.json.JSONColumn;
import org.cassandraunit.dataset.json.JSONColumnFamily;
import org.cassandraunit.dataset.json.JSONKeyspace;
import org.cassandraunit.dataset.json.JSONRow;
import org.cassandraunit.dataset.json.JSONSuperColumn;
import org.cassandraunit.model.ColumnFamilyModel;
import org.cassandraunit.model.ColumnModel;
import org.cassandraunit.model.KeyspaceModel;
import org.cassandraunit.model.RowModel;
import org.cassandraunit.model.StrategyModel;
import org.cassandraunit.model.SuperColumnModel;
import org.cassandraunit.type.GenericType;
import org.cassandraunit.type.GenericTypeEnum;
import org.cassandraunit.utils.TypeExtractor;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class ClassPathJSONDataSet
implements DataSet {
    private KeyspaceModel keyspace = null;

    public ClassPathJSONDataSet(String dataSetLocation) {
        JSONKeyspace jsonKeyspace = this.getJSONKeyspace(dataSetLocation);
        this.mapJSONKeyspaceToModel(jsonKeyspace);
    }

    private JSONKeyspace getJSONKeyspace(String dataSetLocation) {
        InputStream inputDataSetLocation = this.getClass().getResourceAsStream("/" + dataSetLocation);
        if (inputDataSetLocation == null) {
            throw new ParseException("Dataset not found in classpath");
        }
        ObjectMapper jsonMapper = new ObjectMapper();
        try {
            return (JSONKeyspace)jsonMapper.readValue(inputDataSetLocation, JSONKeyspace.class);
        }
        catch (JsonParseException e) {
            throw new ParseException(e);
        }
        catch (JsonMappingException e) {
            throw new ParseException(e);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    private void mapJSONKeyspaceToModel(JSONKeyspace jsonKeyspace) {
        this.keyspace = new KeyspaceModel();
        if (jsonKeyspace.getName() == null) {
            throw new ParseException("Keyspace name is mandatory");
        }
        this.keyspace.setName(jsonKeyspace.getName());
        if (jsonKeyspace.getReplicationFactor() != 0) {
            this.keyspace.setReplicationFactor(jsonKeyspace.getReplicationFactor());
        }
        if (jsonKeyspace.getStrategy() != null) {
            try {
                this.keyspace.setStrategy(StrategyModel.fromValue(jsonKeyspace.getStrategy()));
            }
            catch (IllegalArgumentException e) {
                throw new ParseException("Invalid keyspace Strategy");
            }
        }
        this.mapsJSONColumnFamiliesToColumnFamiliesModel(jsonKeyspace);
    }

    private void mapsJSONColumnFamiliesToColumnFamiliesModel(JSONKeyspace jsonKeyspace) {
        if (jsonKeyspace.getColumnFamilies() != null) {
            for (JSONColumnFamily jsonColumnFamily : jsonKeyspace.getColumnFamilies()) {
                this.keyspace.getColumnFamilies().add(this.mapJSONColumnFamilyToColumnFamilyModel(jsonColumnFamily));
            }
        }
    }

    private ColumnFamilyModel mapJSONColumnFamilyToColumnFamilyModel(JSONColumnFamily jsonColumnFamily) {
        ColumnFamilyModel columnFamily = new ColumnFamilyModel();
        if (jsonColumnFamily.getName() == null) {
            throw new ParseException("Column Family Name is missing");
        }
        columnFamily.setName(jsonColumnFamily.getName());
        if (jsonColumnFamily.getType() != null) {
            columnFamily.setType(ColumnType.valueOf((String)jsonColumnFamily.getType().toString()));
        }
        if (jsonColumnFamily.getKeyType() != null) {
            columnFamily.setKeyType(ComparatorType.getByClassName((String)jsonColumnFamily.getKeyType().name()));
        }
        if (jsonColumnFamily.getComparatorType() != null) {
            columnFamily.setComparatorType(ComparatorType.getByClassName((String)jsonColumnFamily.getComparatorType().name()));
        }
        if (jsonColumnFamily.getSubComparatorType() != null) {
            columnFamily.setSubComparatorType(ComparatorType.getByClassName((String)jsonColumnFamily.getSubComparatorType().name()));
        }
        if (jsonColumnFamily.getDefaultColumnValueType() != null) {
            columnFamily.setDefaultColumnValueType(ComparatorType.getByClassName((String)jsonColumnFamily.getDefaultColumnValueType().name()));
        }
        columnFamily.setRows(this.mapJSONRowsToRowsModel(jsonColumnFamily, columnFamily.getKeyType(), columnFamily.getComparatorType(), columnFamily.getSubComparatorType(), columnFamily.getDefaultColumnValueType()));
        return columnFamily;
    }

    private List<RowModel> mapJSONRowsToRowsModel(JSONColumnFamily jsonColumnFamily, ComparatorType keyType, ComparatorType comparatorType, ComparatorType subComparatorType, ComparatorType defaultColumnValueType) {
        ArrayList<RowModel> rowsModel = new ArrayList<RowModel>();
        for (JSONRow jsonRow : jsonColumnFamily.getRows()) {
            rowsModel.add(this.mapsJSONRowToRowModel(jsonRow, keyType, comparatorType, subComparatorType, defaultColumnValueType));
        }
        return rowsModel;
    }

    private RowModel mapsJSONRowToRowModel(JSONRow jsonRow, ComparatorType keyType, ComparatorType comparatorType, ComparatorType subComparatorType, ComparatorType defaultColumnValueType) {
        RowModel row = new RowModel();
        row.setKey(new GenericType(jsonRow.getKey(), GenericTypeEnum.fromValue(keyType.getTypeName())));
        row.setColumns(this.mapXmlColumnsToColumnsModel(jsonRow.getColumns(), comparatorType, defaultColumnValueType));
        row.setSuperColumns(this.mapXmlSuperColumnsToSuperColumnsModel(jsonRow.getSuperColumns(), comparatorType, subComparatorType, defaultColumnValueType));
        return row;
    }

    private List<SuperColumnModel> mapXmlSuperColumnsToSuperColumnsModel(List<JSONSuperColumn> jsonSuperColumns, ComparatorType comparatorType, ComparatorType subComparatorType, ComparatorType defaultColumnValueType) {
        ArrayList<SuperColumnModel> columnsModel = new ArrayList<SuperColumnModel>();
        for (JSONSuperColumn jsonSuperColumn : jsonSuperColumns) {
            columnsModel.add(this.mapXmlSuperColumnToSuperColumnModel(jsonSuperColumn, comparatorType, subComparatorType, defaultColumnValueType));
        }
        return columnsModel;
    }

    private SuperColumnModel mapXmlSuperColumnToSuperColumnModel(JSONSuperColumn jsonSuperColumn, ComparatorType comparatorType, ComparatorType subComparatorType, ComparatorType defaultColumnValueType) {
        SuperColumnModel superColumnModel = new SuperColumnModel();
        superColumnModel.setName(new GenericType(jsonSuperColumn.getName(), GenericTypeEnum.fromValue(comparatorType.getTypeName())));
        superColumnModel.setColumns(this.mapXmlColumnsToColumnsModel(jsonSuperColumn.getColumns(), subComparatorType, defaultColumnValueType));
        return superColumnModel;
    }

    private List<ColumnModel> mapXmlColumnsToColumnsModel(List<JSONColumn> jsonColumns, ComparatorType comparatorType, ComparatorType defaultColumnValueType) {
        ArrayList<ColumnModel> columnsModel = new ArrayList<ColumnModel>();
        for (JSONColumn jsonColumn : jsonColumns) {
            columnsModel.add(this.mapXmlColumnToColumnModel(jsonColumn, comparatorType, defaultColumnValueType));
        }
        return columnsModel;
    }

    private ColumnModel mapXmlColumnToColumnModel(JSONColumn jsonColumn, ComparatorType comparatorType, ComparatorType defaultColumnValueType) {
        ColumnModel columnModel = new ColumnModel();
        if (comparatorType == null) {
            columnModel.setName(new GenericType(jsonColumn.getName(), GenericTypeEnum.BYTES_TYPE));
        } else {
            columnModel.setName(new GenericType(jsonColumn.getName(), GenericTypeEnum.fromValue(comparatorType.getTypeName())));
        }
        GenericType columnValue = TypeExtractor.extract(jsonColumn.getValue(), defaultColumnValueType);
        columnModel.setValue(columnValue);
        return columnModel;
    }

    @Override
    public KeyspaceModel getKeyspace() {
        return this.keyspace;
    }

    @Override
    public List<ColumnFamilyModel> getColumnFamilies() {
        return this.keyspace.getColumnFamilies();
    }
}

