/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.spring;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.cassandraunit.CQLDataLoader;
import org.cassandraunit.DataLoader;
import org.cassandraunit.dataset.CQLDataSet;
import org.cassandraunit.dataset.ClassPathDataSet;
import org.cassandraunit.dataset.DataSet;
import org.cassandraunit.dataset.cql.ClassPathCQLDataSet;
import org.cassandraunit.spring.CassandraDataSet;
import org.cassandraunit.spring.EmbeddedCassandra;
import org.cassandraunit.utils.EmbeddedCassandraServerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.util.ClassUtils;

public class CassandraUnitTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraUnitTestExecutionListener.class);
    private static boolean initialized = false;

    public void beforeTestMethod(TestContext testContext) throws Exception {
        EmbeddedCassandra embeddedCassandra = (EmbeddedCassandra)Preconditions.checkNotNull((Object)AnnotationUtils.findAnnotation(testContext.getTestInstance().getClass(), EmbeddedCassandra.class), (Object)("CassandraUnitTestExecutionListener must be used with @EmbeddedCassandra on " + testContext.getTestClass()));
        if (!initialized) {
            EmbeddedCassandraServerHelper.startEmbeddedCassandra((String)((String)Optional.fromNullable((Object)embeddedCassandra.configuration()).get()));
            initialized = true;
        }
        String clusterName = (String)Preconditions.checkNotNull((Object)embeddedCassandra.clusterName(), (Object)"@EmbeddedCassandra host must not be null");
        String host = (String)Preconditions.checkNotNull((Object)embeddedCassandra.host(), (Object)"@EmbeddedCassandra clusterName must not be null");
        int port = (Integer)Preconditions.checkNotNull((Object)embeddedCassandra.port(), (Object)"@EmbeddedCassandra port must not be null");
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"@EmbeddedCassandra port must not be > 0");
        CassandraDataSet cassandraDataSet = (CassandraDataSet)AnnotationUtils.findAnnotation(testContext.getTestInstance().getClass(), CassandraDataSet.class);
        if (cassandraDataSet != null) {
            List<String> dataset = null;
            ListIterator<String> datasetIterator = null;
            String keyspace = cassandraDataSet.keyspace();
            switch (cassandraDataSet.type()) {
                case cql: {
                    dataset = this.dataSetLocations(testContext, cassandraDataSet);
                    datasetIterator = dataset.listIterator();
                    CQLDataLoader cqlDataLoader = new CQLDataLoader(host, port);
                    while (datasetIterator.hasNext()) {
                        String next = datasetIterator.next();
                        boolean dropAndCreateKeyspace = datasetIterator.previousIndex() == 0;
                        cqlDataLoader.load((CQLDataSet)new ClassPathCQLDataSet(next, dropAndCreateKeyspace, dropAndCreateKeyspace, keyspace));
                    }
                    break;
                }
                default: {
                    dataset = this.dataSetLocations(testContext, cassandraDataSet);
                    datasetIterator = dataset.listIterator();
                    DataLoader dataLoader = new DataLoader(clusterName, host + ":" + port);
                    while (datasetIterator.hasNext()) {
                        String next = datasetIterator.next();
                        boolean dropAndCreateKeyspace = datasetIterator.previousIndex() == 0;
                        dataLoader.load((DataSet)new ClassPathDataSet(next), dropAndCreateKeyspace);
                    }
                    break block0;
                }
            }
        }
    }

    private List<String> dataSetLocations(TestContext testContext, CassandraDataSet cassandraDataSet) {
        String[] dataset = cassandraDataSet.value();
        if (dataset.length == 0) {
            String alternativePath = this.alternativePath(testContext.getTestInstance().getClass(), true, cassandraDataSet.type().name());
            if (testContext.getApplicationContext().getResource(alternativePath).exists()) {
                dataset = new String[]{alternativePath.replace("classpath:/", "")};
            } else {
                alternativePath = this.alternativePath(testContext.getTestInstance().getClass(), false, cassandraDataSet.type().name());
                if (testContext.getApplicationContext().getResource(alternativePath).exists()) {
                    dataset = new String[]{alternativePath.replace("classpath:/", "")};
                } else {
                    LOGGER.info("No dataset will be loaded");
                }
            }
        }
        return Arrays.asList(dataset);
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        EmbeddedCassandraServerHelper.cleanEmbeddedCassandra();
    }

    protected String alternativePath(Class<?> clazz, boolean includedPackageName, String extension) {
        if (includedPackageName) {
            return "classpath:/" + ClassUtils.convertClassNameToResourcePath((String)clazz.getName()) + "-dataset" + "." + extension;
        }
        return "classpath:/" + clazz.getSimpleName() + "-dataset" + "." + extension;
    }
}

