/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.impl.json.jackson.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import org.camunda.spin.SpinList;
import org.camunda.spin.impl.json.jackson.JacksonJsonLogger;
import org.camunda.spin.impl.json.jackson.JacksonJsonNode;
import org.camunda.spin.impl.json.jackson.format.JacksonJsonDataFormat;
import org.camunda.spin.json.SpinJsonNode;
import org.camunda.spin.json.SpinJsonPathQuery;

public class JacksonJsonPathQuery
implements SpinJsonPathQuery {
    private static final JacksonJsonLogger LOG = JacksonJsonLogger.JSON_TREE_LOGGER;
    protected final SpinJsonNode spinJsonNode;
    protected final JsonPath query;
    protected final JacksonJsonDataFormat dataFormat;

    public JacksonJsonPathQuery(JacksonJsonNode jacksonJsonNode, JsonPath query, JacksonJsonDataFormat dataFormat) {
        this.spinJsonNode = jacksonJsonNode;
        this.query = query;
        this.dataFormat = dataFormat;
    }

    public SpinJsonNode element() {
        try {
            Object result = this.query.read(this.spinJsonNode.toString(), this.dataFormat.getJsonPathConfiguration());
            if (result != null) {
                JsonNode node = this.dataFormat.createJsonNode(result);
                return this.dataFormat.createWrapperInstance(node);
            }
            throw LOG.unableToFindJsonPath(this.query.getPath(), this.spinJsonNode.toString());
        }
        catch (PathNotFoundException pex) {
            throw LOG.unableToEvaluateJsonPathExpressionOnNode(this.spinJsonNode, (Exception)((Object)pex));
        }
        catch (ClassCastException cex) {
            throw LOG.unableToCastJsonPathResultTo(SpinJsonNode.class, cex);
        }
    }

    public SpinList<SpinJsonNode> elementList() {
        JacksonJsonNode node = (JacksonJsonNode)this.element();
        if (node.isArray().booleanValue()) {
            return node.elements();
        }
        throw LOG.unableToParseValue(SpinList.class.getSimpleName(), node.getNodeType());
    }

    public String stringValue() {
        JacksonJsonNode node = (JacksonJsonNode)this.element();
        if (node.isString().booleanValue()) {
            return node.stringValue();
        }
        throw LOG.unableToParseValue(String.class.getSimpleName(), node.getNodeType());
    }

    public Number numberValue() {
        JacksonJsonNode node = (JacksonJsonNode)this.element();
        if (node.isNumber().booleanValue()) {
            return node.numberValue();
        }
        throw LOG.unableToParseValue(Number.class.getSimpleName(), node.getNodeType());
    }

    public Boolean boolValue() {
        JacksonJsonNode node = (JacksonJsonNode)this.element();
        if (node.isBoolean().booleanValue()) {
            return node.boolValue();
        }
        throw LOG.unableToParseValue(Boolean.class.getSimpleName(), node.getNodeType());
    }
}

