/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.impl.xml.dom.format;

import java.beans.Introspector;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.camunda.commons.utils.EnsureUtil;
import org.camunda.spin.impl.util.SpinReflectUtil;
import org.camunda.spin.impl.xml.dom.DomXmlLogger;
import org.camunda.spin.impl.xml.dom.format.DomXmlDataFormat;
import org.camunda.spin.impl.xml.dom.format.spi.JaxBContextProvider;
import org.camunda.spin.spi.DataFormat;
import org.camunda.spin.spi.DataFormatMapper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DomXmlDataFormatMapper
implements DataFormatMapper {
    protected DomXmlDataFormat dataFormat;
    private static final DomXmlLogger LOG = DomXmlLogger.XML_DOM_LOGGER;

    public DomXmlDataFormatMapper(DomXmlDataFormat format) {
        this.dataFormat = format;
    }

    public boolean canMap(Object parameter) {
        return parameter != null;
    }

    public String getCanonicalTypeName(Object object) {
        return object.getClass().getName();
    }

    public Object mapJavaToInternal(Object parameter) {
        EnsureUtil.ensureNotNull((String)"Parameter", (Object)parameter);
        Class<?> parameterClass = parameter.getClass();
        DOMResult domResult = new DOMResult();
        try {
            boolean isRootElement;
            Marshaller marshaller = this.getMarshaller(parameterClass);
            boolean bl = isRootElement = parameterClass.getAnnotation(XmlRootElement.class) != null;
            if (isRootElement) {
                this.marshalRootElement(parameter, marshaller, domResult);
            } else {
                this.marshalNonRootElement(parameter, marshaller, domResult);
            }
            Node node = domResult.getNode();
            return ((Document)node).getDocumentElement();
        }
        catch (JAXBException e) {
            throw LOG.unableToMapInput(parameter, e);
        }
    }

    protected void marshalRootElement(Object parameter, Marshaller marshaller, DOMResult domResult) throws JAXBException {
        marshaller.marshal(parameter, (Result)domResult);
    }

    protected void marshalNonRootElement(Object parameter, Marshaller marshaller, DOMResult domResult) throws JAXBException {
        Class<?> parameterClass = parameter.getClass();
        String simpleName = Introspector.decapitalize(parameterClass.getSimpleName());
        JAXBElement root = new JAXBElement(new QName(simpleName), parameterClass, parameter);
        marshaller.marshal((Object)root, (Result)domResult);
    }

    public <T> T mapInternalToJava(Object parameter, Class<T> javaClass) {
        EnsureUtil.ensureNotNull((String)"Parameter", (Object)parameter);
        EnsureUtil.ensureNotNull((String)"Type", javaClass);
        Node xmlNode = (Node)parameter;
        try {
            Unmarshaller unmarshaller = this.getUnmarshaller(javaClass);
            JAXBElement root = unmarshaller.unmarshal((Source)new DOMSource(xmlNode), javaClass);
            return (T)root.getValue();
        }
        catch (JAXBException e) {
            throw LOG.unableToDeserialize(parameter, javaClass.getCanonicalName(), e);
        }
    }

    public <T> T mapInternalToJava(Object parameter, String classIdentifier) {
        EnsureUtil.ensureNotNull((String)"Parameter", (Object)parameter);
        EnsureUtil.ensureNotNull((String)"classIdentifier", (Object)classIdentifier);
        try {
            Class javaClass = SpinReflectUtil.loadClass((String)classIdentifier, (DataFormat)this.dataFormat);
            return this.mapInternalToJava(parameter, javaClass);
        }
        catch (Exception e) {
            throw LOG.unableToDeserialize(parameter, classIdentifier, e);
        }
    }

    protected Marshaller getMarshaller(Class<?> parameter) throws JAXBException {
        JaxBContextProvider jaxBContextProvider = this.dataFormat.getJaxBContextProvider();
        return jaxBContextProvider.createMarshaller(parameter);
    }

    protected Unmarshaller getUnmarshaller(Class<?> parameter) throws JAXBException {
        JaxBContextProvider jaxBContextProvider = this.dataFormat.getJaxBContextProvider();
        return jaxBContextProvider.createUnmarshaller(parameter);
    }
}

