/*
 * Decompiled with CFR 0.152.
 */
package spinjar.com.fasterxml.jackson.databind.deser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import spinjar.com.fasterxml.jackson.databind.BeanDescription;
import spinjar.com.fasterxml.jackson.databind.DeserializationConfig;
import spinjar.com.fasterxml.jackson.databind.JavaType;
import spinjar.com.fasterxml.jackson.databind.JsonDeserializer;
import spinjar.com.fasterxml.jackson.databind.MapperFeature;
import spinjar.com.fasterxml.jackson.databind.PropertyMetadata;
import spinjar.com.fasterxml.jackson.databind.PropertyName;
import spinjar.com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import spinjar.com.fasterxml.jackson.databind.deser.AbstractDeserializer;
import spinjar.com.fasterxml.jackson.databind.deser.BeanDeserializer;
import spinjar.com.fasterxml.jackson.databind.deser.BuilderBasedDeserializer;
import spinjar.com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import spinjar.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import spinjar.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import spinjar.com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import spinjar.com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import spinjar.com.fasterxml.jackson.databind.deser.impl.ObjectIdValueProperty;
import spinjar.com.fasterxml.jackson.databind.deser.impl.ValueInjector;
import spinjar.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import spinjar.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import spinjar.com.fasterxml.jackson.databind.util.Annotations;

public class BeanDeserializerBuilder {
    protected final BeanDescription _beanDesc;
    protected final boolean _defaultViewInclusion;
    protected final boolean _caseInsensitivePropertyComparison;
    protected final Map<String, SettableBeanProperty> _properties = new LinkedHashMap<String, SettableBeanProperty>();
    protected List<ValueInjector> _injectables;
    protected HashMap<String, SettableBeanProperty> _backRefProperties;
    protected HashSet<String> _ignorableProps;
    protected ValueInstantiator _valueInstantiator;
    protected ObjectIdReader _objectIdReader;
    protected SettableAnyProperty _anySetter;
    protected boolean _ignoreAllUnknown;
    protected AnnotatedMethod _buildMethod;
    protected JsonPOJOBuilder.Value _builderConfig;

    public BeanDeserializerBuilder(BeanDescription beanDesc, DeserializationConfig config) {
        this._beanDesc = beanDesc;
        this._defaultViewInclusion = config.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION);
        this._caseInsensitivePropertyComparison = config.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES);
    }

    protected BeanDeserializerBuilder(BeanDeserializerBuilder src) {
        this._beanDesc = src._beanDesc;
        this._defaultViewInclusion = src._defaultViewInclusion;
        this._caseInsensitivePropertyComparison = src._caseInsensitivePropertyComparison;
        this._properties.putAll(src._properties);
        this._injectables = BeanDeserializerBuilder._copy(src._injectables);
        this._backRefProperties = BeanDeserializerBuilder._copy(src._backRefProperties);
        this._ignorableProps = src._ignorableProps;
        this._valueInstantiator = src._valueInstantiator;
        this._objectIdReader = src._objectIdReader;
        this._anySetter = src._anySetter;
        this._ignoreAllUnknown = src._ignoreAllUnknown;
        this._buildMethod = src._buildMethod;
        this._builderConfig = src._builderConfig;
    }

    private static HashMap<String, SettableBeanProperty> _copy(HashMap<String, SettableBeanProperty> src) {
        return src == null ? null : new HashMap<String, SettableBeanProperty>(src);
    }

    private static <T> List<T> _copy(List<T> src) {
        return src == null ? null : new ArrayList<T>(src);
    }

    public void addOrReplaceProperty(SettableBeanProperty prop, boolean allowOverride) {
        this._properties.put(prop.getName(), prop);
    }

    public void addProperty(SettableBeanProperty prop) {
        SettableBeanProperty old = this._properties.put(prop.getName(), prop);
        if (old != null && old != prop) {
            throw new IllegalArgumentException("Duplicate property '" + prop.getName() + "' for " + this._beanDesc.getType());
        }
    }

    public void addBackReferenceProperty(String referenceName, SettableBeanProperty prop) {
        if (this._backRefProperties == null) {
            this._backRefProperties = new HashMap(4);
        }
        this._backRefProperties.put(referenceName, prop);
        if (this._properties != null) {
            this._properties.remove(prop.getName());
        }
    }

    public void addInjectable(PropertyName propName, JavaType propType, Annotations contextAnnotations, AnnotatedMember member, Object valueId) {
        if (this._injectables == null) {
            this._injectables = new ArrayList<ValueInjector>();
        }
        this._injectables.add(new ValueInjector(propName, propType, contextAnnotations, member, valueId));
    }

    public void addIgnorable(String propName) {
        if (this._ignorableProps == null) {
            this._ignorableProps = new HashSet();
        }
        this._ignorableProps.add(propName);
    }

    public void addCreatorProperty(SettableBeanProperty prop) {
        this.addProperty(prop);
    }

    public void setAnySetter(SettableAnyProperty s) {
        if (this._anySetter != null && s != null) {
            throw new IllegalStateException("_anySetter already set to non-null");
        }
        this._anySetter = s;
    }

    public void setIgnoreUnknownProperties(boolean ignore) {
        this._ignoreAllUnknown = ignore;
    }

    public void setValueInstantiator(ValueInstantiator inst) {
        this._valueInstantiator = inst;
    }

    public void setObjectIdReader(ObjectIdReader r) {
        this._objectIdReader = r;
    }

    public void setPOJOBuilder(AnnotatedMethod buildMethod, JsonPOJOBuilder.Value config) {
        this._buildMethod = buildMethod;
        this._builderConfig = config;
    }

    public Iterator<SettableBeanProperty> getProperties() {
        return this._properties.values().iterator();
    }

    public SettableBeanProperty findProperty(PropertyName propertyName) {
        return this._properties.get(propertyName.getSimpleName());
    }

    public boolean hasProperty(PropertyName propertyName) {
        return this.findProperty(propertyName) != null;
    }

    public SettableBeanProperty removeProperty(PropertyName name) {
        return this._properties.remove(name.getSimpleName());
    }

    public SettableAnyProperty getAnySetter() {
        return this._anySetter;
    }

    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    public List<ValueInjector> getInjectables() {
        return this._injectables;
    }

    public ObjectIdReader getObjectIdReader() {
        return this._objectIdReader;
    }

    public AnnotatedMethod getBuildMethod() {
        return this._buildMethod;
    }

    public JsonPOJOBuilder.Value getBuilderConfig() {
        return this._builderConfig;
    }

    public JsonDeserializer<?> build() {
        boolean anyViews;
        Collection<SettableBeanProperty> props = this._properties.values();
        BeanPropertyMap propertyMap = new BeanPropertyMap(props, this._caseInsensitivePropertyComparison);
        propertyMap.assignIndexes();
        boolean bl = anyViews = !this._defaultViewInclusion;
        if (!anyViews) {
            for (SettableBeanProperty prop : props) {
                if (!prop.hasViews()) continue;
                anyViews = true;
                break;
            }
        }
        if (this._objectIdReader != null) {
            ObjectIdValueProperty prop = new ObjectIdValueProperty(this._objectIdReader, PropertyMetadata.STD_REQUIRED);
            propertyMap = propertyMap.withProperty(prop);
        }
        return new BeanDeserializer(this, this._beanDesc, propertyMap, this._backRefProperties, this._ignorableProps, this._ignoreAllUnknown, anyViews);
    }

    public AbstractDeserializer buildAbstract() {
        return new AbstractDeserializer(this, this._beanDesc, this._backRefProperties);
    }

    public JsonDeserializer<?> buildBuilderBased(JavaType valueType, String expBuildMethodName) {
        boolean anyViews;
        Class<?> rawValueType;
        if (this._buildMethod == null) {
            throw new IllegalArgumentException("Builder class " + this._beanDesc.getBeanClass().getName() + " does not have build method '" + expBuildMethodName + "()'");
        }
        Class<?> rawBuildType = this._buildMethod.getRawReturnType();
        if (rawBuildType != (rawValueType = valueType.getRawClass()) && !rawBuildType.isAssignableFrom(rawValueType) && !rawValueType.isAssignableFrom(rawBuildType)) {
            throw new IllegalArgumentException("Build method '" + this._buildMethod.getFullName() + " has bad return type (" + rawBuildType.getName() + "), not compatible with POJO type (" + valueType.getRawClass().getName() + ")");
        }
        Collection<SettableBeanProperty> props = this._properties.values();
        BeanPropertyMap propertyMap = new BeanPropertyMap(props, this._caseInsensitivePropertyComparison);
        propertyMap.assignIndexes();
        boolean bl = anyViews = !this._defaultViewInclusion;
        if (!anyViews) {
            for (SettableBeanProperty prop : props) {
                if (!prop.hasViews()) continue;
                anyViews = true;
                break;
            }
        }
        if (this._objectIdReader != null) {
            ObjectIdValueProperty prop = new ObjectIdValueProperty(this._objectIdReader, PropertyMetadata.STD_REQUIRED);
            propertyMap = propertyMap.withProperty(prop);
        }
        return new BuilderBasedDeserializer(this, this._beanDesc, propertyMap, this._backRefProperties, this._ignorableProps, this._ignoreAllUnknown, anyViews);
    }
}

