/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.impl.util;

import org.camunda.spin.impl.logging.SpinCoreLogger;
import org.camunda.spin.spi.DataFormat;

public class SpinReflectUtil {
    private static final SpinCoreLogger LOG = SpinCoreLogger.CORE_LOGGER;

    public static Class<?> loadClass(String classname, DataFormat<?> dataFormat) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            LOG.tryLoadingClass(classname, cl);
            try {
                return cl.loadClass(classname);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        cl = dataFormat.getClass().getClassLoader();
        try {
            LOG.tryLoadingClass(classname, cl);
            return cl.loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            throw LOG.classNotFound(classname, e);
        }
    }
}

