/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.impl.json.jackson.query;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import spinjar.com.fasterxml.jackson.core.JsonGenerator;
import spinjar.com.fasterxml.jackson.databind.ObjectMapper;
import spinjar.com.fasterxml.jackson.databind.type.CollectionType;
import spinjar.com.jayway.jsonpath.InvalidJsonException;
import spinjar.com.jayway.jsonpath.internal.Utils;
import spinjar.com.jayway.jsonpath.spi.JsonProvider;
import spinjar.com.jayway.jsonpath.spi.MappingProvider;
import spinjar.com.jayway.jsonpath.spi.Mode;

public class JsonPathJacksonProvider
implements MappingProvider,
JsonProvider {
    protected ObjectMapper objectMapper;

    public JsonPathJacksonProvider() {
        this(new ObjectMapper());
    }

    public JsonPathJacksonProvider(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public Mode getMode() {
        return Mode.STRICT;
    }

    @Override
    public Object parse(String json) throws InvalidJsonException {
        try {
            return this.objectMapper.readValue(json, Object.class);
        }
        catch (IOException e) {
            throw new InvalidJsonException(e);
        }
    }

    @Override
    public Object parse(Reader jsonReader) throws InvalidJsonException {
        try {
            return this.objectMapper.readValue(jsonReader, Object.class);
        }
        catch (IOException e) {
            throw new InvalidJsonException(e);
        }
    }

    @Override
    public Object parse(InputStream jsonStream) throws InvalidJsonException {
        try {
            return this.objectMapper.readValue(jsonStream, Object.class);
        }
        catch (IOException e) {
            throw new InvalidJsonException(e);
        }
    }

    @Override
    public String toJson(Object obj) {
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator jsonGenerator = this.objectMapper.getJsonFactory().createJsonGenerator(writer);
            this.objectMapper.writeValue(jsonGenerator, obj);
            writer.close();
            return writer.getBuffer().toString();
        }
        catch (IOException e) {
            throw new InvalidJsonException();
        }
    }

    @Override
    public Map<String, Object> createMap() {
        return new HashMap<String, Object>();
    }

    @Override
    public List<Object> createArray() {
        return new LinkedList<Object>();
    }

    @Override
    public <T> T convertValue(Object fromValue, Class<T> toValueType) throws IllegalArgumentException {
        return this.objectMapper.convertValue(fromValue, toValueType);
    }

    @Override
    public <T extends Collection<E>, E> T convertValue(Object fromValue, Class<T> collectionType, Class<E> elementType) throws IllegalArgumentException {
        CollectionType colType = this.objectMapper.getTypeFactory().constructCollectionType(collectionType, elementType);
        return (T)((Collection)this.objectMapper.convertValue(fromValue, colType));
    }

    @Override
    public Object clone(Object obj) {
        return Utils.clone((Serializable)obj);
    }

    @Override
    public boolean isContainer(Object obj) {
        return this.isArray(obj) || this.isMap(obj);
    }

    @Override
    public boolean isArray(Object obj) {
        return obj instanceof List;
    }

    @Override
    public Object getProperty(Object obj, Object key) {
        if (this.isMap(obj)) {
            return ((Map)obj).get(key.toString());
        }
        int index = key instanceof Integer ? (Integer)key : Integer.parseInt(key.toString());
        return ((List)obj).get(index);
    }

    @Override
    public void setProperty(Object obj, Object key, Object value) {
        if (this.isMap(obj)) {
            ((Map)obj).put(key.toString(), value);
        } else {
            int index = key instanceof Integer ? (Integer)key : Integer.parseInt(key.toString());
            ((List)obj).add(index, value);
        }
    }

    @Override
    public boolean isMap(Object obj) {
        return obj instanceof Map;
    }

    @Override
    public Collection<String> getPropertyKeys(Object obj) {
        if (this.isArray(obj)) {
            List l = (List)obj;
            ArrayList<String> keys = new ArrayList<String>(l.size());
            for (int i = 0; i < l.size(); ++i) {
                keys.add(String.valueOf(i));
            }
            return keys;
        }
        return ((Map)obj).keySet();
    }

    @Override
    public int length(Object obj) {
        if (this.isArray(obj)) {
            return ((List)obj).size();
        }
        return this.getPropertyKeys(obj).size();
    }

    @Override
    public Iterable<Object> toIterable(Object obj) {
        if (this.isArray(obj)) {
            return (Iterable)obj;
        }
        return ((Map)obj).values();
    }
}

