/*
 * Decompiled with CFR 0.152.
 */
package spinjar.com.fasterxml.jackson.core.io.doubleparser;

import spinjar.com.fasterxml.jackson.core.io.doubleparser.DoubleBitsFromCharArray;
import spinjar.com.fasterxml.jackson.core.io.doubleparser.DoubleBitsFromCharSequence;

public class FastDoubleParser {
    private FastDoubleParser() {
    }

    public static double parseDouble(CharSequence str) throws NumberFormatException {
        return FastDoubleParser.parseDouble(str, 0, str.length());
    }

    public static double parseDouble(CharSequence str, int offset, int length) throws NumberFormatException {
        long bitPattern = new DoubleBitsFromCharSequence().parseFloatingPointLiteral(str, offset, length);
        if (bitPattern == -1L) {
            throw new NumberFormatException("Illegal input");
        }
        return Double.longBitsToDouble(bitPattern);
    }

    public static double parseDouble(char[] str) throws NumberFormatException {
        return FastDoubleParser.parseDouble(str, 0, str.length);
    }

    public static double parseDouble(char[] str, int offset, int length) throws NumberFormatException {
        long bitPattern = new DoubleBitsFromCharArray().parseFloatingPointLiteral(str, offset, length);
        if (bitPattern == -1L) {
            throw new NumberFormatException("Illegal input");
        }
        return Double.longBitsToDouble(bitPattern);
    }

    public static long parseDoubleBits(CharSequence str, int offset, int length) {
        return new DoubleBitsFromCharSequence().parseFloatingPointLiteral(str, offset, length);
    }

    public static long parseDoubleBits(char[] str, int offset, int length) {
        return new DoubleBitsFromCharArray().parseFloatingPointLiteral(str, offset, length);
    }
}

