/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.impl.util;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import org.camunda.spin.impl.logging.SpinCoreLogger;
import org.camunda.spin.impl.logging.SpinLogger;

public class RewindableReader
extends Reader {
    private static final SpinCoreLogger LOG = SpinLogger.CORE_LOGGER;
    protected PushbackReader wrappedReader;
    protected char[] buffer;
    protected int pos;
    protected boolean rewindable;

    public RewindableReader(Reader input, int size) {
        this.wrappedReader = new PushbackReader(input, size);
        this.buffer = new char[size];
        this.pos = 0;
        this.rewindable = true;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int charactersRead = this.wrappedReader.read(cbuf, off, len);
        if (charactersRead > 0) {
            if (this.rewindable && this.pos + charactersRead > this.buffer.length) {
                this.rewindable = false;
            }
            if (this.pos < this.buffer.length) {
                int freeBufferSpace = this.buffer.length - this.pos;
                int insertableCharacters = Math.min(charactersRead, freeBufferSpace);
                System.arraycopy(cbuf, off, this.buffer, this.pos, insertableCharacters);
                this.pos += insertableCharacters;
            }
        }
        return charactersRead;
    }

    @Override
    public int read() throws IOException {
        int nextCharacter = this.wrappedReader.read();
        if (nextCharacter != -1) {
            if (this.pos < this.buffer.length) {
                this.buffer[this.pos] = (char)nextCharacter;
                ++this.pos;
            } else if (this.rewindable && this.pos >= this.buffer.length) {
                this.rewindable = false;
            }
        }
        return nextCharacter;
    }

    @Override
    public void close() throws IOException {
        this.wrappedReader.close();
    }

    @Override
    public synchronized void mark(int readlimit) throws IOException {
        this.wrappedReader.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.wrappedReader.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.wrappedReader.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.wrappedReader.skip(n);
    }

    public void rewind() throws IOException {
        if (!this.rewindable) {
            throw LOG.unableToRewindReader();
        }
        this.wrappedReader.unread(this.buffer, 0, this.pos);
        this.pos = 0;
    }

    public int getRewindBufferSize() {
        return this.buffer.length;
    }

    public int getCurrentRewindableCapacity() {
        return this.buffer.length - this.pos;
    }
}

