/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.impl.xml.dom;

import java.io.IOException;
import java.io.Writer;
import org.camunda.spin.impl.xml.dom.DomXmlLogger;
import org.camunda.spin.impl.xml.dom.format.DomXmlDataFormat;
import org.camunda.spin.impl.xml.dom.format.DomXmlDataFormatMapper;
import org.camunda.spin.xml.SpinXmlAttribute;
import org.camunda.spin.xml.SpinXmlElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class DomXmlAttribute
extends SpinXmlAttribute {
    private static final DomXmlLogger LOG = DomXmlLogger.XML_DOM_LOGGER;
    protected final Attr attributeNode;
    protected final DomXmlDataFormat dataFormat;

    public DomXmlAttribute(Attr attributeNode, DomXmlDataFormat dataFormat) {
        this.attributeNode = attributeNode;
        this.dataFormat = dataFormat;
    }

    @Override
    public String getDataFormatName() {
        return this.dataFormat.getName();
    }

    @Override
    public Attr unwrap() {
        return this.attributeNode;
    }

    @Override
    public String name() {
        return this.attributeNode.getLocalName();
    }

    @Override
    public String namespace() {
        return this.attributeNode.getNamespaceURI();
    }

    @Override
    public String prefix() {
        return this.attributeNode.getPrefix();
    }

    @Override
    public boolean hasPrefix(String prefix) {
        String attributePrefix = this.attributeNode.getPrefix();
        if (attributePrefix == null) {
            return prefix == null;
        }
        return attributePrefix.equals(prefix);
    }

    @Override
    public boolean hasNamespace(String namespace) {
        String attributeNamespace = this.attributeNode.getNamespaceURI();
        if (attributeNamespace == null) {
            return namespace == null;
        }
        return attributeNamespace.equals(namespace);
    }

    @Override
    public String value() {
        return this.attributeNode.getValue();
    }

    @Override
    public SpinXmlAttribute value(String value) {
        if (value == null) {
            throw LOG.unableToSetAttributeValueToNull(this.namespace(), this.name());
        }
        this.attributeNode.setValue(value);
        return this;
    }

    @Override
    public SpinXmlElement remove() {
        Element ownerElement = this.attributeNode.getOwnerElement();
        ownerElement.removeAttributeNode(this.attributeNode);
        return this.dataFormat.createElementWrapper(ownerElement);
    }

    @Override
    public String toString() {
        return this.value();
    }

    @Override
    public void writeToWriter(Writer writer) {
        try {
            writer.write(this.toString());
        }
        catch (IOException e) {
            throw LOG.unableToWriteAttribute(this, e);
        }
    }

    @Override
    public <C> C mapTo(Class<C> javaClass) {
        DomXmlDataFormatMapper mapper = this.dataFormat.getMapper();
        return mapper.mapInternalToJava((Object)this, javaClass);
    }

    @Override
    public <C> C mapTo(String javaClass) {
        DomXmlDataFormatMapper mapper = this.dataFormat.getMapper();
        return (C)mapper.mapInternalToJava((Object)this, javaClass);
    }
}

