/*
 * Decompiled with CFR 0.152.
 */
package spinjar.com.jayway.jsonpath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import spinjar.com.jayway.jsonpath.Configuration;
import spinjar.com.jayway.jsonpath.Filter;
import spinjar.com.jayway.jsonpath.InvalidCriteriaException;
import spinjar.com.jayway.jsonpath.InvalidPathException;
import spinjar.com.jayway.jsonpath.JsonPath;
import spinjar.com.jayway.jsonpath.Option;
import spinjar.com.jayway.jsonpath.internal.Utils;

public class Criteria {
    private static final Object NOT_SET = new Object();
    private final JsonPath key;
    private final List<Criteria> criteriaChain;
    private final LinkedHashMap<CriteriaType, Object> criteria = new LinkedHashMap();
    private Object isValue = NOT_SET;

    private Criteria(String key) {
        Utils.notEmpty(key, "key can not be null or empty", new Object[0]);
        this.criteriaChain = new ArrayList<Criteria>();
        this.criteriaChain.add(this);
        this.key = JsonPath.compile(key, new Filter[0]);
    }

    private Criteria(List<Criteria> criteriaChain, String key) {
        Utils.notEmpty(key, "key can not be null or empty", new Object[0]);
        this.criteriaChain = criteriaChain;
        this.criteriaChain.add(this);
        this.key = JsonPath.compile(key, new Filter[0]);
    }

    JsonPath getKey() {
        return this.key;
    }

    boolean matches(Map<String, Object> map, Configuration configuration) {
        if (this.criteriaChain.size() == 1) {
            return this.criteriaChain.get(0).singleObjectApply(map, configuration);
        }
        for (Criteria c : this.criteriaChain) {
            if (c.singleObjectApply(map, configuration)) continue;
            return false;
        }
        return true;
    }

    private static Object readSafely(JsonPath path, Map<String, Object> map) {
        try {
            return path.read(map);
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    private static <T> boolean objectOrAnyCollectionItemMatches(Object singleObjectOrCollection, Predicate<T> predicate) {
        if (singleObjectOrCollection instanceof Collection) {
            Iterator it = ((Collection)singleObjectOrCollection).iterator();
            while (it.hasNext()) {
                if (!predicate.accept(it.next())) continue;
                return true;
            }
            return false;
        }
        return predicate.accept(singleObjectOrCollection);
    }

    boolean singleObjectApply(Map<String, Object> map, final Configuration configuration) {
        Iterator<CriteriaType> i$ = this.criteria.keySet().iterator();
        if (i$.hasNext()) {
            CriteriaType key = i$.next();
            Object actualVal = Criteria.readSafely(this.key, map);
            final Object expectedVal = this.criteria.get((Object)key);
            if (CriteriaType.GT.equals((Object)key)) {
                if (expectedVal == null || actualVal == null) {
                    return false;
                }
                final Number expectedNumber = (Number)expectedVal;
                return Criteria.objectOrAnyCollectionItemMatches(actualVal, new Predicate<Number>(){

                    @Override
                    public boolean accept(Number value) {
                        return value.doubleValue() > expectedNumber.doubleValue();
                    }
                });
            }
            if (CriteriaType.GTE.equals((Object)key)) {
                if (expectedVal == null || actualVal == null) {
                    return false;
                }
                final Number expectedNumber = (Number)expectedVal;
                return Criteria.objectOrAnyCollectionItemMatches(actualVal, new Predicate<Number>(){

                    @Override
                    public boolean accept(Number value) {
                        return value.doubleValue() >= expectedNumber.doubleValue();
                    }
                });
            }
            if (CriteriaType.LT.equals((Object)key)) {
                if (expectedVal == null || actualVal == null) {
                    return false;
                }
                final Number expectedNumber = (Number)expectedVal;
                return Criteria.objectOrAnyCollectionItemMatches(actualVal, new Predicate<Number>(){

                    @Override
                    public boolean accept(Number value) {
                        return value.doubleValue() < expectedNumber.doubleValue();
                    }
                });
            }
            if (CriteriaType.LTE.equals((Object)key)) {
                if (expectedVal == null || actualVal == null) {
                    return false;
                }
                final Number expectedNumber = (Number)expectedVal;
                return Criteria.objectOrAnyCollectionItemMatches(actualVal, new Predicate<Number>(){

                    @Override
                    public boolean accept(Number value) {
                        return value.doubleValue() <= expectedNumber.doubleValue();
                    }
                });
            }
            if (CriteriaType.NE.equals((Object)key)) {
                return Criteria.objectOrAnyCollectionItemMatches(actualVal, new Predicate<Object>(){

                    @Override
                    public boolean accept(Object value) {
                        if (expectedVal == null && value == null) {
                            return false;
                        }
                        if (expectedVal == null) {
                            return true;
                        }
                        return !expectedVal.equals(value);
                    }
                });
            }
            if (CriteriaType.IN.equals((Object)key)) {
                Collection exp = (Collection)expectedVal;
                return exp.contains(actualVal);
            }
            if (CriteriaType.NIN.equals((Object)key)) {
                Collection exp = (Collection)expectedVal;
                return !exp.contains(actualVal);
            }
            if (CriteriaType.ALL.equals((Object)key)) {
                Collection exp = (Collection)expectedVal;
                Collection act = (Collection)actualVal;
                return act.containsAll(exp);
            }
            if (CriteriaType.SIZE.equals((Object)key)) {
                int exp = (Integer)expectedVal;
                List act = (List)actualVal;
                return act.size() == exp;
            }
            if (CriteriaType.NOT_EMPTY.equals((Object)key)) {
                if (actualVal == null) {
                    return false;
                }
                boolean empty = false;
                if (actualVal instanceof Collection) {
                    empty = ((List)actualVal).isEmpty();
                } else if (actualVal instanceof String) {
                    empty = ((String)actualVal).isEmpty();
                }
                return !empty;
            }
            if (CriteriaType.EXISTS.equals((Object)key)) {
                final boolean exp = (Boolean)expectedVal;
                return Criteria.objectOrAnyCollectionItemMatches(map, new Predicate<Object>(){

                    @Override
                    public boolean accept(Object value) {
                        boolean act = true;
                        try {
                            Object res = Criteria.this.getKey().read(value, configuration.options(Option.THROW_ON_MISSING_PROPERTY));
                            if (configuration.getProvider().isArray(res)) {
                                act = Criteria.this.getKey().isPathDefinite() ? true : configuration.getProvider().length(res) > 0;
                            }
                        }
                        catch (InvalidPathException e) {
                            act = false;
                        }
                        return act == exp;
                    }
                });
            }
            if (CriteriaType.TYPE.equals((Object)key)) {
                final Class exp = (Class)expectedVal;
                return Criteria.objectOrAnyCollectionItemMatches(actualVal, new Predicate<Object>(){

                    @Override
                    public boolean accept(Object value) {
                        Class<?> act;
                        Class<?> clazz = act = value == null ? null : value.getClass();
                        if (act == null) {
                            return false;
                        }
                        return act.equals(exp);
                    }
                });
            }
            if (CriteriaType.REGEX.equals((Object)key)) {
                final Pattern exp = (Pattern)expectedVal;
                return Criteria.objectOrAnyCollectionItemMatches(actualVal, new Predicate<String>(){

                    @Override
                    public boolean accept(String value) {
                        return value != null && exp.matcher(value).matches();
                    }
                });
            }
            throw new UnsupportedOperationException("Criteria type not supported: " + key.name());
        }
        if (this.isValue != NOT_SET) {
            if (this.isValue instanceof Collection) {
                Collection cs = (Collection)this.isValue;
                for (Criteria crit : cs) {
                    for (Criteria c : crit.criteriaChain) {
                        if (c.singleObjectApply(map, configuration)) continue;
                        return false;
                    }
                }
                return true;
            }
            Object actualVal = Criteria.readSafely(this.key, map);
            return Criteria.objectOrAnyCollectionItemMatches(actualVal, new Predicate<Object>(){

                @Override
                public boolean accept(Object value) {
                    if (Criteria.this.isValue == null) {
                        return value == null;
                    }
                    return Criteria.this.isValue.equals(value);
                }
            });
        }
        return true;
    }

    public static Criteria where(String key) {
        return new Criteria(key);
    }

    public Criteria and(String key) {
        return new Criteria(this.criteriaChain, key);
    }

    public Criteria is(Object o) {
        if (this.isValue != NOT_SET) {
            throw new InvalidCriteriaException("Multiple 'is' values declared. You need to use 'and' with multiple criteria");
        }
        if (this.criteria.size() > 0 && "$not".equals(this.criteria.keySet().toArray()[this.criteria.size() - 1])) {
            throw new InvalidCriteriaException("Invalid query: 'not' can't be used with 'is' - use 'ne' instead.");
        }
        this.isValue = o;
        return this;
    }

    public Criteria eq(Object o) {
        return this.is(o);
    }

    public Criteria ne(Object o) {
        this.criteria.put(CriteriaType.NE, o);
        return this;
    }

    public Criteria lt(Object o) {
        this.criteria.put(CriteriaType.LT, o);
        return this;
    }

    public Criteria lte(Object o) {
        this.criteria.put(CriteriaType.LTE, o);
        return this;
    }

    public Criteria gt(Object o) {
        this.criteria.put(CriteriaType.GT, o);
        return this;
    }

    public Criteria gte(Object o) {
        this.criteria.put(CriteriaType.GTE, o);
        return this;
    }

    public Criteria in(Object ... o) {
        if (o.length > 1 && o[1] instanceof Collection) {
            throw new InvalidCriteriaException("You can only pass in one argument of type " + o[1].getClass().getName());
        }
        return this.in(Arrays.asList(o));
    }

    public Criteria in(Collection<?> c) {
        Utils.notNull(c, "collection can not be null", new Object[0]);
        this.checkFilterCanBeApplied(CriteriaType.IN);
        this.criteria.put(CriteriaType.IN, c);
        return this;
    }

    public Criteria nin(Object ... o) {
        return this.nin(Arrays.asList(o));
    }

    public Criteria nin(Collection<?> c) {
        Utils.notNull(c, "collection can not be null", new Object[0]);
        this.checkFilterCanBeApplied(CriteriaType.NIN);
        this.criteria.put(CriteriaType.NIN, c);
        return this;
    }

    public Criteria all(Object ... o) {
        return this.all(Arrays.asList(o));
    }

    public Criteria all(Collection<?> c) {
        Utils.notNull(c, "collection can not be null", new Object[0]);
        this.checkFilterCanBeApplied(CriteriaType.ALL);
        this.criteria.put(CriteriaType.ALL, c);
        return this;
    }

    public Criteria size(int s) {
        this.checkFilterCanBeApplied(CriteriaType.SIZE);
        this.criteria.put(CriteriaType.SIZE, s);
        return this;
    }

    public Criteria notEmpty() {
        this.checkFilterCanBeApplied(CriteriaType.NOT_EMPTY);
        this.criteria.put(CriteriaType.NOT_EMPTY, null);
        return this;
    }

    public Criteria exists(boolean b) {
        this.criteria.put(CriteriaType.EXISTS, b);
        return this;
    }

    public Criteria type(Class<?> t) {
        Utils.notNull(t, "type can not be null", new Object[0]);
        this.criteria.put(CriteriaType.TYPE, t);
        return this;
    }

    public Criteria regex(Pattern pattern) {
        Utils.notNull(pattern, "pattern can not be null", new Object[0]);
        this.criteria.put(CriteriaType.REGEX, pattern);
        return this;
    }

    public Criteria andOperator(Criteria ... criteria) {
        this.criteriaChain.add(new Criteria("$and").is(Arrays.asList(criteria)));
        return this;
    }

    private void checkFilterCanBeApplied(CriteriaType type) {
        if (this.getKey().getTokenizer().size() > 2) {
            throw new IllegalArgumentException("Cannot use " + (Object)((Object)type) + " filter on a multi-level path expression");
        }
    }

    private static interface Predicate<T> {
        public boolean accept(T var1);
    }

    private static enum CriteriaType {
        GT,
        GTE,
        LT,
        LTE,
        NE,
        IN,
        NIN,
        ALL,
        SIZE,
        EXISTS,
        TYPE,
        REGEX,
        NOT_EMPTY,
        OR;

    }
}

