/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.impl.logging;

import java.io.IOException;
import java.util.Collection;
import org.camunda.spin.SpinFileNotFoundException;
import org.camunda.spin.SpinRuntimeException;
import org.camunda.spin.SpinScriptException;
import org.camunda.spin.impl.logging.SpinLogger;
import org.camunda.spin.spi.DataFormat;
import org.camunda.spin.spi.DataFormatConfigurator;
import org.camunda.spin.spi.DataFormatProvider;
import org.camunda.spin.spi.SpinDataFormatException;
import org.camunda.spin.xml.SpinXmlElement;
import org.camunda.spin.xml.SpinXmlElementException;

public class SpinCoreLogger
extends SpinLogger {
    public IllegalArgumentException unsupportedInputParameter(Class<?> parameterClass) {
        return new IllegalArgumentException(this.exceptionMessage("001", "Unsupported input of type '{}'", new Object[]{parameterClass.getName()}));
    }

    public SpinFileNotFoundException fileNotFoundException(String filename, Throwable cause) {
        return new SpinFileNotFoundException(this.exceptionMessage("002", "Unable to find file with path '{}'", new Object[]{filename}), cause);
    }

    public SpinFileNotFoundException fileNotFoundException(String filename) {
        return this.fileNotFoundException(filename, null);
    }

    public SpinRuntimeException unableToReadFromReader(Exception e) {
        return new SpinRuntimeException(this.exceptionMessage("003", "Unable to read from reader", new Object[0]), e);
    }

    public SpinDataFormatException unrecognizableDataFormatException() {
        return new SpinDataFormatException(this.exceptionMessage("004", "No matching data format detected", new Object[0]));
    }

    public SpinXmlElementException elementIsNotChildOfThisElement(SpinXmlElement existingChildElement, SpinXmlElement parentDomElement) {
        return new SpinXmlElementException(this.exceptionMessage("005", "The element with namespace '{}' and name '{}' is not a child element of the element with namespace '{}' and name '{}'", new Object[]{existingChildElement.namespace(), existingChildElement.name(), parentDomElement.namespace(), parentDomElement.name()}));
    }

    public SpinScriptException noScriptEnvFoundForLanguage(String scriptLanguage, String path) {
        return new SpinScriptException(this.exceptionMessage("006", "No script script env found for script language '{}' at path '{}'", new Object[]{scriptLanguage, path}));
    }

    public IOException unableToRewindReader() {
        return new IOException(this.exceptionMessage("007", "Unable to rewind input stream: rewind buffering limit exceeded", new Object[0]));
    }

    public SpinDataFormatException multipleProvidersForDataformat(String dataFormatName) {
        return new SpinDataFormatException(this.exceptionMessage("008", "Multiple providers found for dataformat '{}'", new Object[]{dataFormatName}));
    }

    public void logDataFormats(Collection<DataFormat<?>> formats) {
        if (this.isInfoEnabled()) {
            for (DataFormat<?> format : formats) {
                this.logDataFormat(format);
            }
        }
    }

    protected void logDataFormat(DataFormat<?> dataFormat) {
        this.logInfo("009", "Discovered Spin data format: {}[name = {}]", new Object[]{dataFormat.getClass().getName(), dataFormat.getName()});
    }

    public void logDataFormatProvider(DataFormatProvider provider) {
        if (this.isInfoEnabled()) {
            this.logInfo("010", "Discovered Spin data format provider: {}[name = {}]", new Object[]{provider.getClass().getName(), provider.getDataFormatName()});
        }
    }

    public void logDataFormatConfigurator(DataFormatConfigurator configurator) {
        if (this.isInfoEnabled()) {
            this.logInfo("011", "Discovered Spin data format configurator: {}[dataformat = {}]", new Object[]{configurator.getClass(), configurator.getDataFormatClass().getName()});
        }
    }
}

