/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.ActivityInstanceIncidentDto;

@ApiModel(description="A JSON object corresponding to the Activity Instance tree of the given process instance.")
public class TransitionInstanceDto {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_PARENT_ACTIVITY_INSTANCE_ID = "parentActivityInstanceId";
    @SerializedName(value="parentActivityInstanceId")
    private String parentActivityInstanceId;
    public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
    @SerializedName(value="activityId")
    private String activityId;
    public static final String SERIALIZED_NAME_ACTIVITY_NAME = "activityName";
    @SerializedName(value="activityName")
    private String activityName;
    public static final String SERIALIZED_NAME_ACTIVITY_TYPE = "activityType";
    @SerializedName(value="activityType")
    private String activityType;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
    @SerializedName(value="executionId")
    private String executionId;
    public static final String SERIALIZED_NAME_INCIDENT_IDS = "incidentIds";
    @SerializedName(value="incidentIds")
    private List<String> incidentIds = null;
    public static final String SERIALIZED_NAME_INCIDENTS = "incidents";
    @SerializedName(value="incidents")
    private List<ActivityInstanceIncidentDto> incidents = null;

    public TransitionInstanceDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the transition instance.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TransitionInstanceDto parentActivityInstanceId(String parentActivityInstanceId) {
        this.parentActivityInstanceId = parentActivityInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the parent activity instance, for example a sub process instance.")
    public String getParentActivityInstanceId() {
        return this.parentActivityInstanceId;
    }

    public void setParentActivityInstanceId(String parentActivityInstanceId) {
        this.parentActivityInstanceId = parentActivityInstanceId;
    }

    public TransitionInstanceDto activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the activity that this instance enters (asyncBefore job) or leaves (asyncAfter job)")
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public TransitionInstanceDto activityName(String activityName) {
        this.activityName = activityName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the activity that this instance enters (asyncBefore job) or leaves (asyncAfter job)")
    public String getActivityName() {
        return this.activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public TransitionInstanceDto activityType(String activityType) {
        this.activityType = activityType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the activity that this instance enters (asyncBefore job) or leaves (asyncAfter job)")
    public String getActivityType() {
        return this.activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public TransitionInstanceDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process instance this instance is part of.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public TransitionInstanceDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process definition.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public TransitionInstanceDto executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The execution id.")
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public TransitionInstanceDto incidentIds(List<String> incidentIds) {
        this.incidentIds = incidentIds;
        return this;
    }

    public TransitionInstanceDto addIncidentIdsItem(String incidentIdsItem) {
        if (this.incidentIds == null) {
            this.incidentIds = new ArrayList<String>();
        }
        this.incidentIds.add(incidentIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of incident ids.")
    public List<String> getIncidentIds() {
        return this.incidentIds;
    }

    public void setIncidentIds(List<String> incidentIds) {
        this.incidentIds = incidentIds;
    }

    public TransitionInstanceDto incidents(List<ActivityInstanceIncidentDto> incidents) {
        this.incidents = incidents;
        return this;
    }

    public TransitionInstanceDto addIncidentsItem(ActivityInstanceIncidentDto incidentsItem) {
        if (this.incidents == null) {
            this.incidents = new ArrayList<ActivityInstanceIncidentDto>();
        }
        this.incidents.add(incidentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of JSON objects containing incident specific properties: * `id`: the id of the incident * `activityId`: the activity id in which the incident occurred")
    public List<ActivityInstanceIncidentDto> getIncidents() {
        return this.incidents;
    }

    public void setIncidents(List<ActivityInstanceIncidentDto> incidents) {
        this.incidents = incidents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransitionInstanceDto transitionInstanceDto = (TransitionInstanceDto)o;
        return Objects.equals(this.id, transitionInstanceDto.id) && Objects.equals(this.parentActivityInstanceId, transitionInstanceDto.parentActivityInstanceId) && Objects.equals(this.activityId, transitionInstanceDto.activityId) && Objects.equals(this.activityName, transitionInstanceDto.activityName) && Objects.equals(this.activityType, transitionInstanceDto.activityType) && Objects.equals(this.processInstanceId, transitionInstanceDto.processInstanceId) && Objects.equals(this.processDefinitionId, transitionInstanceDto.processDefinitionId) && Objects.equals(this.executionId, transitionInstanceDto.executionId) && Objects.equals(this.incidentIds, transitionInstanceDto.incidentIds) && Objects.equals(this.incidents, transitionInstanceDto.incidents);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.parentActivityInstanceId, this.activityId, this.activityName, this.activityType, this.processInstanceId, this.processDefinitionId, this.executionId, this.incidentIds, this.incidents);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransitionInstanceDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    parentActivityInstanceId: ").append(this.toIndentedString(this.parentActivityInstanceId)).append("\n");
        sb.append("    activityId: ").append(this.toIndentedString(this.activityId)).append("\n");
        sb.append("    activityName: ").append(this.toIndentedString(this.activityName)).append("\n");
        sb.append("    activityType: ").append(this.toIndentedString(this.activityType)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    executionId: ").append(this.toIndentedString(this.executionId)).append("\n");
        sb.append("    incidentIds: ").append(this.toIndentedString(this.incidentIds)).append("\n");
        sb.append("    incidents: ").append(this.toIndentedString(this.incidents)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

