/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.HistoricProcessInstanceQueryDto;
import org.camunda.community.rest.client.dto.ProcessInstanceQueryDto;
import org.camunda.community.rest.client.dto.VariableValueDto;

public class SetVariablesAsyncDto {
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_IDS = "processInstanceIds";
    @SerializedName(value="processInstanceIds")
    private List<String> processInstanceIds = null;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_QUERY = "processInstanceQuery";
    @SerializedName(value="processInstanceQuery")
    private ProcessInstanceQueryDto processInstanceQuery;
    public static final String SERIALIZED_NAME_HISTORIC_PROCESS_INSTANCE_QUERY = "historicProcessInstanceQuery";
    @SerializedName(value="historicProcessInstanceQuery")
    private HistoricProcessInstanceQueryDto historicProcessInstanceQuery;
    public static final String SERIALIZED_NAME_VARIABLES = "variables";
    @SerializedName(value="variables")
    private Map<String, VariableValueDto> variables = null;

    public SetVariablesAsyncDto processInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
        return this;
    }

    public SetVariablesAsyncDto addProcessInstanceIdsItem(String processInstanceIdsItem) {
        if (this.processInstanceIds == null) {
            this.processInstanceIds = new ArrayList<String>();
        }
        this.processInstanceIds.add(processInstanceIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of process instance ids that define a group of process instances to which the operation will set variables.  Please note that if `processInstanceIds`, `processInstanceQuery` and `historicProcessInstanceQuery` are defined, the resulting operation will be performed on the union of these sets.")
    public List<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public void setProcessInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
    }

    public SetVariablesAsyncDto processInstanceQuery(ProcessInstanceQueryDto processInstanceQuery) {
        this.processInstanceQuery = processInstanceQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ProcessInstanceQueryDto getProcessInstanceQuery() {
        return this.processInstanceQuery;
    }

    public void setProcessInstanceQuery(ProcessInstanceQueryDto processInstanceQuery) {
        this.processInstanceQuery = processInstanceQuery;
    }

    public SetVariablesAsyncDto historicProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public HistoricProcessInstanceQueryDto getHistoricProcessInstanceQuery() {
        return this.historicProcessInstanceQuery;
    }

    public void setHistoricProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
    }

    public SetVariablesAsyncDto variables(Map<String, VariableValueDto> variables) {
        this.variables = variables;
        return this;
    }

    public SetVariablesAsyncDto putVariablesItem(String key, VariableValueDto variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, VariableValueDto>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A variables the operation will set in the root scope of the process instances.")
    public Map<String, VariableValueDto> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, VariableValueDto> variables) {
        this.variables = variables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetVariablesAsyncDto setVariablesAsyncDto = (SetVariablesAsyncDto)o;
        return Objects.equals(this.processInstanceIds, setVariablesAsyncDto.processInstanceIds) && Objects.equals(this.processInstanceQuery, setVariablesAsyncDto.processInstanceQuery) && Objects.equals(this.historicProcessInstanceQuery, setVariablesAsyncDto.historicProcessInstanceQuery) && Objects.equals(this.variables, setVariablesAsyncDto.variables);
    }

    public int hashCode() {
        return Objects.hash(this.processInstanceIds, this.processInstanceQuery, this.historicProcessInstanceQuery, this.variables);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SetVariablesAsyncDto {\n");
        sb.append("    processInstanceIds: ").append(this.toIndentedString(this.processInstanceIds)).append("\n");
        sb.append("    processInstanceQuery: ").append(this.toIndentedString(this.processInstanceQuery)).append("\n");
        sb.append("    historicProcessInstanceQuery: ").append(this.toIndentedString(this.historicProcessInstanceQuery)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

