/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

public class MultipleProcessInstanceModificationInstructionDto {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
    @SerializedName(value="activityId")
    private String activityId;
    public static final String SERIALIZED_NAME_TRANSITION_ID = "transitionId";
    @SerializedName(value="transitionId")
    private String transitionId;
    public static final String SERIALIZED_NAME_CANCEL_CURRENT_ACTIVE_ACTIVITY_INSTANCES = "cancelCurrentActiveActivityInstances";
    @SerializedName(value="cancelCurrentActiveActivityInstances")
    private Boolean cancelCurrentActiveActivityInstances;

    public MultipleProcessInstanceModificationInstructionDto type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="**Mandatory**. One of the following values: `cancel`, `startBeforeActivity`, `startAfterActivity`, `startTransition`.  * A cancel instruction requests cancellation of a single activity instance or all instances of one activity. * A startBeforeActivity instruction requests to enter a given activity. * A startAfterActivity instruction requests to execute the single outgoing sequence flow of a given activity. * A startTransition instruction requests to execute a specific sequence flow.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public MultipleProcessInstanceModificationInstructionDto activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Can be used with instructions of types `startTransition`. Specifies the sequence flow to start.")
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public MultipleProcessInstanceModificationInstructionDto transitionId(String transitionId) {
        this.transitionId = transitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Can be used with instructions of types `startTransition`. Specifies the sequence flow to start.")
    public String getTransitionId() {
        return this.transitionId;
    }

    public void setTransitionId(String transitionId) {
        this.transitionId = transitionId;
    }

    public MultipleProcessInstanceModificationInstructionDto cancelCurrentActiveActivityInstances(Boolean cancelCurrentActiveActivityInstances) {
        this.cancelCurrentActiveActivityInstances = cancelCurrentActiveActivityInstances;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Can be used with instructions of type cancel. Prevents the deletion of new created activity instances.")
    public Boolean getCancelCurrentActiveActivityInstances() {
        return this.cancelCurrentActiveActivityInstances;
    }

    public void setCancelCurrentActiveActivityInstances(Boolean cancelCurrentActiveActivityInstances) {
        this.cancelCurrentActiveActivityInstances = cancelCurrentActiveActivityInstances;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultipleProcessInstanceModificationInstructionDto multipleProcessInstanceModificationInstructionDto = (MultipleProcessInstanceModificationInstructionDto)o;
        return Objects.equals((Object)this.type, (Object)multipleProcessInstanceModificationInstructionDto.type) && Objects.equals(this.activityId, multipleProcessInstanceModificationInstructionDto.activityId) && Objects.equals(this.transitionId, multipleProcessInstanceModificationInstructionDto.transitionId) && Objects.equals(this.cancelCurrentActiveActivityInstances, multipleProcessInstanceModificationInstructionDto.cancelCurrentActiveActivityInstances);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.activityId, this.transitionId, this.cancelCurrentActiveActivityInstances});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MultipleProcessInstanceModificationInstructionDto {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    activityId: ").append(this.toIndentedString(this.activityId)).append("\n");
        sb.append("    transitionId: ").append(this.toIndentedString(this.transitionId)).append("\n");
        sb.append("    cancelCurrentActiveActivityInstances: ").append(this.toIndentedString(this.cancelCurrentActiveActivityInstances)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        CANCEL("cancel"),
        STARTBEFOREACTIVITY("startBeforeActivity"),
        STARTAFTERACTIVITY("startAfterActivity"),
        STARTTRANSITION("startTransition");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

