/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

public class JobSuspensionStateDto {
    public static final String SERIALIZED_NAME_JOB_DEFINITION_ID = "jobDefinitionId";
    @SerializedName(value="jobDefinitionId")
    private String jobDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @SerializedName(value="processDefinitionKey")
    private String processDefinitionKey;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_TENANT_ID = "processDefinitionTenantId";
    @SerializedName(value="processDefinitionTenantId")
    private String processDefinitionTenantId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_WITHOUT_TENANT_ID = "processDefinitionWithoutTenantId";
    @SerializedName(value="processDefinitionWithoutTenantId")
    private Boolean processDefinitionWithoutTenantId;
    public static final String SERIALIZED_NAME_SUSPENDED = "suspended";
    @SerializedName(value="suspended")
    private Boolean suspended;

    public JobSuspensionStateDto jobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The job definition id of the jobs to activate or suspend.")
    public String getJobDefinitionId() {
        return this.jobDefinitionId;
    }

    public void setJobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
    }

    public JobSuspensionStateDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The process definition id of the jobs to activate or suspend.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public JobSuspensionStateDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The process instance id of the jobs to activate or suspend.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public JobSuspensionStateDto processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The process definition key of the jobs to activate or suspend.")
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public JobSuspensionStateDto processDefinitionTenantId(String processDefinitionTenantId) {
        this.processDefinitionTenantId = processDefinitionTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only activate or suspend jobs of a process definition which belongs to a tenant with the given id. Works only when selecting with `processDefinitionKey`.")
    public String getProcessDefinitionTenantId() {
        return this.processDefinitionTenantId;
    }

    public void setProcessDefinitionTenantId(String processDefinitionTenantId) {
        this.processDefinitionTenantId = processDefinitionTenantId;
    }

    public JobSuspensionStateDto processDefinitionWithoutTenantId(Boolean processDefinitionWithoutTenantId) {
        this.processDefinitionWithoutTenantId = processDefinitionWithoutTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only activate or suspend jobs of a process definition which belongs to no tenant. Value may only be `true`, as `false` is the default behavior. Works only when selecting with `processDefinitionKey`.")
    public Boolean getProcessDefinitionWithoutTenantId() {
        return this.processDefinitionWithoutTenantId;
    }

    public void setProcessDefinitionWithoutTenantId(Boolean processDefinitionWithoutTenantId) {
        this.processDefinitionWithoutTenantId = processDefinitionWithoutTenantId;
    }

    public JobSuspensionStateDto suspended(Boolean suspended) {
        this.suspended = suspended;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A Boolean value which indicates whether to activate or suspend a given instance  (e.g. process instance, job, job definition, or batch). When the value is set to true,  the given instance will be suspended and when the value is set to false,  the given instance will be activated.")
    public Boolean getSuspended() {
        return this.suspended;
    }

    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobSuspensionStateDto jobSuspensionStateDto = (JobSuspensionStateDto)o;
        return Objects.equals(this.jobDefinitionId, jobSuspensionStateDto.jobDefinitionId) && Objects.equals(this.processDefinitionId, jobSuspensionStateDto.processDefinitionId) && Objects.equals(this.processInstanceId, jobSuspensionStateDto.processInstanceId) && Objects.equals(this.processDefinitionKey, jobSuspensionStateDto.processDefinitionKey) && Objects.equals(this.processDefinitionTenantId, jobSuspensionStateDto.processDefinitionTenantId) && Objects.equals(this.processDefinitionWithoutTenantId, jobSuspensionStateDto.processDefinitionWithoutTenantId) && Objects.equals(this.suspended, jobSuspensionStateDto.suspended);
    }

    public int hashCode() {
        return Objects.hash(this.jobDefinitionId, this.processDefinitionId, this.processInstanceId, this.processDefinitionKey, this.processDefinitionTenantId, this.processDefinitionWithoutTenantId, this.suspended);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobSuspensionStateDto {\n");
        sb.append("    jobDefinitionId: ").append(this.toIndentedString(this.jobDefinitionId)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    processDefinitionTenantId: ").append(this.toIndentedString(this.processDefinitionTenantId)).append("\n");
        sb.append("    processDefinitionWithoutTenantId: ").append(this.toIndentedString(this.processDefinitionWithoutTenantId)).append("\n");
        sb.append("    suspended: ").append(this.toIndentedString(this.suspended)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

