/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.JobConditionQueryParameterDto;
import org.camunda.community.rest.client.dto.JobQueryDtoSorting;

@ApiModel(description="A Job instance query which defines a list of Job instances")
public class JobQueryDto {
    public static final String SERIALIZED_NAME_JOB_ID = "jobId";
    @SerializedName(value="jobId")
    private String jobId;
    public static final String SERIALIZED_NAME_JOB_IDS = "jobIds";
    @SerializedName(value="jobIds")
    private List<String> jobIds = null;
    public static final String SERIALIZED_NAME_JOB_DEFINITION_ID = "jobDefinitionId";
    @SerializedName(value="jobDefinitionId")
    private String jobDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_IDS = "processInstanceIds";
    @SerializedName(value="processInstanceIds")
    private List<String> processInstanceIds = null;
    public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
    @SerializedName(value="executionId")
    private String executionId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @SerializedName(value="processDefinitionKey")
    private String processDefinitionKey;
    public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
    @SerializedName(value="activityId")
    private String activityId;
    public static final String SERIALIZED_NAME_WITH_RETRIES_LEFT = "withRetriesLeft";
    @SerializedName(value="withRetriesLeft")
    private Boolean withRetriesLeft;
    public static final String SERIALIZED_NAME_EXECUTABLE = "executable";
    @SerializedName(value="executable")
    private Boolean executable;
    public static final String SERIALIZED_NAME_TIMERS = "timers";
    @SerializedName(value="timers")
    private Boolean timers;
    public static final String SERIALIZED_NAME_MESSAGES = "messages";
    @SerializedName(value="messages")
    private Boolean messages;
    public static final String SERIALIZED_NAME_DUE_DATES = "dueDates";
    @SerializedName(value="dueDates")
    private List<JobConditionQueryParameterDto> dueDates = null;
    public static final String SERIALIZED_NAME_CREATE_TIMES = "createTimes";
    @SerializedName(value="createTimes")
    private List<JobConditionQueryParameterDto> createTimes = null;
    public static final String SERIALIZED_NAME_WITH_EXCEPTION = "withException";
    @SerializedName(value="withException")
    private Boolean withException;
    public static final String SERIALIZED_NAME_EXCEPTION_MESSAGE = "exceptionMessage";
    @SerializedName(value="exceptionMessage")
    private String exceptionMessage;
    public static final String SERIALIZED_NAME_FAILED_ACTIVITY_ID = "failedActivityId";
    @SerializedName(value="failedActivityId")
    private String failedActivityId;
    public static final String SERIALIZED_NAME_NO_RETRIES_LEFT = "noRetriesLeft";
    @SerializedName(value="noRetriesLeft")
    private Boolean noRetriesLeft;
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    private Boolean active;
    public static final String SERIALIZED_NAME_SUSPENDED = "suspended";
    @SerializedName(value="suspended")
    private Boolean suspended;
    public static final String SERIALIZED_NAME_PRIORITY_LOWER_THAN_OR_EQUALS = "priorityLowerThanOrEquals";
    @SerializedName(value="priorityLowerThanOrEquals")
    private Long priorityLowerThanOrEquals;
    public static final String SERIALIZED_NAME_PRIORITY_HIGHER_THAN_OR_EQUALS = "priorityHigherThanOrEquals";
    @SerializedName(value="priorityHigherThanOrEquals")
    private Long priorityHigherThanOrEquals;
    public static final String SERIALIZED_NAME_TENANT_ID_IN = "tenantIdIn";
    @SerializedName(value="tenantIdIn")
    private List<String> tenantIdIn = null;
    public static final String SERIALIZED_NAME_WITHOUT_TENANT_ID = "withoutTenantId";
    @SerializedName(value="withoutTenantId")
    private Boolean withoutTenantId;
    public static final String SERIALIZED_NAME_INCLUDE_JOBS_WITHOUT_TENANT_ID = "includeJobsWithoutTenantId";
    @SerializedName(value="includeJobsWithoutTenantId")
    private Boolean includeJobsWithoutTenantId;
    public static final String SERIALIZED_NAME_SORTING = "sorting";
    @SerializedName(value="sorting")
    private List<JobQueryDtoSorting> sorting = null;

    public JobQueryDto jobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by job id.")
    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public JobQueryDto jobIds(List<String> jobIds) {
        this.jobIds = jobIds;
        return this;
    }

    public JobQueryDto addJobIdsItem(String jobIdsItem) {
        if (this.jobIds == null) {
            this.jobIds = new ArrayList<String>();
        }
        this.jobIds.add(jobIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by a  list of job ids.")
    public List<String> getJobIds() {
        return this.jobIds;
    }

    public void setJobIds(List<String> jobIds) {
        this.jobIds = jobIds;
    }

    public JobQueryDto jobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only select jobs which exist for the given job definition.")
    public String getJobDefinitionId() {
        return this.jobDefinitionId;
    }

    public void setJobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
    }

    public JobQueryDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only select jobs which exist for the given process instance.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public JobQueryDto processInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
        return this;
    }

    public JobQueryDto addProcessInstanceIdsItem(String processInstanceIdsItem) {
        if (this.processInstanceIds == null) {
            this.processInstanceIds = new ArrayList<String>();
        }
        this.processInstanceIds.add(processInstanceIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only select jobs which exist for the given  list of process instance ids.")
    public List<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public void setProcessInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
    }

    public JobQueryDto executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only select jobs which exist for the given execution.")
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public JobQueryDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the id of the process definition the jobs run on.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public JobQueryDto processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the key of the process definition the jobs run on.")
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public JobQueryDto activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only select jobs which exist for an activity with the given id.")
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public JobQueryDto withRetriesLeft(Boolean withRetriesLeft) {
        this.withRetriesLeft = withRetriesLeft;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only select jobs which have retries left. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getWithRetriesLeft() {
        return this.withRetriesLeft;
    }

    public void setWithRetriesLeft(Boolean withRetriesLeft) {
        this.withRetriesLeft = withRetriesLeft;
    }

    public JobQueryDto executable(Boolean executable) {
        this.executable = executable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only select jobs which are executable, i.e., retries > 0 and due date is `null` or due date is in the past. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getExecutable() {
        return this.executable;
    }

    public void setExecutable(Boolean executable) {
        this.executable = executable;
    }

    public JobQueryDto timers(Boolean timers) {
        this.timers = timers;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only select jobs that are timers. Cannot be used together with `messages`. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getTimers() {
        return this.timers;
    }

    public void setTimers(Boolean timers) {
        this.timers = timers;
    }

    public JobQueryDto messages(Boolean messages) {
        this.messages = messages;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only select jobs that are messages. Cannot be used together with `timers`. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getMessages() {
        return this.messages;
    }

    public void setMessages(Boolean messages) {
        this.messages = messages;
    }

    public JobQueryDto dueDates(List<JobConditionQueryParameterDto> dueDates) {
        this.dueDates = dueDates;
        return this;
    }

    public JobQueryDto addDueDatesItem(JobConditionQueryParameterDto dueDatesItem) {
        if (this.dueDates == null) {
            this.dueDates = new ArrayList<JobConditionQueryParameterDto>();
        }
        this.dueDates.add(dueDatesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only select jobs where the due date is lower or higher than the given date. ")
    public List<JobConditionQueryParameterDto> getDueDates() {
        return this.dueDates;
    }

    public void setDueDates(List<JobConditionQueryParameterDto> dueDates) {
        this.dueDates = dueDates;
    }

    public JobQueryDto createTimes(List<JobConditionQueryParameterDto> createTimes) {
        this.createTimes = createTimes;
        return this;
    }

    public JobQueryDto addCreateTimesItem(JobConditionQueryParameterDto createTimesItem) {
        if (this.createTimes == null) {
            this.createTimes = new ArrayList<JobConditionQueryParameterDto>();
        }
        this.createTimes.add(createTimesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only select jobs created before or after the given date. ")
    public List<JobConditionQueryParameterDto> getCreateTimes() {
        return this.createTimes;
    }

    public void setCreateTimes(List<JobConditionQueryParameterDto> createTimes) {
        this.createTimes = createTimes;
    }

    public JobQueryDto withException(Boolean withException) {
        this.withException = withException;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only select jobs that failed due to an exception. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getWithException() {
        return this.withException;
    }

    public void setWithException(Boolean withException) {
        this.withException = withException;
    }

    public JobQueryDto exceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only select jobs that failed due to an exception with the given message.")
    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public JobQueryDto failedActivityId(String failedActivityId) {
        this.failedActivityId = failedActivityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only select jobs that failed due to an exception at an activity with the given id.")
    public String getFailedActivityId() {
        return this.failedActivityId;
    }

    public void setFailedActivityId(String failedActivityId) {
        this.failedActivityId = failedActivityId;
    }

    public JobQueryDto noRetriesLeft(Boolean noRetriesLeft) {
        this.noRetriesLeft = noRetriesLeft;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only select jobs which have no retries left. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getNoRetriesLeft() {
        return this.noRetriesLeft;
    }

    public void setNoRetriesLeft(Boolean noRetriesLeft) {
        this.noRetriesLeft = noRetriesLeft;
    }

    public JobQueryDto active(Boolean active) {
        this.active = active;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include active jobs. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public JobQueryDto suspended(Boolean suspended) {
        this.suspended = suspended;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include suspended jobs. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getSuspended() {
        return this.suspended;
    }

    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public JobQueryDto priorityLowerThanOrEquals(Long priorityLowerThanOrEquals) {
        this.priorityLowerThanOrEquals = priorityLowerThanOrEquals;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include jobs with a priority lower than or equal to the given value. Value must be a valid `long` value.")
    public Long getPriorityLowerThanOrEquals() {
        return this.priorityLowerThanOrEquals;
    }

    public void setPriorityLowerThanOrEquals(Long priorityLowerThanOrEquals) {
        this.priorityLowerThanOrEquals = priorityLowerThanOrEquals;
    }

    public JobQueryDto priorityHigherThanOrEquals(Long priorityHigherThanOrEquals) {
        this.priorityHigherThanOrEquals = priorityHigherThanOrEquals;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include jobs with a priority higher than or equal to the given value. Value must be a valid `long` value.")
    public Long getPriorityHigherThanOrEquals() {
        return this.priorityHigherThanOrEquals;
    }

    public void setPriorityHigherThanOrEquals(Long priorityHigherThanOrEquals) {
        this.priorityHigherThanOrEquals = priorityHigherThanOrEquals;
    }

    public JobQueryDto tenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
        return this;
    }

    public JobQueryDto addTenantIdInItem(String tenantIdInItem) {
        if (this.tenantIdIn == null) {
            this.tenantIdIn = new ArrayList<String>();
        }
        this.tenantIdIn.add(tenantIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include jobs which belong to one of the passed  tenant ids.")
    public List<String> getTenantIdIn() {
        return this.tenantIdIn;
    }

    public void setTenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
    }

    public JobQueryDto withoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include jobs which belong to no tenant. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getWithoutTenantId() {
        return this.withoutTenantId;
    }

    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    public JobQueryDto includeJobsWithoutTenantId(Boolean includeJobsWithoutTenantId) {
        this.includeJobsWithoutTenantId = includeJobsWithoutTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Include jobs which belong to no tenant. Can be used in combination with `tenantIdIn`. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getIncludeJobsWithoutTenantId() {
        return this.includeJobsWithoutTenantId;
    }

    public void setIncludeJobsWithoutTenantId(Boolean includeJobsWithoutTenantId) {
        this.includeJobsWithoutTenantId = includeJobsWithoutTenantId;
    }

    public JobQueryDto sorting(List<JobQueryDtoSorting> sorting) {
        this.sorting = sorting;
        return this;
    }

    public JobQueryDto addSortingItem(JobQueryDtoSorting sortingItem) {
        if (this.sorting == null) {
            this.sorting = new ArrayList<JobQueryDtoSorting>();
        }
        this.sorting.add(sortingItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Does not have an effect for the `count` endpoint.")
    public List<JobQueryDtoSorting> getSorting() {
        return this.sorting;
    }

    public void setSorting(List<JobQueryDtoSorting> sorting) {
        this.sorting = sorting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobQueryDto jobQueryDto = (JobQueryDto)o;
        return Objects.equals(this.jobId, jobQueryDto.jobId) && Objects.equals(this.jobIds, jobQueryDto.jobIds) && Objects.equals(this.jobDefinitionId, jobQueryDto.jobDefinitionId) && Objects.equals(this.processInstanceId, jobQueryDto.processInstanceId) && Objects.equals(this.processInstanceIds, jobQueryDto.processInstanceIds) && Objects.equals(this.executionId, jobQueryDto.executionId) && Objects.equals(this.processDefinitionId, jobQueryDto.processDefinitionId) && Objects.equals(this.processDefinitionKey, jobQueryDto.processDefinitionKey) && Objects.equals(this.activityId, jobQueryDto.activityId) && Objects.equals(this.withRetriesLeft, jobQueryDto.withRetriesLeft) && Objects.equals(this.executable, jobQueryDto.executable) && Objects.equals(this.timers, jobQueryDto.timers) && Objects.equals(this.messages, jobQueryDto.messages) && Objects.equals(this.dueDates, jobQueryDto.dueDates) && Objects.equals(this.createTimes, jobQueryDto.createTimes) && Objects.equals(this.withException, jobQueryDto.withException) && Objects.equals(this.exceptionMessage, jobQueryDto.exceptionMessage) && Objects.equals(this.failedActivityId, jobQueryDto.failedActivityId) && Objects.equals(this.noRetriesLeft, jobQueryDto.noRetriesLeft) && Objects.equals(this.active, jobQueryDto.active) && Objects.equals(this.suspended, jobQueryDto.suspended) && Objects.equals(this.priorityLowerThanOrEquals, jobQueryDto.priorityLowerThanOrEquals) && Objects.equals(this.priorityHigherThanOrEquals, jobQueryDto.priorityHigherThanOrEquals) && Objects.equals(this.tenantIdIn, jobQueryDto.tenantIdIn) && Objects.equals(this.withoutTenantId, jobQueryDto.withoutTenantId) && Objects.equals(this.includeJobsWithoutTenantId, jobQueryDto.includeJobsWithoutTenantId) && Objects.equals(this.sorting, jobQueryDto.sorting);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.jobIds, this.jobDefinitionId, this.processInstanceId, this.processInstanceIds, this.executionId, this.processDefinitionId, this.processDefinitionKey, this.activityId, this.withRetriesLeft, this.executable, this.timers, this.messages, this.dueDates, this.createTimes, this.withException, this.exceptionMessage, this.failedActivityId, this.noRetriesLeft, this.active, this.suspended, this.priorityLowerThanOrEquals, this.priorityHigherThanOrEquals, this.tenantIdIn, this.withoutTenantId, this.includeJobsWithoutTenantId, this.sorting);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobQueryDto {\n");
        sb.append("    jobId: ").append(this.toIndentedString(this.jobId)).append("\n");
        sb.append("    jobIds: ").append(this.toIndentedString(this.jobIds)).append("\n");
        sb.append("    jobDefinitionId: ").append(this.toIndentedString(this.jobDefinitionId)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    processInstanceIds: ").append(this.toIndentedString(this.processInstanceIds)).append("\n");
        sb.append("    executionId: ").append(this.toIndentedString(this.executionId)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    activityId: ").append(this.toIndentedString(this.activityId)).append("\n");
        sb.append("    withRetriesLeft: ").append(this.toIndentedString(this.withRetriesLeft)).append("\n");
        sb.append("    executable: ").append(this.toIndentedString(this.executable)).append("\n");
        sb.append("    timers: ").append(this.toIndentedString(this.timers)).append("\n");
        sb.append("    messages: ").append(this.toIndentedString(this.messages)).append("\n");
        sb.append("    dueDates: ").append(this.toIndentedString(this.dueDates)).append("\n");
        sb.append("    createTimes: ").append(this.toIndentedString(this.createTimes)).append("\n");
        sb.append("    withException: ").append(this.toIndentedString(this.withException)).append("\n");
        sb.append("    exceptionMessage: ").append(this.toIndentedString(this.exceptionMessage)).append("\n");
        sb.append("    failedActivityId: ").append(this.toIndentedString(this.failedActivityId)).append("\n");
        sb.append("    noRetriesLeft: ").append(this.toIndentedString(this.noRetriesLeft)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    suspended: ").append(this.toIndentedString(this.suspended)).append("\n");
        sb.append("    priorityLowerThanOrEquals: ").append(this.toIndentedString(this.priorityLowerThanOrEquals)).append("\n");
        sb.append("    priorityHigherThanOrEquals: ").append(this.toIndentedString(this.priorityHigherThanOrEquals)).append("\n");
        sb.append("    tenantIdIn: ").append(this.toIndentedString(this.tenantIdIn)).append("\n");
        sb.append("    withoutTenantId: ").append(this.toIndentedString(this.withoutTenantId)).append("\n");
        sb.append("    includeJobsWithoutTenantId: ").append(this.toIndentedString(this.includeJobsWithoutTenantId)).append("\n");
        sb.append("    sorting: ").append(this.toIndentedString(this.sorting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

