/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nullable;

public class HistoricIncidentDto {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @SerializedName(value="processDefinitionKey")
    private String processDefinitionKey;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
    @SerializedName(value="executionId")
    private String executionId;
    public static final String SERIALIZED_NAME_ROOT_PROCESS_INSTANCE_ID = "rootProcessInstanceId";
    @SerializedName(value="rootProcessInstanceId")
    private String rootProcessInstanceId;
    public static final String SERIALIZED_NAME_CREATE_TIME = "createTime";
    @SerializedName(value="createTime")
    private Date createTime;
    public static final String SERIALIZED_NAME_END_TIME = "endTime";
    @SerializedName(value="endTime")
    private Date endTime;
    public static final String SERIALIZED_NAME_REMOVAL_TIME = "removalTime";
    @SerializedName(value="removalTime")
    private Date removalTime;
    public static final String SERIALIZED_NAME_INCIDENT_TYPE = "incidentType";
    @SerializedName(value="incidentType")
    private String incidentType;
    public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
    @SerializedName(value="activityId")
    private String activityId;
    public static final String SERIALIZED_NAME_FAILED_ACTIVITY_ID = "failedActivityId";
    @SerializedName(value="failedActivityId")
    private String failedActivityId;
    public static final String SERIALIZED_NAME_CAUSE_INCIDENT_ID = "causeIncidentId";
    @SerializedName(value="causeIncidentId")
    private String causeIncidentId;
    public static final String SERIALIZED_NAME_ROOT_CAUSE_INCIDENT_ID = "rootCauseIncidentId";
    @SerializedName(value="rootCauseIncidentId")
    private String rootCauseIncidentId;
    public static final String SERIALIZED_NAME_CONFIGURATION = "configuration";
    @SerializedName(value="configuration")
    private String _configuration;
    public static final String SERIALIZED_NAME_HISTORY_CONFIGURATION = "historyConfiguration";
    @SerializedName(value="historyConfiguration")
    private String historyConfiguration;
    public static final String SERIALIZED_NAME_INCIDENT_MESSAGE = "incidentMessage";
    @SerializedName(value="incidentMessage")
    private String incidentMessage;
    public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
    @SerializedName(value="tenantId")
    private String tenantId;
    public static final String SERIALIZED_NAME_JOB_DEFINITION_ID = "jobDefinitionId";
    @SerializedName(value="jobDefinitionId")
    private String jobDefinitionId;
    public static final String SERIALIZED_NAME_OPEN = "open";
    @SerializedName(value="open")
    private Boolean open;
    public static final String SERIALIZED_NAME_DELETED = "deleted";
    @SerializedName(value="deleted")
    private Boolean deleted;
    public static final String SERIALIZED_NAME_RESOLVED = "resolved";
    @SerializedName(value="resolved")
    private Boolean resolved;
    public static final String SERIALIZED_NAME_ANNOTATION = "annotation";
    @SerializedName(value="annotation")
    private String annotation;

    public HistoricIncidentDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the incident.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public HistoricIncidentDto processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key of the process definition this incident is associated with.")
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public HistoricIncidentDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process definition this incident is associated with.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public HistoricIncidentDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key of the process definition this incident is associated with.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public HistoricIncidentDto executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the execution this incident is associated with.")
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public HistoricIncidentDto rootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The process instance id of the root process instance that initiated the process containing this incident.")
    public String getRootProcessInstanceId() {
        return this.rootProcessInstanceId;
    }

    public void setRootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
    }

    public HistoricIncidentDto createTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time this incident happened.  [Default format](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.")
    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public HistoricIncidentDto endTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time this incident has been deleted or resolved.  [Default format](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.")
    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public HistoricIncidentDto removalTime(Date removalTime) {
        this.removalTime = removalTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time after which the incident should be removed by the History Cleanup job. [Default format](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.")
    public Date getRemovalTime() {
        return this.removalTime;
    }

    public void setRemovalTime(Date removalTime) {
        this.removalTime = removalTime;
    }

    public HistoricIncidentDto incidentType(String incidentType) {
        this.incidentType = incidentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of incident, for example: `failedJobs` will be returned in case of an incident which identified a failed job during the execution of a process instance. See the [User Guide](/manual/develop/user- guide/process-engine/incidents/#incident-types) for a list of incident types.")
    public String getIncidentType() {
        return this.incidentType;
    }

    public void setIncidentType(String incidentType) {
        this.incidentType = incidentType;
    }

    public HistoricIncidentDto activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the activity this incident is associated with.")
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public HistoricIncidentDto failedActivityId(String failedActivityId) {
        this.failedActivityId = failedActivityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the activity on which the last exception occurred.")
    public String getFailedActivityId() {
        return this.failedActivityId;
    }

    public void setFailedActivityId(String failedActivityId) {
        this.failedActivityId = failedActivityId;
    }

    public HistoricIncidentDto causeIncidentId(String causeIncidentId) {
        this.causeIncidentId = causeIncidentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the associated cause incident which has been triggered.")
    public String getCauseIncidentId() {
        return this.causeIncidentId;
    }

    public void setCauseIncidentId(String causeIncidentId) {
        this.causeIncidentId = causeIncidentId;
    }

    public HistoricIncidentDto rootCauseIncidentId(String rootCauseIncidentId) {
        this.rootCauseIncidentId = rootCauseIncidentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the associated root cause incident which has been triggered.")
    public String getRootCauseIncidentId() {
        return this.rootCauseIncidentId;
    }

    public void setRootCauseIncidentId(String rootCauseIncidentId) {
        this.rootCauseIncidentId = rootCauseIncidentId;
    }

    public HistoricIncidentDto _configuration(String _configuration) {
        this._configuration = _configuration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The payload of this incident.")
    public String getConfiguration() {
        return this._configuration;
    }

    public void setConfiguration(String _configuration) {
        this._configuration = _configuration;
    }

    public HistoricIncidentDto historyConfiguration(String historyConfiguration) {
        this.historyConfiguration = historyConfiguration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The payload of this incident at the time when it occurred.")
    public String getHistoryConfiguration() {
        return this.historyConfiguration;
    }

    public void setHistoryConfiguration(String historyConfiguration) {
        this.historyConfiguration = historyConfiguration;
    }

    public HistoricIncidentDto incidentMessage(String incidentMessage) {
        this.incidentMessage = incidentMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The message of this incident.")
    public String getIncidentMessage() {
        return this.incidentMessage;
    }

    public void setIncidentMessage(String incidentMessage) {
        this.incidentMessage = incidentMessage;
    }

    public HistoricIncidentDto tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the tenant this incident is associated with.")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public HistoricIncidentDto jobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The job definition id the incident is associated with.")
    public String getJobDefinitionId() {
        return this.jobDefinitionId;
    }

    public void setJobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
    }

    public HistoricIncidentDto open(Boolean open) {
        this.open = open;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, this incident is open.")
    public Boolean getOpen() {
        return this.open;
    }

    public void setOpen(Boolean open) {
        this.open = open;
    }

    public HistoricIncidentDto deleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, this incident has been deleted.")
    public Boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public HistoricIncidentDto resolved(Boolean resolved) {
        this.resolved = resolved;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, this incident has been resolved.")
    public Boolean getResolved() {
        return this.resolved;
    }

    public void setResolved(Boolean resolved) {
        this.resolved = resolved;
    }

    public HistoricIncidentDto annotation(String annotation) {
        this.annotation = annotation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The annotation set to the incident.")
    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricIncidentDto historicIncidentDto = (HistoricIncidentDto)o;
        return Objects.equals(this.id, historicIncidentDto.id) && Objects.equals(this.processDefinitionKey, historicIncidentDto.processDefinitionKey) && Objects.equals(this.processDefinitionId, historicIncidentDto.processDefinitionId) && Objects.equals(this.processInstanceId, historicIncidentDto.processInstanceId) && Objects.equals(this.executionId, historicIncidentDto.executionId) && Objects.equals(this.rootProcessInstanceId, historicIncidentDto.rootProcessInstanceId) && Objects.equals(this.createTime, historicIncidentDto.createTime) && Objects.equals(this.endTime, historicIncidentDto.endTime) && Objects.equals(this.removalTime, historicIncidentDto.removalTime) && Objects.equals(this.incidentType, historicIncidentDto.incidentType) && Objects.equals(this.activityId, historicIncidentDto.activityId) && Objects.equals(this.failedActivityId, historicIncidentDto.failedActivityId) && Objects.equals(this.causeIncidentId, historicIncidentDto.causeIncidentId) && Objects.equals(this.rootCauseIncidentId, historicIncidentDto.rootCauseIncidentId) && Objects.equals(this._configuration, historicIncidentDto._configuration) && Objects.equals(this.historyConfiguration, historicIncidentDto.historyConfiguration) && Objects.equals(this.incidentMessage, historicIncidentDto.incidentMessage) && Objects.equals(this.tenantId, historicIncidentDto.tenantId) && Objects.equals(this.jobDefinitionId, historicIncidentDto.jobDefinitionId) && Objects.equals(this.open, historicIncidentDto.open) && Objects.equals(this.deleted, historicIncidentDto.deleted) && Objects.equals(this.resolved, historicIncidentDto.resolved) && Objects.equals(this.annotation, historicIncidentDto.annotation);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.processDefinitionKey, this.processDefinitionId, this.processInstanceId, this.executionId, this.rootProcessInstanceId, this.createTime, this.endTime, this.removalTime, this.incidentType, this.activityId, this.failedActivityId, this.causeIncidentId, this.rootCauseIncidentId, this._configuration, this.historyConfiguration, this.incidentMessage, this.tenantId, this.jobDefinitionId, this.open, this.deleted, this.resolved, this.annotation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoricIncidentDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    executionId: ").append(this.toIndentedString(this.executionId)).append("\n");
        sb.append("    rootProcessInstanceId: ").append(this.toIndentedString(this.rootProcessInstanceId)).append("\n");
        sb.append("    createTime: ").append(this.toIndentedString(this.createTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    removalTime: ").append(this.toIndentedString(this.removalTime)).append("\n");
        sb.append("    incidentType: ").append(this.toIndentedString(this.incidentType)).append("\n");
        sb.append("    activityId: ").append(this.toIndentedString(this.activityId)).append("\n");
        sb.append("    failedActivityId: ").append(this.toIndentedString(this.failedActivityId)).append("\n");
        sb.append("    causeIncidentId: ").append(this.toIndentedString(this.causeIncidentId)).append("\n");
        sb.append("    rootCauseIncidentId: ").append(this.toIndentedString(this.rootCauseIncidentId)).append("\n");
        sb.append("    _configuration: ").append(this.toIndentedString(this._configuration)).append("\n");
        sb.append("    historyConfiguration: ").append(this.toIndentedString(this.historyConfiguration)).append("\n");
        sb.append("    incidentMessage: ").append(this.toIndentedString(this.incidentMessage)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    jobDefinitionId: ").append(this.toIndentedString(this.jobDefinitionId)).append("\n");
        sb.append("    open: ").append(this.toIndentedString(this.open)).append("\n");
        sb.append("    deleted: ").append(this.toIndentedString(this.deleted)).append("\n");
        sb.append("    resolved: ").append(this.toIndentedString(this.resolved)).append("\n");
        sb.append("    annotation: ").append(this.toIndentedString(this.annotation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

