/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.HistoricExternalTaskLogQueryDtoSorting;

@ApiModel(description="A Historic External Task Log instance query which defines a list of Historic External Task Log instances")
public class HistoricExternalTaskLogQueryDto {
    public static final String SERIALIZED_NAME_LOG_ID = "logId";
    @SerializedName(value="logId")
    private String logId;
    public static final String SERIALIZED_NAME_EXTERNAL_TASK_ID = "externalTaskId";
    @SerializedName(value="externalTaskId")
    private String externalTaskId;
    public static final String SERIALIZED_NAME_TOPIC_NAME = "topicName";
    @SerializedName(value="topicName")
    private String topicName;
    public static final String SERIALIZED_NAME_WORKER_ID = "workerId";
    @SerializedName(value="workerId")
    private String workerId;
    public static final String SERIALIZED_NAME_ERROR_MESSAGE = "errorMessage";
    @SerializedName(value="errorMessage")
    private String errorMessage;
    public static final String SERIALIZED_NAME_ACTIVITY_ID_IN = "activityIdIn";
    @SerializedName(value="activityIdIn")
    private List<String> activityIdIn = null;
    public static final String SERIALIZED_NAME_ACTIVITY_INSTANCE_ID_IN = "activityInstanceIdIn";
    @SerializedName(value="activityInstanceIdIn")
    private List<String> activityInstanceIdIn = null;
    public static final String SERIALIZED_NAME_EXECUTION_ID_IN = "executionIdIn";
    @SerializedName(value="executionIdIn")
    private List<String> executionIdIn = null;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @SerializedName(value="processDefinitionKey")
    private String processDefinitionKey;
    public static final String SERIALIZED_NAME_TENANT_ID_IN = "tenantIdIn";
    @SerializedName(value="tenantIdIn")
    private List<String> tenantIdIn = null;
    public static final String SERIALIZED_NAME_WITHOUT_TENANT_ID = "withoutTenantId";
    @SerializedName(value="withoutTenantId")
    private Boolean withoutTenantId;
    public static final String SERIALIZED_NAME_PRIORITY_LOWER_THAN_OR_EQUALS = "priorityLowerThanOrEquals";
    @SerializedName(value="priorityLowerThanOrEquals")
    private Long priorityLowerThanOrEquals;
    public static final String SERIALIZED_NAME_PRIORITY_HIGHER_THAN_OR_EQUALS = "priorityHigherThanOrEquals";
    @SerializedName(value="priorityHigherThanOrEquals")
    private Long priorityHigherThanOrEquals;
    public static final String SERIALIZED_NAME_CREATION_LOG = "creationLog";
    @SerializedName(value="creationLog")
    private Boolean creationLog;
    public static final String SERIALIZED_NAME_FAILURE_LOG = "failureLog";
    @SerializedName(value="failureLog")
    private Boolean failureLog;
    public static final String SERIALIZED_NAME_SUCCESS_LOG = "successLog";
    @SerializedName(value="successLog")
    private Boolean successLog;
    public static final String SERIALIZED_NAME_DELETION_LOG = "deletionLog";
    @SerializedName(value="deletionLog")
    private Boolean deletionLog;
    public static final String SERIALIZED_NAME_SORTING = "sorting";
    @SerializedName(value="sorting")
    private List<HistoricExternalTaskLogQueryDtoSorting> sorting = null;

    public HistoricExternalTaskLogQueryDto logId(String logId) {
        this.logId = logId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by historic external task log id.")
    public String getLogId() {
        return this.logId;
    }

    public void setLogId(String logId) {
        this.logId = logId;
    }

    public HistoricExternalTaskLogQueryDto externalTaskId(String externalTaskId) {
        this.externalTaskId = externalTaskId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by external task id.")
    public String getExternalTaskId() {
        return this.externalTaskId;
    }

    public void setExternalTaskId(String externalTaskId) {
        this.externalTaskId = externalTaskId;
    }

    public HistoricExternalTaskLogQueryDto topicName(String topicName) {
        this.topicName = topicName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by an external task topic.")
    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public HistoricExternalTaskLogQueryDto workerId(String workerId) {
        this.workerId = workerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the id of the worker that the task was most recently locked by.")
    public String getWorkerId() {
        return this.workerId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public HistoricExternalTaskLogQueryDto errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by external task exception message.")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public HistoricExternalTaskLogQueryDto activityIdIn(List<String> activityIdIn) {
        this.activityIdIn = activityIdIn;
        return this;
    }

    public HistoricExternalTaskLogQueryDto addActivityIdInItem(String activityIdInItem) {
        if (this.activityIdIn == null) {
            this.activityIdIn = new ArrayList<String>();
        }
        this.activityIdIn.add(activityIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic external task logs which belong to one of the passed activity ids.")
    public List<String> getActivityIdIn() {
        return this.activityIdIn;
    }

    public void setActivityIdIn(List<String> activityIdIn) {
        this.activityIdIn = activityIdIn;
    }

    public HistoricExternalTaskLogQueryDto activityInstanceIdIn(List<String> activityInstanceIdIn) {
        this.activityInstanceIdIn = activityInstanceIdIn;
        return this;
    }

    public HistoricExternalTaskLogQueryDto addActivityInstanceIdInItem(String activityInstanceIdInItem) {
        if (this.activityInstanceIdIn == null) {
            this.activityInstanceIdIn = new ArrayList<String>();
        }
        this.activityInstanceIdIn.add(activityInstanceIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic external task logs which belong to one of the passed activity instance ids.")
    public List<String> getActivityInstanceIdIn() {
        return this.activityInstanceIdIn;
    }

    public void setActivityInstanceIdIn(List<String> activityInstanceIdIn) {
        this.activityInstanceIdIn = activityInstanceIdIn;
    }

    public HistoricExternalTaskLogQueryDto executionIdIn(List<String> executionIdIn) {
        this.executionIdIn = executionIdIn;
        return this;
    }

    public HistoricExternalTaskLogQueryDto addExecutionIdInItem(String executionIdInItem) {
        if (this.executionIdIn == null) {
            this.executionIdIn = new ArrayList<String>();
        }
        this.executionIdIn.add(executionIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic external task logs which belong to one of the passed execution ids.")
    public List<String> getExecutionIdIn() {
        return this.executionIdIn;
    }

    public void setExecutionIdIn(List<String> executionIdIn) {
        this.executionIdIn = executionIdIn;
    }

    public HistoricExternalTaskLogQueryDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by process instance id.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public HistoricExternalTaskLogQueryDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by process definition id.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public HistoricExternalTaskLogQueryDto processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by process definition key.")
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public HistoricExternalTaskLogQueryDto tenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
        return this;
    }

    public HistoricExternalTaskLogQueryDto addTenantIdInItem(String tenantIdInItem) {
        if (this.tenantIdIn == null) {
            this.tenantIdIn = new ArrayList<String>();
        }
        this.tenantIdIn.add(tenantIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic external task log entries which belong to one of the passed and comma-separated tenant ids.")
    public List<String> getTenantIdIn() {
        return this.tenantIdIn;
    }

    public void setTenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
    }

    public HistoricExternalTaskLogQueryDto withoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic external task log entries that belong to no tenant. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getWithoutTenantId() {
        return this.withoutTenantId;
    }

    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    public HistoricExternalTaskLogQueryDto priorityLowerThanOrEquals(Long priorityLowerThanOrEquals) {
        this.priorityLowerThanOrEquals = priorityLowerThanOrEquals;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include logs for which the associated external task had a priority lower than or equal to the given value. Value must be a valid `long` value.")
    public Long getPriorityLowerThanOrEquals() {
        return this.priorityLowerThanOrEquals;
    }

    public void setPriorityLowerThanOrEquals(Long priorityLowerThanOrEquals) {
        this.priorityLowerThanOrEquals = priorityLowerThanOrEquals;
    }

    public HistoricExternalTaskLogQueryDto priorityHigherThanOrEquals(Long priorityHigherThanOrEquals) {
        this.priorityHigherThanOrEquals = priorityHigherThanOrEquals;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include logs for which the associated external task had a priority higher than or equal to the given value. Value must be a valid `long` value.")
    public Long getPriorityHigherThanOrEquals() {
        return this.priorityHigherThanOrEquals;
    }

    public void setPriorityHigherThanOrEquals(Long priorityHigherThanOrEquals) {
        this.priorityHigherThanOrEquals = priorityHigherThanOrEquals;
    }

    public HistoricExternalTaskLogQueryDto creationLog(Boolean creationLog) {
        this.creationLog = creationLog;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include creation logs. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getCreationLog() {
        return this.creationLog;
    }

    public void setCreationLog(Boolean creationLog) {
        this.creationLog = creationLog;
    }

    public HistoricExternalTaskLogQueryDto failureLog(Boolean failureLog) {
        this.failureLog = failureLog;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include failure logs. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getFailureLog() {
        return this.failureLog;
    }

    public void setFailureLog(Boolean failureLog) {
        this.failureLog = failureLog;
    }

    public HistoricExternalTaskLogQueryDto successLog(Boolean successLog) {
        this.successLog = successLog;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include success logs. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getSuccessLog() {
        return this.successLog;
    }

    public void setSuccessLog(Boolean successLog) {
        this.successLog = successLog;
    }

    public HistoricExternalTaskLogQueryDto deletionLog(Boolean deletionLog) {
        this.deletionLog = deletionLog;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include deletion logs. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getDeletionLog() {
        return this.deletionLog;
    }

    public void setDeletionLog(Boolean deletionLog) {
        this.deletionLog = deletionLog;
    }

    public HistoricExternalTaskLogQueryDto sorting(List<HistoricExternalTaskLogQueryDtoSorting> sorting) {
        this.sorting = sorting;
        return this;
    }

    public HistoricExternalTaskLogQueryDto addSortingItem(HistoricExternalTaskLogQueryDtoSorting sortingItem) {
        if (this.sorting == null) {
            this.sorting = new ArrayList<HistoricExternalTaskLogQueryDtoSorting>();
        }
        this.sorting.add(sortingItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Sorting has no effect for `count` endpoints.")
    public List<HistoricExternalTaskLogQueryDtoSorting> getSorting() {
        return this.sorting;
    }

    public void setSorting(List<HistoricExternalTaskLogQueryDtoSorting> sorting) {
        this.sorting = sorting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricExternalTaskLogQueryDto historicExternalTaskLogQueryDto = (HistoricExternalTaskLogQueryDto)o;
        return Objects.equals(this.logId, historicExternalTaskLogQueryDto.logId) && Objects.equals(this.externalTaskId, historicExternalTaskLogQueryDto.externalTaskId) && Objects.equals(this.topicName, historicExternalTaskLogQueryDto.topicName) && Objects.equals(this.workerId, historicExternalTaskLogQueryDto.workerId) && Objects.equals(this.errorMessage, historicExternalTaskLogQueryDto.errorMessage) && Objects.equals(this.activityIdIn, historicExternalTaskLogQueryDto.activityIdIn) && Objects.equals(this.activityInstanceIdIn, historicExternalTaskLogQueryDto.activityInstanceIdIn) && Objects.equals(this.executionIdIn, historicExternalTaskLogQueryDto.executionIdIn) && Objects.equals(this.processInstanceId, historicExternalTaskLogQueryDto.processInstanceId) && Objects.equals(this.processDefinitionId, historicExternalTaskLogQueryDto.processDefinitionId) && Objects.equals(this.processDefinitionKey, historicExternalTaskLogQueryDto.processDefinitionKey) && Objects.equals(this.tenantIdIn, historicExternalTaskLogQueryDto.tenantIdIn) && Objects.equals(this.withoutTenantId, historicExternalTaskLogQueryDto.withoutTenantId) && Objects.equals(this.priorityLowerThanOrEquals, historicExternalTaskLogQueryDto.priorityLowerThanOrEquals) && Objects.equals(this.priorityHigherThanOrEquals, historicExternalTaskLogQueryDto.priorityHigherThanOrEquals) && Objects.equals(this.creationLog, historicExternalTaskLogQueryDto.creationLog) && Objects.equals(this.failureLog, historicExternalTaskLogQueryDto.failureLog) && Objects.equals(this.successLog, historicExternalTaskLogQueryDto.successLog) && Objects.equals(this.deletionLog, historicExternalTaskLogQueryDto.deletionLog) && Objects.equals(this.sorting, historicExternalTaskLogQueryDto.sorting);
    }

    public int hashCode() {
        return Objects.hash(this.logId, this.externalTaskId, this.topicName, this.workerId, this.errorMessage, this.activityIdIn, this.activityInstanceIdIn, this.executionIdIn, this.processInstanceId, this.processDefinitionId, this.processDefinitionKey, this.tenantIdIn, this.withoutTenantId, this.priorityLowerThanOrEquals, this.priorityHigherThanOrEquals, this.creationLog, this.failureLog, this.successLog, this.deletionLog, this.sorting);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoricExternalTaskLogQueryDto {\n");
        sb.append("    logId: ").append(this.toIndentedString(this.logId)).append("\n");
        sb.append("    externalTaskId: ").append(this.toIndentedString(this.externalTaskId)).append("\n");
        sb.append("    topicName: ").append(this.toIndentedString(this.topicName)).append("\n");
        sb.append("    workerId: ").append(this.toIndentedString(this.workerId)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    activityIdIn: ").append(this.toIndentedString(this.activityIdIn)).append("\n");
        sb.append("    activityInstanceIdIn: ").append(this.toIndentedString(this.activityInstanceIdIn)).append("\n");
        sb.append("    executionIdIn: ").append(this.toIndentedString(this.executionIdIn)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    tenantIdIn: ").append(this.toIndentedString(this.tenantIdIn)).append("\n");
        sb.append("    withoutTenantId: ").append(this.toIndentedString(this.withoutTenantId)).append("\n");
        sb.append("    priorityLowerThanOrEquals: ").append(this.toIndentedString(this.priorityLowerThanOrEquals)).append("\n");
        sb.append("    priorityHigherThanOrEquals: ").append(this.toIndentedString(this.priorityHigherThanOrEquals)).append("\n");
        sb.append("    creationLog: ").append(this.toIndentedString(this.creationLog)).append("\n");
        sb.append("    failureLog: ").append(this.toIndentedString(this.failureLog)).append("\n");
        sb.append("    successLog: ").append(this.toIndentedString(this.successLog)).append("\n");
        sb.append("    deletionLog: ").append(this.toIndentedString(this.deletionLog)).append("\n");
        sb.append("    sorting: ").append(this.toIndentedString(this.sorting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

