/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.GroupQueryDtoSorting;

@ApiModel(description="A group instance query which defines a list of group instances")
public class GroupQueryDto {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_ID_IN = "idIn";
    @SerializedName(value="idIn")
    private List<String> idIn = null;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_NAME_LIKE = "nameLike";
    @SerializedName(value="nameLike")
    private String nameLike;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_MEMBER = "member";
    @SerializedName(value="member")
    private String member;
    public static final String SERIALIZED_NAME_MEMBER_OF_TENANT = "memberOfTenant";
    @SerializedName(value="memberOfTenant")
    private String memberOfTenant;
    public static final String SERIALIZED_NAME_SORTING = "sorting";
    @SerializedName(value="sorting")
    private List<GroupQueryDtoSorting> sorting = null;

    public GroupQueryDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the id of the group.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public GroupQueryDto idIn(List<String> idIn) {
        this.idIn = idIn;
        return this;
    }

    public GroupQueryDto addIdInItem(String idInItem) {
        if (this.idIn == null) {
            this.idIn = new ArrayList<String>();
        }
        this.idIn.add(idInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by a JSON string array of group ids.")
    public List<String> getIdIn() {
        return this.idIn;
    }

    public void setIdIn(List<String> idIn) {
        this.idIn = idIn;
    }

    public GroupQueryDto name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the name of the group.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GroupQueryDto nameLike(String nameLike) {
        this.nameLike = nameLike;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the name that the parameter is a substring of.")
    public String getNameLike() {
        return this.nameLike;
    }

    public void setNameLike(String nameLike) {
        this.nameLike = nameLike;
    }

    public GroupQueryDto type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the type of the group.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public GroupQueryDto member(String member) {
        this.member = member;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only retrieve groups where the given user id is a member of.")
    public String getMember() {
        return this.member;
    }

    public void setMember(String member) {
        this.member = member;
    }

    public GroupQueryDto memberOfTenant(String memberOfTenant) {
        this.memberOfTenant = memberOfTenant;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only retrieve groups which are members of the given tenant.")
    public String getMemberOfTenant() {
        return this.memberOfTenant;
    }

    public void setMemberOfTenant(String memberOfTenant) {
        this.memberOfTenant = memberOfTenant;
    }

    public GroupQueryDto sorting(List<GroupQueryDtoSorting> sorting) {
        this.sorting = sorting;
        return this;
    }

    public GroupQueryDto addSortingItem(GroupQueryDtoSorting sortingItem) {
        if (this.sorting == null) {
            this.sorting = new ArrayList<GroupQueryDtoSorting>();
        }
        this.sorting.add(sortingItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Apply sorting of the result")
    public List<GroupQueryDtoSorting> getSorting() {
        return this.sorting;
    }

    public void setSorting(List<GroupQueryDtoSorting> sorting) {
        this.sorting = sorting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupQueryDto groupQueryDto = (GroupQueryDto)o;
        return Objects.equals(this.id, groupQueryDto.id) && Objects.equals(this.idIn, groupQueryDto.idIn) && Objects.equals(this.name, groupQueryDto.name) && Objects.equals(this.nameLike, groupQueryDto.nameLike) && Objects.equals(this.type, groupQueryDto.type) && Objects.equals(this.member, groupQueryDto.member) && Objects.equals(this.memberOfTenant, groupQueryDto.memberOfTenant) && Objects.equals(this.sorting, groupQueryDto.sorting);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.idIn, this.name, this.nameLike, this.type, this.member, this.memberOfTenant, this.sorting);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupQueryDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    idIn: ").append(this.toIndentedString(this.idIn)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    nameLike: ").append(this.toIndentedString(this.nameLike)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    member: ").append(this.toIndentedString(this.member)).append("\n");
        sb.append("    memberOfTenant: ").append(this.toIndentedString(this.memberOfTenant)).append("\n");
        sb.append("    sorting: ").append(this.toIndentedString(this.sorting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

