/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.VariableValueDto;

public class ExternalTaskFailureDtoAllOf {
    public static final String SERIALIZED_NAME_ERROR_MESSAGE = "errorMessage";
    @SerializedName(value="errorMessage")
    private String errorMessage;
    public static final String SERIALIZED_NAME_ERROR_DETAILS = "errorDetails";
    @SerializedName(value="errorDetails")
    private String errorDetails;
    public static final String SERIALIZED_NAME_RETRIES = "retries";
    @SerializedName(value="retries")
    private Integer retries;
    public static final String SERIALIZED_NAME_RETRY_TIMEOUT = "retryTimeout";
    @SerializedName(value="retryTimeout")
    private Long retryTimeout;
    public static final String SERIALIZED_NAME_VARIABLES = "variables";
    @SerializedName(value="variables")
    private Map<String, VariableValueDto> variables = null;
    public static final String SERIALIZED_NAME_LOCAL_VARIABLES = "localVariables";
    @SerializedName(value="localVariables")
    private Map<String, VariableValueDto> localVariables = null;

    public ExternalTaskFailureDtoAllOf errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An message indicating the reason of the failure.")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public ExternalTaskFailureDtoAllOf errorDetails(String errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A detailed error description.")
    public String getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(String errorDetails) {
        this.errorDetails = errorDetails;
    }

    public ExternalTaskFailureDtoAllOf retries(Integer retries) {
        this.retries = retries;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A number of how often the task should be retried. Must be >= 0. If this is 0, an incident is created and the task cannot be fetched anymore unless the retries are increased again. The incident's message is set to the `errorMessage` parameter.")
    public Integer getRetries() {
        return this.retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public ExternalTaskFailureDtoAllOf retryTimeout(Long retryTimeout) {
        this.retryTimeout = retryTimeout;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A timeout in milliseconds before the external task becomes available again for fetching. Must be >= 0.")
    public Long getRetryTimeout() {
        return this.retryTimeout;
    }

    public void setRetryTimeout(Long retryTimeout) {
        this.retryTimeout = retryTimeout;
    }

    public ExternalTaskFailureDtoAllOf variables(Map<String, VariableValueDto> variables) {
        this.variables = variables;
        return this;
    }

    public ExternalTaskFailureDtoAllOf putVariablesItem(String key, VariableValueDto variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, VariableValueDto>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A JSON object containing variable key-value pairs. Each key is a variable name and each value a JSON variable value object with the following properties:")
    public Map<String, VariableValueDto> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, VariableValueDto> variables) {
        this.variables = variables;
    }

    public ExternalTaskFailureDtoAllOf localVariables(Map<String, VariableValueDto> localVariables) {
        this.localVariables = localVariables;
        return this;
    }

    public ExternalTaskFailureDtoAllOf putLocalVariablesItem(String key, VariableValueDto localVariablesItem) {
        if (this.localVariables == null) {
            this.localVariables = new HashMap<String, VariableValueDto>();
        }
        this.localVariables.put(key, localVariablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A JSON object containing local variable key-value pairs. Local variables are set only in the scope of external task. Each key is a variable name and each value a JSON variable value object with the following properties:")
    public Map<String, VariableValueDto> getLocalVariables() {
        return this.localVariables;
    }

    public void setLocalVariables(Map<String, VariableValueDto> localVariables) {
        this.localVariables = localVariables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalTaskFailureDtoAllOf externalTaskFailureDtoAllOf = (ExternalTaskFailureDtoAllOf)o;
        return Objects.equals(this.errorMessage, externalTaskFailureDtoAllOf.errorMessage) && Objects.equals(this.errorDetails, externalTaskFailureDtoAllOf.errorDetails) && Objects.equals(this.retries, externalTaskFailureDtoAllOf.retries) && Objects.equals(this.retryTimeout, externalTaskFailureDtoAllOf.retryTimeout) && Objects.equals(this.variables, externalTaskFailureDtoAllOf.variables) && Objects.equals(this.localVariables, externalTaskFailureDtoAllOf.localVariables);
    }

    public int hashCode() {
        return Objects.hash(this.errorMessage, this.errorDetails, this.retries, this.retryTimeout, this.variables, this.localVariables);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExternalTaskFailureDtoAllOf {\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        sb.append("    retries: ").append(this.toIndentedString(this.retries)).append("\n");
        sb.append("    retryTimeout: ").append(this.toIndentedString(this.retryTimeout)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    localVariables: ").append(this.toIndentedString(this.localVariables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

