/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.EventSubscriptionQueryDtoSorting;

@ApiModel(description="A event subscription query which retrieves a list of event subscriptions")
public class EventSubscriptionQueryDto {
    public static final String SERIALIZED_NAME_EVENT_SUBSCRIPTION_ID = "eventSubscriptionId";
    @SerializedName(value="eventSubscriptionId")
    private String eventSubscriptionId;
    public static final String SERIALIZED_NAME_EVENT_NAME = "eventName";
    @SerializedName(value="eventName")
    private String eventName;
    public static final String SERIALIZED_NAME_EVENT_TYPE = "eventType";
    @SerializedName(value="eventType")
    private EventTypeEnum eventType;
    public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
    @SerializedName(value="executionId")
    private String executionId;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
    @SerializedName(value="activityId")
    private String activityId;
    public static final String SERIALIZED_NAME_TENANT_ID_IN = "tenantIdIn";
    @SerializedName(value="tenantIdIn")
    private List<String> tenantIdIn = null;
    public static final String SERIALIZED_NAME_WITHOUT_TENANT_ID = "withoutTenantId";
    @SerializedName(value="withoutTenantId")
    private Boolean withoutTenantId;
    public static final String SERIALIZED_NAME_INCLUDE_EVENT_SUBSCRIPTIONS_WITHOUT_TENANT_ID = "includeEventSubscriptionsWithoutTenantId";
    @SerializedName(value="includeEventSubscriptionsWithoutTenantId")
    private Boolean includeEventSubscriptionsWithoutTenantId;
    public static final String SERIALIZED_NAME_SORTING = "sorting";
    @SerializedName(value="sorting")
    private List<EventSubscriptionQueryDtoSorting> sorting = null;

    public EventSubscriptionQueryDto eventSubscriptionId(String eventSubscriptionId) {
        this.eventSubscriptionId = eventSubscriptionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the event subscription.")
    public String getEventSubscriptionId() {
        return this.eventSubscriptionId;
    }

    public void setEventSubscriptionId(String eventSubscriptionId) {
        this.eventSubscriptionId = eventSubscriptionId;
    }

    public EventSubscriptionQueryDto eventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the event this subscription belongs to as defined in the process model.")
    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public EventSubscriptionQueryDto eventType(EventTypeEnum eventType) {
        this.eventType = eventType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the event subscription.")
    public EventTypeEnum getEventType() {
        return this.eventType;
    }

    public void setEventType(EventTypeEnum eventType) {
        this.eventType = eventType;
    }

    public EventSubscriptionQueryDto executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The execution that is subscribed on the referenced event.")
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public EventSubscriptionQueryDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The process instance this subscription belongs to.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public EventSubscriptionQueryDto activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier of the activity that this event subscription belongs to. This could for example be the id of a receive task.")
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public EventSubscriptionQueryDto tenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
        return this;
    }

    public EventSubscriptionQueryDto addTenantIdInItem(String tenantIdInItem) {
        if (this.tenantIdIn == null) {
            this.tenantIdIn = new ArrayList<String>();
        }
        this.tenantIdIn.add(tenantIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by a comma-separated list of tenant ids. Only select subscriptions that belong to one of the given tenant ids.")
    public List<String> getTenantIdIn() {
        return this.tenantIdIn;
    }

    public void setTenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
    }

    public EventSubscriptionQueryDto withoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only select subscriptions which have no tenant id. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getWithoutTenantId() {
        return this.withoutTenantId;
    }

    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    public EventSubscriptionQueryDto includeEventSubscriptionsWithoutTenantId(Boolean includeEventSubscriptionsWithoutTenantId) {
        this.includeEventSubscriptionsWithoutTenantId = includeEventSubscriptionsWithoutTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Select event subscriptions which have no tenant id. Can be used in combination with tenantIdIn parameter. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getIncludeEventSubscriptionsWithoutTenantId() {
        return this.includeEventSubscriptionsWithoutTenantId;
    }

    public void setIncludeEventSubscriptionsWithoutTenantId(Boolean includeEventSubscriptionsWithoutTenantId) {
        this.includeEventSubscriptionsWithoutTenantId = includeEventSubscriptionsWithoutTenantId;
    }

    public EventSubscriptionQueryDto sorting(List<EventSubscriptionQueryDtoSorting> sorting) {
        this.sorting = sorting;
        return this;
    }

    public EventSubscriptionQueryDto addSortingItem(EventSubscriptionQueryDtoSorting sortingItem) {
        if (this.sorting == null) {
            this.sorting = new ArrayList<EventSubscriptionQueryDtoSorting>();
        }
        this.sorting.add(sortingItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Apply sorting of the result")
    public List<EventSubscriptionQueryDtoSorting> getSorting() {
        return this.sorting;
    }

    public void setSorting(List<EventSubscriptionQueryDtoSorting> sorting) {
        this.sorting = sorting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventSubscriptionQueryDto eventSubscriptionQueryDto = (EventSubscriptionQueryDto)o;
        return Objects.equals(this.eventSubscriptionId, eventSubscriptionQueryDto.eventSubscriptionId) && Objects.equals(this.eventName, eventSubscriptionQueryDto.eventName) && Objects.equals((Object)this.eventType, (Object)eventSubscriptionQueryDto.eventType) && Objects.equals(this.executionId, eventSubscriptionQueryDto.executionId) && Objects.equals(this.processInstanceId, eventSubscriptionQueryDto.processInstanceId) && Objects.equals(this.activityId, eventSubscriptionQueryDto.activityId) && Objects.equals(this.tenantIdIn, eventSubscriptionQueryDto.tenantIdIn) && Objects.equals(this.withoutTenantId, eventSubscriptionQueryDto.withoutTenantId) && Objects.equals(this.includeEventSubscriptionsWithoutTenantId, eventSubscriptionQueryDto.includeEventSubscriptionsWithoutTenantId) && Objects.equals(this.sorting, eventSubscriptionQueryDto.sorting);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventSubscriptionId, this.eventName, this.eventType, this.executionId, this.processInstanceId, this.activityId, this.tenantIdIn, this.withoutTenantId, this.includeEventSubscriptionsWithoutTenantId, this.sorting});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventSubscriptionQueryDto {\n");
        sb.append("    eventSubscriptionId: ").append(this.toIndentedString(this.eventSubscriptionId)).append("\n");
        sb.append("    eventName: ").append(this.toIndentedString(this.eventName)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString((Object)this.eventType)).append("\n");
        sb.append("    executionId: ").append(this.toIndentedString(this.executionId)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    activityId: ").append(this.toIndentedString(this.activityId)).append("\n");
        sb.append("    tenantIdIn: ").append(this.toIndentedString(this.tenantIdIn)).append("\n");
        sb.append("    withoutTenantId: ").append(this.toIndentedString(this.withoutTenantId)).append("\n");
        sb.append("    includeEventSubscriptionsWithoutTenantId: ").append(this.toIndentedString(this.includeEventSubscriptionsWithoutTenantId)).append("\n");
        sb.append("    sorting: ").append(this.toIndentedString(this.sorting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum EventTypeEnum {
        MESSAGE("message"),
        SIGNAL("signal"),
        COMPENSATE("compensate"),
        CONDITIONAL("conditional");

        private String value;

        private EventTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EventTypeEnum fromValue(String value) {
            for (EventTypeEnum b : EventTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<EventTypeEnum> {
            public void write(JsonWriter jsonWriter, EventTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public EventTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return EventTypeEnum.fromValue(value);
            }
        }
    }
}

