/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

public class DurationReportResultDto {
    public static final String SERIALIZED_NAME_PERIOD = "period";
    @SerializedName(value="period")
    private Integer period;
    public static final String SERIALIZED_NAME_PERIOD_UNIT = "periodUnit";
    @SerializedName(value="periodUnit")
    private PeriodUnitEnum periodUnit;
    public static final String SERIALIZED_NAME_MINIMUM = "minimum";
    @SerializedName(value="minimum")
    private Long minimum;
    public static final String SERIALIZED_NAME_MAXIMUM = "maximum";
    @SerializedName(value="maximum")
    private Long maximum;
    public static final String SERIALIZED_NAME_AVERAGE = "average";
    @SerializedName(value="average")
    private Long average;

    public DurationReportResultDto period(Integer period) {
        this.period = period;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies a timespan within a year. **Note:** The period must be interpreted in conjunction with the returned `periodUnit`.")
    public Integer getPeriod() {
        return this.period;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public DurationReportResultDto periodUnit(PeriodUnitEnum periodUnit) {
        this.periodUnit = periodUnit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unit of the given period. Possible values are `MONTH` and `QUARTER`.")
    public PeriodUnitEnum getPeriodUnit() {
        return this.periodUnit;
    }

    public void setPeriodUnit(PeriodUnitEnum periodUnit) {
        this.periodUnit = periodUnit;
    }

    public DurationReportResultDto minimum(Long minimum) {
        this.minimum = minimum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The smallest duration in milliseconds of all completed process instances which were started in the given period.")
    public Long getMinimum() {
        return this.minimum;
    }

    public void setMinimum(Long minimum) {
        this.minimum = minimum;
    }

    public DurationReportResultDto maximum(Long maximum) {
        this.maximum = maximum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The greatest duration in milliseconds of all completed process instances which were started in the given period.")
    public Long getMaximum() {
        return this.maximum;
    }

    public void setMaximum(Long maximum) {
        this.maximum = maximum;
    }

    public DurationReportResultDto average(Long average) {
        this.average = average;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The average duration in milliseconds of all completed process instances which were started in the given period.")
    public Long getAverage() {
        return this.average;
    }

    public void setAverage(Long average) {
        this.average = average;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DurationReportResultDto durationReportResultDto = (DurationReportResultDto)o;
        return Objects.equals(this.period, durationReportResultDto.period) && Objects.equals((Object)this.periodUnit, (Object)durationReportResultDto.periodUnit) && Objects.equals(this.minimum, durationReportResultDto.minimum) && Objects.equals(this.maximum, durationReportResultDto.maximum) && Objects.equals(this.average, durationReportResultDto.average);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.period, this.periodUnit, this.minimum, this.maximum, this.average});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DurationReportResultDto {\n");
        sb.append("    period: ").append(this.toIndentedString(this.period)).append("\n");
        sb.append("    periodUnit: ").append(this.toIndentedString((Object)this.periodUnit)).append("\n");
        sb.append("    minimum: ").append(this.toIndentedString(this.minimum)).append("\n");
        sb.append("    maximum: ").append(this.toIndentedString(this.maximum)).append("\n");
        sb.append("    average: ").append(this.toIndentedString(this.average)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PeriodUnitEnum {
        MONTH("MONTH"),
        QUARTER("QUARTER");

        private String value;

        private PeriodUnitEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PeriodUnitEnum fromValue(String value) {
            for (PeriodUnitEnum b : PeriodUnitEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PeriodUnitEnum> {
            public void write(JsonWriter jsonWriter, PeriodUnitEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PeriodUnitEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PeriodUnitEnum.fromValue(value);
            }
        }
    }
}

