/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.ResourceOptionsDto;
import org.camunda.community.rest.client.dto.UserCredentialsDto;
import org.camunda.community.rest.client.dto.UserDto;
import org.camunda.community.rest.client.dto.UserProfileDto;
import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class UserApi {
    private ApiClient localVarApiClient;

    public UserApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call availableOperationsCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/user";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "OPTIONS", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call availableOperationsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.availableOperationsCall(_callback);
        return localVarCall;
    }

    public ResourceOptionsDto availableOperations() throws ApiException {
        ApiResponse<ResourceOptionsDto> localVarResp = this.availableOperationsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<ResourceOptionsDto> availableOperationsWithHttpInfo() throws ApiException {
        Call localVarCall = this.availableOperationsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call availableOperationsAsync(ApiCallback<ResourceOptionsDto> _callback) throws ApiException {
        Call localVarCall = this.availableOperationsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call availableUserOperationsCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/user/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "OPTIONS", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call availableUserOperationsValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling availableUserOperations(Async)");
        }
        Call localVarCall = this.availableUserOperationsCall(id, _callback);
        return localVarCall;
    }

    public ResourceOptionsDto availableUserOperations(String id) throws ApiException {
        ApiResponse<ResourceOptionsDto> localVarResp = this.availableUserOperationsWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<ResourceOptionsDto> availableUserOperationsWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.availableUserOperationsValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call availableUserOperationsAsync(String id, ApiCallback<ResourceOptionsDto> _callback) throws ApiException {
        Call localVarCall = this.availableUserOperationsValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createUserCall(UserDto userDto, ApiCallback _callback) throws ApiException {
        UserDto localVarPostBody = userDto;
        String localVarPath = "/user/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createUserValidateBeforeCall(UserDto userDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.createUserCall(userDto, _callback);
        return localVarCall;
    }

    public void createUser(UserDto userDto) throws ApiException {
        this.createUserWithHttpInfo(userDto);
    }

    public ApiResponse<Void> createUserWithHttpInfo(UserDto userDto) throws ApiException {
        Call localVarCall = this.createUserValidateBeforeCall(userDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call createUserAsync(UserDto userDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createUserValidateBeforeCall(userDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteUserCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/user/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteUserValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteUser(Async)");
        }
        Call localVarCall = this.deleteUserCall(id, _callback);
        return localVarCall;
    }

    public void deleteUser(String id) throws ApiException {
        this.deleteUserWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteUserWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.deleteUserValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteUserAsync(String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteUserValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getUserCountCall(String id, String idIn, String firstName, String firstNameLike, String lastName, String lastNameLike, String email, String emailLike, String memberOfGroup, String memberOfTenant, String potentialStarter, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/user/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (idIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("idIn", idIn));
        }
        if (firstName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstName", firstName));
        }
        if (firstNameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstNameLike", firstNameLike));
        }
        if (lastName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("lastName", lastName));
        }
        if (lastNameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("lastNameLike", lastNameLike));
        }
        if (email != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("email", email));
        }
        if (emailLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("emailLike", emailLike));
        }
        if (memberOfGroup != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("memberOfGroup", memberOfGroup));
        }
        if (memberOfTenant != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("memberOfTenant", memberOfTenant));
        }
        if (potentialStarter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("potentialStarter", potentialStarter));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUserCountValidateBeforeCall(String id, String idIn, String firstName, String firstNameLike, String lastName, String lastNameLike, String email, String emailLike, String memberOfGroup, String memberOfTenant, String potentialStarter, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getUserCountCall(id, idIn, firstName, firstNameLike, lastName, lastNameLike, email, emailLike, memberOfGroup, memberOfTenant, potentialStarter, _callback);
        return localVarCall;
    }

    public CountResultDto getUserCount(String id, String idIn, String firstName, String firstNameLike, String lastName, String lastNameLike, String email, String emailLike, String memberOfGroup, String memberOfTenant, String potentialStarter) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.getUserCountWithHttpInfo(id, idIn, firstName, firstNameLike, lastName, lastNameLike, email, emailLike, memberOfGroup, memberOfTenant, potentialStarter);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> getUserCountWithHttpInfo(String id, String idIn, String firstName, String firstNameLike, String lastName, String lastNameLike, String email, String emailLike, String memberOfGroup, String memberOfTenant, String potentialStarter) throws ApiException {
        Call localVarCall = this.getUserCountValidateBeforeCall(id, idIn, firstName, firstNameLike, lastName, lastNameLike, email, emailLike, memberOfGroup, memberOfTenant, potentialStarter, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUserCountAsync(String id, String idIn, String firstName, String firstNameLike, String lastName, String lastNameLike, String email, String emailLike, String memberOfGroup, String memberOfTenant, String potentialStarter, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.getUserCountValidateBeforeCall(id, idIn, firstName, firstNameLike, lastName, lastNameLike, email, emailLike, memberOfGroup, memberOfTenant, potentialStarter, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUserProfileCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/user/{id}/profile".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUserProfileValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getUserProfile(Async)");
        }
        Call localVarCall = this.getUserProfileCall(id, _callback);
        return localVarCall;
    }

    public UserProfileDto getUserProfile(String id) throws ApiException {
        ApiResponse<UserProfileDto> localVarResp = this.getUserProfileWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<UserProfileDto> getUserProfileWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getUserProfileValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<UserProfileDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUserProfileAsync(String id, ApiCallback<UserProfileDto> _callback) throws ApiException {
        Call localVarCall = this.getUserProfileValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<UserProfileDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUsersCall(String id, String idIn, String firstName, String firstNameLike, String lastName, String lastNameLike, String email, String emailLike, String memberOfGroup, String memberOfTenant, String potentialStarter, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/user";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (idIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("idIn", idIn));
        }
        if (firstName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstName", firstName));
        }
        if (firstNameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstNameLike", firstNameLike));
        }
        if (lastName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("lastName", lastName));
        }
        if (lastNameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("lastNameLike", lastNameLike));
        }
        if (email != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("email", email));
        }
        if (emailLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("emailLike", emailLike));
        }
        if (memberOfGroup != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("memberOfGroup", memberOfGroup));
        }
        if (memberOfTenant != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("memberOfTenant", memberOfTenant));
        }
        if (potentialStarter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("potentialStarter", potentialStarter));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUsersValidateBeforeCall(String id, String idIn, String firstName, String firstNameLike, String lastName, String lastNameLike, String email, String emailLike, String memberOfGroup, String memberOfTenant, String potentialStarter, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getUsersCall(id, idIn, firstName, firstNameLike, lastName, lastNameLike, email, emailLike, memberOfGroup, memberOfTenant, potentialStarter, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;
    }

    public List<UserProfileDto> getUsers(String id, String idIn, String firstName, String firstNameLike, String lastName, String lastNameLike, String email, String emailLike, String memberOfGroup, String memberOfTenant, String potentialStarter, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<UserProfileDto>> localVarResp = this.getUsersWithHttpInfo(id, idIn, firstName, firstNameLike, lastName, lastNameLike, email, emailLike, memberOfGroup, memberOfTenant, potentialStarter, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    public ApiResponse<List<UserProfileDto>> getUsersWithHttpInfo(String id, String idIn, String firstName, String firstNameLike, String lastName, String lastNameLike, String email, String emailLike, String memberOfGroup, String memberOfTenant, String potentialStarter, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        Call localVarCall = this.getUsersValidateBeforeCall(id, idIn, firstName, firstNameLike, lastName, lastNameLike, email, emailLike, memberOfGroup, memberOfTenant, potentialStarter, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<UserProfileDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUsersAsync(String id, String idIn, String firstName, String firstNameLike, String lastName, String lastNameLike, String email, String emailLike, String memberOfGroup, String memberOfTenant, String potentialStarter, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback<List<UserProfileDto>> _callback) throws ApiException {
        Call localVarCall = this.getUsersValidateBeforeCall(id, idIn, firstName, firstNameLike, lastName, lastNameLike, email, emailLike, memberOfGroup, memberOfTenant, potentialStarter, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<UserProfileDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call unlockUserCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/user/{id}/unlock".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call unlockUserValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling unlockUser(Async)");
        }
        Call localVarCall = this.unlockUserCall(id, _callback);
        return localVarCall;
    }

    public void unlockUser(String id) throws ApiException {
        this.unlockUserWithHttpInfo(id);
    }

    public ApiResponse<Void> unlockUserWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.unlockUserValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call unlockUserAsync(String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.unlockUserValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateCredentialsCall(String id, UserCredentialsDto userCredentialsDto, ApiCallback _callback) throws ApiException {
        UserCredentialsDto localVarPostBody = userCredentialsDto;
        String localVarPath = "/user/{id}/credentials".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateCredentialsValidateBeforeCall(String id, UserCredentialsDto userCredentialsDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateCredentials(Async)");
        }
        Call localVarCall = this.updateCredentialsCall(id, userCredentialsDto, _callback);
        return localVarCall;
    }

    public void updateCredentials(String id, UserCredentialsDto userCredentialsDto) throws ApiException {
        this.updateCredentialsWithHttpInfo(id, userCredentialsDto);
    }

    public ApiResponse<Void> updateCredentialsWithHttpInfo(String id, UserCredentialsDto userCredentialsDto) throws ApiException {
        Call localVarCall = this.updateCredentialsValidateBeforeCall(id, userCredentialsDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateCredentialsAsync(String id, UserCredentialsDto userCredentialsDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateCredentialsValidateBeforeCall(id, userCredentialsDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateProfileCall(String id, UserProfileDto userProfileDto, ApiCallback _callback) throws ApiException {
        UserProfileDto localVarPostBody = userProfileDto;
        String localVarPath = "/user/{id}/profile".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateProfileValidateBeforeCall(String id, UserProfileDto userProfileDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateProfile(Async)");
        }
        Call localVarCall = this.updateProfileCall(id, userProfileDto, _callback);
        return localVarCall;
    }

    public void updateProfile(String id, UserProfileDto userProfileDto) throws ApiException {
        this.updateProfileWithHttpInfo(id, userProfileDto);
    }

    public ApiResponse<Void> updateProfileWithHttpInfo(String id, UserProfileDto userProfileDto) throws ApiException {
        Call localVarCall = this.updateProfileValidateBeforeCall(id, userProfileDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateProfileAsync(String id, UserProfileDto userProfileDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateProfileValidateBeforeCall(id, userProfileDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

