/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.JobDefinitionDto;
import org.camunda.community.rest.client.dto.JobDefinitionPriorityDto;
import org.camunda.community.rest.client.dto.JobDefinitionQueryDto;
import org.camunda.community.rest.client.dto.JobDefinitionSuspensionStateDto;
import org.camunda.community.rest.client.dto.JobDefinitionsSuspensionStateDto;
import org.camunda.community.rest.client.dto.RetriesDto;
import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class JobDefinitionApi {
    private ApiClient localVarApiClient;

    public JobDefinitionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public JobDefinitionApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getJobDefinitionCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/job-definition/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getJobDefinitionValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getJobDefinition(Async)");
        }
        Call localVarCall = this.getJobDefinitionCall(id, _callback);
        return localVarCall;
    }

    public JobDefinitionDto getJobDefinition(String id) throws ApiException {
        ApiResponse<JobDefinitionDto> localVarResp = this.getJobDefinitionWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<JobDefinitionDto> getJobDefinitionWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getJobDefinitionValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<JobDefinitionDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getJobDefinitionAsync(String id, ApiCallback<JobDefinitionDto> _callback) throws ApiException {
        Call localVarCall = this.getJobDefinitionValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<JobDefinitionDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getJobDefinitionsCall(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/job-definition";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (jobDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("jobDefinitionId", jobDefinitionId));
        }
        if (activityIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("activityIdIn", activityIdIn));
        }
        if (processDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }
        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }
        if (jobType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("jobType", jobType));
        }
        if (jobConfiguration != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("jobConfiguration", jobConfiguration));
        }
        if (active != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("active", active));
        }
        if (suspended != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("suspended", suspended));
        }
        if (withOverridingJobPriority != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withOverridingJobPriority", withOverridingJobPriority));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (withoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }
        if (includeJobDefinitionsWithoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includeJobDefinitionsWithoutTenantId", includeJobDefinitionsWithoutTenantId));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getJobDefinitionsValidateBeforeCall(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getJobDefinitionsCall(jobDefinitionId, activityIdIn, processDefinitionId, processDefinitionKey, jobType, jobConfiguration, active, suspended, withOverridingJobPriority, tenantIdIn, withoutTenantId, includeJobDefinitionsWithoutTenantId, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;
    }

    public List<JobDefinitionDto> getJobDefinitions(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<JobDefinitionDto>> localVarResp = this.getJobDefinitionsWithHttpInfo(jobDefinitionId, activityIdIn, processDefinitionId, processDefinitionKey, jobType, jobConfiguration, active, suspended, withOverridingJobPriority, tenantIdIn, withoutTenantId, includeJobDefinitionsWithoutTenantId, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    public ApiResponse<List<JobDefinitionDto>> getJobDefinitionsWithHttpInfo(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        Call localVarCall = this.getJobDefinitionsValidateBeforeCall(jobDefinitionId, activityIdIn, processDefinitionId, processDefinitionKey, jobType, jobConfiguration, active, suspended, withOverridingJobPriority, tenantIdIn, withoutTenantId, includeJobDefinitionsWithoutTenantId, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<JobDefinitionDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getJobDefinitionsAsync(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback<List<JobDefinitionDto>> _callback) throws ApiException {
        Call localVarCall = this.getJobDefinitionsValidateBeforeCall(jobDefinitionId, activityIdIn, processDefinitionId, processDefinitionKey, jobType, jobConfiguration, active, suspended, withOverridingJobPriority, tenantIdIn, withoutTenantId, includeJobDefinitionsWithoutTenantId, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<JobDefinitionDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getJobDefinitionsCountCall(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/job-definition/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (jobDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("jobDefinitionId", jobDefinitionId));
        }
        if (activityIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("activityIdIn", activityIdIn));
        }
        if (processDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }
        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }
        if (jobType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("jobType", jobType));
        }
        if (jobConfiguration != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("jobConfiguration", jobConfiguration));
        }
        if (active != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("active", active));
        }
        if (suspended != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("suspended", suspended));
        }
        if (withOverridingJobPriority != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withOverridingJobPriority", withOverridingJobPriority));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (withoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }
        if (includeJobDefinitionsWithoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includeJobDefinitionsWithoutTenantId", includeJobDefinitionsWithoutTenantId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getJobDefinitionsCountValidateBeforeCall(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getJobDefinitionsCountCall(jobDefinitionId, activityIdIn, processDefinitionId, processDefinitionKey, jobType, jobConfiguration, active, suspended, withOverridingJobPriority, tenantIdIn, withoutTenantId, includeJobDefinitionsWithoutTenantId, _callback);
        return localVarCall;
    }

    public CountResultDto getJobDefinitionsCount(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.getJobDefinitionsCountWithHttpInfo(jobDefinitionId, activityIdIn, processDefinitionId, processDefinitionKey, jobType, jobConfiguration, active, suspended, withOverridingJobPriority, tenantIdIn, withoutTenantId, includeJobDefinitionsWithoutTenantId);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> getJobDefinitionsCountWithHttpInfo(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId) throws ApiException {
        Call localVarCall = this.getJobDefinitionsCountValidateBeforeCall(jobDefinitionId, activityIdIn, processDefinitionId, processDefinitionKey, jobType, jobConfiguration, active, suspended, withOverridingJobPriority, tenantIdIn, withoutTenantId, includeJobDefinitionsWithoutTenantId, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getJobDefinitionsCountAsync(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.getJobDefinitionsCountValidateBeforeCall(jobDefinitionId, activityIdIn, processDefinitionId, processDefinitionKey, jobType, jobConfiguration, active, suspended, withOverridingJobPriority, tenantIdIn, withoutTenantId, includeJobDefinitionsWithoutTenantId, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryJobDefinitionsCall(Integer firstResult, Integer maxResults, JobDefinitionQueryDto jobDefinitionQueryDto, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        JobDefinitionQueryDto localVarPostBody = jobDefinitionQueryDto;
        String localVarPath = "/job-definition";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryJobDefinitionsValidateBeforeCall(Integer firstResult, Integer maxResults, JobDefinitionQueryDto jobDefinitionQueryDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.queryJobDefinitionsCall(firstResult, maxResults, jobDefinitionQueryDto, _callback);
        return localVarCall;
    }

    public List<JobDefinitionDto> queryJobDefinitions(Integer firstResult, Integer maxResults, JobDefinitionQueryDto jobDefinitionQueryDto) throws ApiException {
        ApiResponse<List<JobDefinitionDto>> localVarResp = this.queryJobDefinitionsWithHttpInfo(firstResult, maxResults, jobDefinitionQueryDto);
        return localVarResp.getData();
    }

    public ApiResponse<List<JobDefinitionDto>> queryJobDefinitionsWithHttpInfo(Integer firstResult, Integer maxResults, JobDefinitionQueryDto jobDefinitionQueryDto) throws ApiException {
        Call localVarCall = this.queryJobDefinitionsValidateBeforeCall(firstResult, maxResults, jobDefinitionQueryDto, null);
        Type localVarReturnType = new TypeToken<List<JobDefinitionDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call queryJobDefinitionsAsync(Integer firstResult, Integer maxResults, JobDefinitionQueryDto jobDefinitionQueryDto, ApiCallback<List<JobDefinitionDto>> _callback) throws ApiException {
        Call localVarCall = this.queryJobDefinitionsValidateBeforeCall(firstResult, maxResults, jobDefinitionQueryDto, _callback);
        Type localVarReturnType = new TypeToken<List<JobDefinitionDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryJobDefinitionsCountCall(JobDefinitionQueryDto jobDefinitionQueryDto, ApiCallback _callback) throws ApiException {
        JobDefinitionQueryDto localVarPostBody = jobDefinitionQueryDto;
        String localVarPath = "/job-definition/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryJobDefinitionsCountValidateBeforeCall(JobDefinitionQueryDto jobDefinitionQueryDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.queryJobDefinitionsCountCall(jobDefinitionQueryDto, _callback);
        return localVarCall;
    }

    public CountResultDto queryJobDefinitionsCount(JobDefinitionQueryDto jobDefinitionQueryDto) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.queryJobDefinitionsCountWithHttpInfo(jobDefinitionQueryDto);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> queryJobDefinitionsCountWithHttpInfo(JobDefinitionQueryDto jobDefinitionQueryDto) throws ApiException {
        Call localVarCall = this.queryJobDefinitionsCountValidateBeforeCall(jobDefinitionQueryDto, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call queryJobDefinitionsCountAsync(JobDefinitionQueryDto jobDefinitionQueryDto, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.queryJobDefinitionsCountValidateBeforeCall(jobDefinitionQueryDto, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call setJobPriorityJobDefinitionCall(String id, JobDefinitionPriorityDto jobDefinitionPriorityDto, ApiCallback _callback) throws ApiException {
        JobDefinitionPriorityDto localVarPostBody = jobDefinitionPriorityDto;
        String localVarPath = "/job-definition/{id}/jobPriority".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setJobPriorityJobDefinitionValidateBeforeCall(String id, JobDefinitionPriorityDto jobDefinitionPriorityDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling setJobPriorityJobDefinition(Async)");
        }
        Call localVarCall = this.setJobPriorityJobDefinitionCall(id, jobDefinitionPriorityDto, _callback);
        return localVarCall;
    }

    public void setJobPriorityJobDefinition(String id, JobDefinitionPriorityDto jobDefinitionPriorityDto) throws ApiException {
        this.setJobPriorityJobDefinitionWithHttpInfo(id, jobDefinitionPriorityDto);
    }

    public ApiResponse<Void> setJobPriorityJobDefinitionWithHttpInfo(String id, JobDefinitionPriorityDto jobDefinitionPriorityDto) throws ApiException {
        Call localVarCall = this.setJobPriorityJobDefinitionValidateBeforeCall(id, jobDefinitionPriorityDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call setJobPriorityJobDefinitionAsync(String id, JobDefinitionPriorityDto jobDefinitionPriorityDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setJobPriorityJobDefinitionValidateBeforeCall(id, jobDefinitionPriorityDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call setJobRetriesJobDefinitionCall(String id, RetriesDto retriesDto, ApiCallback _callback) throws ApiException {
        RetriesDto localVarPostBody = retriesDto;
        String localVarPath = "/job-definition/{id}/retries".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setJobRetriesJobDefinitionValidateBeforeCall(String id, RetriesDto retriesDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling setJobRetriesJobDefinition(Async)");
        }
        Call localVarCall = this.setJobRetriesJobDefinitionCall(id, retriesDto, _callback);
        return localVarCall;
    }

    public void setJobRetriesJobDefinition(String id, RetriesDto retriesDto) throws ApiException {
        this.setJobRetriesJobDefinitionWithHttpInfo(id, retriesDto);
    }

    public ApiResponse<Void> setJobRetriesJobDefinitionWithHttpInfo(String id, RetriesDto retriesDto) throws ApiException {
        Call localVarCall = this.setJobRetriesJobDefinitionValidateBeforeCall(id, retriesDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call setJobRetriesJobDefinitionAsync(String id, RetriesDto retriesDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setJobRetriesJobDefinitionValidateBeforeCall(id, retriesDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateSuspensionStateJobDefinitionCall(String id, JobDefinitionSuspensionStateDto jobDefinitionSuspensionStateDto, ApiCallback _callback) throws ApiException {
        JobDefinitionSuspensionStateDto localVarPostBody = jobDefinitionSuspensionStateDto;
        String localVarPath = "/job-definition/{id}/suspended".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSuspensionStateJobDefinitionValidateBeforeCall(String id, JobDefinitionSuspensionStateDto jobDefinitionSuspensionStateDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateSuspensionStateJobDefinition(Async)");
        }
        Call localVarCall = this.updateSuspensionStateJobDefinitionCall(id, jobDefinitionSuspensionStateDto, _callback);
        return localVarCall;
    }

    public void updateSuspensionStateJobDefinition(String id, JobDefinitionSuspensionStateDto jobDefinitionSuspensionStateDto) throws ApiException {
        this.updateSuspensionStateJobDefinitionWithHttpInfo(id, jobDefinitionSuspensionStateDto);
    }

    public ApiResponse<Void> updateSuspensionStateJobDefinitionWithHttpInfo(String id, JobDefinitionSuspensionStateDto jobDefinitionSuspensionStateDto) throws ApiException {
        Call localVarCall = this.updateSuspensionStateJobDefinitionValidateBeforeCall(id, jobDefinitionSuspensionStateDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateSuspensionStateJobDefinitionAsync(String id, JobDefinitionSuspensionStateDto jobDefinitionSuspensionStateDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateSuspensionStateJobDefinitionValidateBeforeCall(id, jobDefinitionSuspensionStateDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateSuspensionStateJobDefinitionsCall(JobDefinitionsSuspensionStateDto jobDefinitionsSuspensionStateDto, ApiCallback _callback) throws ApiException {
        JobDefinitionsSuspensionStateDto localVarPostBody = jobDefinitionsSuspensionStateDto;
        String localVarPath = "/job-definition/suspended";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSuspensionStateJobDefinitionsValidateBeforeCall(JobDefinitionsSuspensionStateDto jobDefinitionsSuspensionStateDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.updateSuspensionStateJobDefinitionsCall(jobDefinitionsSuspensionStateDto, _callback);
        return localVarCall;
    }

    public void updateSuspensionStateJobDefinitions(JobDefinitionsSuspensionStateDto jobDefinitionsSuspensionStateDto) throws ApiException {
        this.updateSuspensionStateJobDefinitionsWithHttpInfo(jobDefinitionsSuspensionStateDto);
    }

    public ApiResponse<Void> updateSuspensionStateJobDefinitionsWithHttpInfo(JobDefinitionsSuspensionStateDto jobDefinitionsSuspensionStateDto) throws ApiException {
        Call localVarCall = this.updateSuspensionStateJobDefinitionsValidateBeforeCall(jobDefinitionsSuspensionStateDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateSuspensionStateJobDefinitionsAsync(JobDefinitionsSuspensionStateDto jobDefinitionsSuspensionStateDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateSuspensionStateJobDefinitionsValidateBeforeCall(jobDefinitionsSuspensionStateDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

