/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.17.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.api;

import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;
import org.camunda.community.rest.client.invoker.ProgressRequestBody;
import org.camunda.community.rest.client.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.camunda.community.rest.client.dto.BatchDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import java.util.Date;
import org.camunda.community.rest.client.dto.DeleteHistoricProcessInstancesDto;
import org.camunda.community.rest.client.dto.DurationReportResultDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.HistoricProcessInstanceDto;
import org.camunda.community.rest.client.dto.HistoricProcessInstanceQueryDto;
import org.camunda.community.rest.client.dto.SetRemovalTimeToHistoricProcessInstancesDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HistoricProcessInstanceApi {
    private ApiClient localVarApiClient;

    public HistoricProcessInstanceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HistoricProcessInstanceApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for deleteHistoricProcessInstance
     * @param id The id of the historic process instance to be deleted. (required)
     * @param failIfNotExists If set to &#x60;false&#x60;, the request will still be successful if the process id is not found. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found Historic process instance with given id does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteHistoricProcessInstanceCall(String id, Boolean failIfNotExists, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/process-instance/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (failIfNotExists != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("failIfNotExists", failIfNotExists));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteHistoricProcessInstanceValidateBeforeCall(String id, Boolean failIfNotExists, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteHistoricProcessInstance(Async)");
        }
        

        okhttp3.Call localVarCall = deleteHistoricProcessInstanceCall(id, failIfNotExists, _callback);
        return localVarCall;

    }

    /**
     * Delete
     * Deletes a process instance from the history by id.
     * @param id The id of the historic process instance to be deleted. (required)
     * @param failIfNotExists If set to &#x60;false&#x60;, the request will still be successful if the process id is not found. (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found Historic process instance with given id does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public void deleteHistoricProcessInstance(String id, Boolean failIfNotExists) throws ApiException {
        deleteHistoricProcessInstanceWithHttpInfo(id, failIfNotExists);
    }

    /**
     * Delete
     * Deletes a process instance from the history by id.
     * @param id The id of the historic process instance to be deleted. (required)
     * @param failIfNotExists If set to &#x60;false&#x60;, the request will still be successful if the process id is not found. (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found Historic process instance with given id does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteHistoricProcessInstanceWithHttpInfo(String id, Boolean failIfNotExists) throws ApiException {
        okhttp3.Call localVarCall = deleteHistoricProcessInstanceValidateBeforeCall(id, failIfNotExists, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete (asynchronously)
     * Deletes a process instance from the history by id.
     * @param id The id of the historic process instance to be deleted. (required)
     * @param failIfNotExists If set to &#x60;false&#x60;, the request will still be successful if the process id is not found. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found Historic process instance with given id does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteHistoricProcessInstanceAsync(String id, Boolean failIfNotExists, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteHistoricProcessInstanceValidateBeforeCall(id, failIfNotExists, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteHistoricProcessInstancesAsync
     * @param deleteHistoricProcessInstancesDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, i.e. neither historicProcessInstanceIds, nor historicProcessInstanceQuery is present. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteHistoricProcessInstancesAsyncCall(DeleteHistoricProcessInstancesDto deleteHistoricProcessInstancesDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = deleteHistoricProcessInstancesDto;

        // create path and map variables
        String localVarPath = "/history/process-instance/delete";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteHistoricProcessInstancesAsyncValidateBeforeCall(DeleteHistoricProcessInstancesDto deleteHistoricProcessInstancesDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = deleteHistoricProcessInstancesAsyncCall(deleteHistoricProcessInstancesDto, _callback);
        return localVarCall;

    }

    /**
     * Delete Async (POST)
     * Delete multiple historic process instances asynchronously (batch). At least &#x60;historicProcessInstanceIds&#x60; or &#x60;historicProcessInstanceQuery&#x60; has to be provided. If both are provided then all instances matching query criterion and instances from the list will be deleted.
     * @param deleteHistoricProcessInstancesDto  (optional)
     * @return BatchDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, i.e. neither historicProcessInstanceIds, nor historicProcessInstanceQuery is present. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public BatchDto deleteHistoricProcessInstancesAsync(DeleteHistoricProcessInstancesDto deleteHistoricProcessInstancesDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = deleteHistoricProcessInstancesAsyncWithHttpInfo(deleteHistoricProcessInstancesDto);
        return localVarResp.getData();
    }

    /**
     * Delete Async (POST)
     * Delete multiple historic process instances asynchronously (batch). At least &#x60;historicProcessInstanceIds&#x60; or &#x60;historicProcessInstanceQuery&#x60; has to be provided. If both are provided then all instances matching query criterion and instances from the list will be deleted.
     * @param deleteHistoricProcessInstancesDto  (optional)
     * @return ApiResponse&lt;BatchDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, i.e. neither historicProcessInstanceIds, nor historicProcessInstanceQuery is present. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BatchDto> deleteHistoricProcessInstancesAsyncWithHttpInfo(DeleteHistoricProcessInstancesDto deleteHistoricProcessInstancesDto) throws ApiException {
        okhttp3.Call localVarCall = deleteHistoricProcessInstancesAsyncValidateBeforeCall(deleteHistoricProcessInstancesDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Delete Async (POST) (asynchronously)
     * Delete multiple historic process instances asynchronously (batch). At least &#x60;historicProcessInstanceIds&#x60; or &#x60;historicProcessInstanceQuery&#x60; has to be provided. If both are provided then all instances matching query criterion and instances from the list will be deleted.
     * @param deleteHistoricProcessInstancesDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, i.e. neither historicProcessInstanceIds, nor historicProcessInstanceQuery is present. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteHistoricProcessInstancesAsyncAsync(DeleteHistoricProcessInstancesDto deleteHistoricProcessInstancesDto, final ApiCallback<BatchDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteHistoricProcessInstancesAsyncValidateBeforeCall(deleteHistoricProcessInstancesDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteHistoricVariableInstancesOfHistoricProcessInstance
     * @param id The id of the process instance for which all historic variables are to be deleted. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found Historic process instance with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#parse-exceptions) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteHistoricVariableInstancesOfHistoricProcessInstanceCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/process-instance/{id}/variable-instances"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteHistoricVariableInstancesOfHistoricProcessInstanceValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteHistoricVariableInstancesOfHistoricProcessInstance(Async)");
        }
        

        okhttp3.Call localVarCall = deleteHistoricVariableInstancesOfHistoricProcessInstanceCall(id, _callback);
        return localVarCall;

    }

    /**
     * Delete Variable Instances
     * Deletes all variables of a process instance from the history by id.
     * @param id The id of the process instance for which all historic variables are to be deleted. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found Historic process instance with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#parse-exceptions) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void deleteHistoricVariableInstancesOfHistoricProcessInstance(String id) throws ApiException {
        deleteHistoricVariableInstancesOfHistoricProcessInstanceWithHttpInfo(id);
    }

    /**
     * Delete Variable Instances
     * Deletes all variables of a process instance from the history by id.
     * @param id The id of the process instance for which all historic variables are to be deleted. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found Historic process instance with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#parse-exceptions) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteHistoricVariableInstancesOfHistoricProcessInstanceWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = deleteHistoricVariableInstancesOfHistoricProcessInstanceValidateBeforeCall(id, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete Variable Instances (asynchronously)
     * Deletes all variables of a process instance from the history by id.
     * @param id The id of the process instance for which all historic variables are to be deleted. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found Historic process instance with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#parse-exceptions) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteHistoricVariableInstancesOfHistoricProcessInstanceAsync(String id, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteHistoricVariableInstancesOfHistoricProcessInstanceValidateBeforeCall(id, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getHistoricProcessInstance
     * @param id The id of the historic process instance to be retrieved. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found Historic process instance with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricProcessInstanceCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/process-instance/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricProcessInstanceValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getHistoricProcessInstance(Async)");
        }
        

        okhttp3.Call localVarCall = getHistoricProcessInstanceCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get
     * Retrieves a historic process instance by id, according to the &#x60;HistoricProcessInstance&#x60; interface in the engine.
     * @param id The id of the historic process instance to be retrieved. (required)
     * @return HistoricProcessInstanceDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found Historic process instance with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public HistoricProcessInstanceDto getHistoricProcessInstance(String id) throws ApiException {
        ApiResponse<HistoricProcessInstanceDto> localVarResp = getHistoricProcessInstanceWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get
     * Retrieves a historic process instance by id, according to the &#x60;HistoricProcessInstance&#x60; interface in the engine.
     * @param id The id of the historic process instance to be retrieved. (required)
     * @return ApiResponse&lt;HistoricProcessInstanceDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found Historic process instance with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<HistoricProcessInstanceDto> getHistoricProcessInstanceWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getHistoricProcessInstanceValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<HistoricProcessInstanceDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get (asynchronously)
     * Retrieves a historic process instance by id, according to the &#x60;HistoricProcessInstance&#x60; interface in the engine.
     * @param id The id of the historic process instance to be retrieved. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found Historic process instance with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricProcessInstanceAsync(String id, final ApiCallback<HistoricProcessInstanceDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricProcessInstanceValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<HistoricProcessInstanceDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getHistoricProcessInstanceDurationReport
     * @param reportType **Mandatory.** Specifies the type of the report to retrieve. To retrieve a report about the duration of process instances, the value must be set to &#x60;duration&#x60;. (required)
     * @param periodUnit **Mandatory.** Specifies the granularity of the report. Valid values are &#x60;month&#x60; and &#x60;quarter&#x60;. (required)
     * @param processDefinitionIdIn Filter by process definition ids. Must be a comma-separated list of process definition ids. (optional)
     * @param processDefinitionKeyIn Filter by process definition keys. Must be a comma-separated list of process definition keys. (optional)
     * @param startedBefore Restrict to instances that were started before the given date. By [default](), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2016-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2016-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid or mandatory parameters are not supplied. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> If the authenticated user is unauthorized to read the history. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricProcessInstanceDurationReportCall(String reportType, String periodUnit, String processDefinitionIdIn, String processDefinitionKeyIn, Date startedBefore, Date startedAfter, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/process-instance/report";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (reportType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("reportType", reportType));
        }

        if (periodUnit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("periodUnit", periodUnit));
        }

        if (processDefinitionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionIdIn", processDefinitionIdIn));
        }

        if (processDefinitionKeyIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        }

        if (startedBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startedBefore", startedBefore));
        }

        if (startedAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startedAfter", startedAfter));
        }

        final String[] localVarAccepts = {
            "application/json", "application/csv", "text/csv"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricProcessInstanceDurationReportValidateBeforeCall(String reportType, String periodUnit, String processDefinitionIdIn, String processDefinitionKeyIn, Date startedBefore, Date startedAfter, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'reportType' is set
        if (reportType == null) {
            throw new ApiException("Missing the required parameter 'reportType' when calling getHistoricProcessInstanceDurationReport(Async)");
        }
        
        // verify the required parameter 'periodUnit' is set
        if (periodUnit == null) {
            throw new ApiException("Missing the required parameter 'periodUnit' when calling getHistoricProcessInstanceDurationReport(Async)");
        }
        

        okhttp3.Call localVarCall = getHistoricProcessInstanceDurationReportCall(reportType, periodUnit, processDefinitionIdIn, processDefinitionKeyIn, startedBefore, startedAfter, _callback);
        return localVarCall;

    }

    /**
     * Get Duration Report
     * Retrieves a report about the duration of completed process instances, grouped by a period. These reports include the maximum, minimum and average duration of all completed process instances which were started in a given period.  **Note:** This only includes historic data.
     * @param reportType **Mandatory.** Specifies the type of the report to retrieve. To retrieve a report about the duration of process instances, the value must be set to &#x60;duration&#x60;. (required)
     * @param periodUnit **Mandatory.** Specifies the granularity of the report. Valid values are &#x60;month&#x60; and &#x60;quarter&#x60;. (required)
     * @param processDefinitionIdIn Filter by process definition ids. Must be a comma-separated list of process definition ids. (optional)
     * @param processDefinitionKeyIn Filter by process definition keys. Must be a comma-separated list of process definition keys. (optional)
     * @param startedBefore Restrict to instances that were started before the given date. By [default](), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2016-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2016-01-23T14:42:45.000+0200&#x60;. (optional)
     * @return List&lt;DurationReportResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid or mandatory parameters are not supplied. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> If the authenticated user is unauthorized to read the history. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<DurationReportResultDto> getHistoricProcessInstanceDurationReport(String reportType, String periodUnit, String processDefinitionIdIn, String processDefinitionKeyIn, Date startedBefore, Date startedAfter) throws ApiException {
        ApiResponse<List<DurationReportResultDto>> localVarResp = getHistoricProcessInstanceDurationReportWithHttpInfo(reportType, periodUnit, processDefinitionIdIn, processDefinitionKeyIn, startedBefore, startedAfter);
        return localVarResp.getData();
    }

    /**
     * Get Duration Report
     * Retrieves a report about the duration of completed process instances, grouped by a period. These reports include the maximum, minimum and average duration of all completed process instances which were started in a given period.  **Note:** This only includes historic data.
     * @param reportType **Mandatory.** Specifies the type of the report to retrieve. To retrieve a report about the duration of process instances, the value must be set to &#x60;duration&#x60;. (required)
     * @param periodUnit **Mandatory.** Specifies the granularity of the report. Valid values are &#x60;month&#x60; and &#x60;quarter&#x60;. (required)
     * @param processDefinitionIdIn Filter by process definition ids. Must be a comma-separated list of process definition ids. (optional)
     * @param processDefinitionKeyIn Filter by process definition keys. Must be a comma-separated list of process definition keys. (optional)
     * @param startedBefore Restrict to instances that were started before the given date. By [default](), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2016-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2016-01-23T14:42:45.000+0200&#x60;. (optional)
     * @return ApiResponse&lt;List&lt;DurationReportResultDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid or mandatory parameters are not supplied. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> If the authenticated user is unauthorized to read the history. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<DurationReportResultDto>> getHistoricProcessInstanceDurationReportWithHttpInfo(String reportType, String periodUnit, String processDefinitionIdIn, String processDefinitionKeyIn, Date startedBefore, Date startedAfter) throws ApiException {
        okhttp3.Call localVarCall = getHistoricProcessInstanceDurationReportValidateBeforeCall(reportType, periodUnit, processDefinitionIdIn, processDefinitionKeyIn, startedBefore, startedAfter, null);
        Type localVarReturnType = new TypeToken<List<DurationReportResultDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Duration Report (asynchronously)
     * Retrieves a report about the duration of completed process instances, grouped by a period. These reports include the maximum, minimum and average duration of all completed process instances which were started in a given period.  **Note:** This only includes historic data.
     * @param reportType **Mandatory.** Specifies the type of the report to retrieve. To retrieve a report about the duration of process instances, the value must be set to &#x60;duration&#x60;. (required)
     * @param periodUnit **Mandatory.** Specifies the granularity of the report. Valid values are &#x60;month&#x60; and &#x60;quarter&#x60;. (required)
     * @param processDefinitionIdIn Filter by process definition ids. Must be a comma-separated list of process definition ids. (optional)
     * @param processDefinitionKeyIn Filter by process definition keys. Must be a comma-separated list of process definition keys. (optional)
     * @param startedBefore Restrict to instances that were started before the given date. By [default](), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2016-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2016-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid or mandatory parameters are not supplied. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> If the authenticated user is unauthorized to read the history. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricProcessInstanceDurationReportAsync(String reportType, String periodUnit, String processDefinitionIdIn, String processDefinitionKeyIn, Date startedBefore, Date startedAfter, final ApiCallback<List<DurationReportResultDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricProcessInstanceDurationReportValidateBeforeCall(reportType, periodUnit, processDefinitionIdIn, processDefinitionKeyIn, startedBefore, startedAfter, _callback);
        Type localVarReturnType = new TypeToken<List<DurationReportResultDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getHistoricProcessInstances
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processInstanceIds Filter by process instance ids. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
     * @param processDefinitionId Filter by the process definition the instances run on. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the instances run on. (optional)
     * @param processDefinitionKeyIn Filter by a list of process definition keys. A process instance must have one of the given process definition keys. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
     * @param processDefinitionName Filter by the name of the process definition the instances run on. (optional)
     * @param processDefinitionNameLike Filter by process definition names that the parameter is a substring of. (optional)
     * @param processDefinitionKeyNotIn Exclude instances that belong to a set of process definitions. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
     * @param processInstanceBusinessKey Filter by process instance business key. (optional)
     * @param processInstanceBusinessKeyIn Filter by a list of business keys. A process instance must have one of the given business keys. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param processInstanceBusinessKeyLike Filter by process instance business key that the parameter is a substring of. (optional)
     * @param rootProcessInstances Restrict the query to all process instances that are top level process instances. (optional)
     * @param finished Only include finished process instances. This flag includes all process instances that are completed or terminated. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param unfinished Only include unfinished process instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withIncidents Only include process instances which have an incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withRootIncidents Only include process instances which have a root incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentStatus Only include process instances which have an incident in status either open or resolved. To get all process instances, use the query parameter withIncidents. (optional)
     * @param incidentMessage Filter by the incident message. Exact match. (optional)
     * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
     * @param startedBefore Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedBefore Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedAfter Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedActivityAfter Restrict to instances that executed an activity after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedActivityBefore Restrict to instances that executed an activity before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedJobAfter Restrict to instances that executed an job after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedJobBefore Restrict to instances that executed an job before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedBy Only include process instances that were started by the given user. (optional)
     * @param superProcessInstanceId Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id. (optional)
     * @param subProcessInstanceId Restrict query to one process instance that has a sub process instance with the given id. (optional)
     * @param superCaseInstanceId Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
     * @param subCaseInstanceId Restrict query to one process instance that has a sub case instance with the given id. (optional)
     * @param caseInstanceId Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
     * @param tenantIdIn Filter by a list of tenant ids. A process instance must have one of the given tenant ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param withoutTenantId Only include historic process instances which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param executedActivityIdIn Restrict to instances that executed an activity with one of given ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param activeActivityIdIn Restrict to instances that have an active activity with one of given ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param active Restrict to instances that are active. (optional)
     * @param suspended Restrict to instances that are suspended. (optional)
     * @param completed Restrict to instances that are completed. (optional)
     * @param externallyTerminated Restrict to instances that are externallyTerminated. (optional)
     * @param internallyTerminated Restrict to instances that are internallyTerminated. (optional)
     * @param variables Only include process instances that have/had variables with certain values. Variable filtering expressions are comma-separated and are structured as follows: A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note:** Values are always treated as String objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;.  Key and value may not contain underscore or comma characters.  (optional)
     * @param variableNamesIgnoreCase Match all variable names provided in variables case-insensitively. If set to &#x60;true&#x60; variableName and variablename are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match all variable values provided in variables case-insensitively. If set to &#x60;true&#x60; variableValue and variablevalue are treated as equal. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if a sortOrder parameter is supplied, but no sortBy. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricProcessInstancesCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, Date executedActivityAfter, Date executedActivityBefore, Date executedJobAfter, Date executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/process-instance";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        if (processInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }

        if (processInstanceIds != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceIds", processInstanceIds));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }

        if (processDefinitionKeyIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        }

        if (processDefinitionName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionName", processDefinitionName));
        }

        if (processDefinitionNameLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionNameLike", processDefinitionNameLike));
        }

        if (processDefinitionKeyNotIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKeyNotIn", processDefinitionKeyNotIn));
        }

        if (processInstanceBusinessKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceBusinessKey", processInstanceBusinessKey));
        }

        if (processInstanceBusinessKeyIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceBusinessKeyIn", processInstanceBusinessKeyIn));
        }

        if (processInstanceBusinessKeyLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceBusinessKeyLike", processInstanceBusinessKeyLike));
        }

        if (rootProcessInstances != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("rootProcessInstances", rootProcessInstances));
        }

        if (finished != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("finished", finished));
        }

        if (unfinished != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("unfinished", unfinished));
        }

        if (withIncidents != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withIncidents", withIncidents));
        }

        if (withRootIncidents != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withRootIncidents", withRootIncidents));
        }

        if (incidentType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentType", incidentType));
        }

        if (incidentStatus != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentStatus", incidentStatus));
        }

        if (incidentMessage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentMessage", incidentMessage));
        }

        if (incidentMessageLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        }

        if (startedBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startedBefore", startedBefore));
        }

        if (startedAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startedAfter", startedAfter));
        }

        if (finishedBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("finishedBefore", finishedBefore));
        }

        if (finishedAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("finishedAfter", finishedAfter));
        }

        if (executedActivityAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executedActivityAfter", executedActivityAfter));
        }

        if (executedActivityBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executedActivityBefore", executedActivityBefore));
        }

        if (executedJobAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executedJobAfter", executedJobAfter));
        }

        if (executedJobBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executedJobBefore", executedJobBefore));
        }

        if (startedBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startedBy", startedBy));
        }

        if (superProcessInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("superProcessInstanceId", superProcessInstanceId));
        }

        if (subProcessInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("subProcessInstanceId", subProcessInstanceId));
        }

        if (superCaseInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("superCaseInstanceId", superCaseInstanceId));
        }

        if (subCaseInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("subCaseInstanceId", subCaseInstanceId));
        }

        if (caseInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseInstanceId", caseInstanceId));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (executedActivityIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executedActivityIdIn", executedActivityIdIn));
        }

        if (activeActivityIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activeActivityIdIn", activeActivityIdIn));
        }

        if (active != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("active", active));
        }

        if (suspended != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("suspended", suspended));
        }

        if (completed != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("completed", completed));
        }

        if (externallyTerminated != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("externallyTerminated", externallyTerminated));
        }

        if (internallyTerminated != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("internallyTerminated", internallyTerminated));
        }

        if (variables != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variables", variables));
        }

        if (variableNamesIgnoreCase != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
        }

        if (variableValuesIgnoreCase != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricProcessInstancesValidateBeforeCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, Date executedActivityAfter, Date executedActivityBefore, Date executedJobAfter, Date executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getHistoricProcessInstancesCall(sortBy, sortOrder, firstResult, maxResults, processInstanceId, processInstanceIds, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, processDefinitionKeyNotIn, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, rootProcessInstances, finished, unfinished, withIncidents, withRootIncidents, incidentType, incidentStatus, incidentMessage, incidentMessageLike, startedBefore, startedAfter, finishedBefore, finishedAfter, executedActivityAfter, executedActivityBefore, executedJobAfter, executedJobBefore, startedBy, superProcessInstanceId, subProcessInstanceId, superCaseInstanceId, subCaseInstanceId, caseInstanceId, tenantIdIn, withoutTenantId, executedActivityIdIn, activeActivityIdIn, active, suspended, completed, externallyTerminated, internallyTerminated, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, _callback);
        return localVarCall;

    }

    /**
     * Get List
     * Queries for historic process instances that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Process Instance Count](https://docs.camunda.org/manual/7.17/reference/rest/history/process-instance/get-process-instance-query-count/) method.
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processInstanceIds Filter by process instance ids. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
     * @param processDefinitionId Filter by the process definition the instances run on. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the instances run on. (optional)
     * @param processDefinitionKeyIn Filter by a list of process definition keys. A process instance must have one of the given process definition keys. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
     * @param processDefinitionName Filter by the name of the process definition the instances run on. (optional)
     * @param processDefinitionNameLike Filter by process definition names that the parameter is a substring of. (optional)
     * @param processDefinitionKeyNotIn Exclude instances that belong to a set of process definitions. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
     * @param processInstanceBusinessKey Filter by process instance business key. (optional)
     * @param processInstanceBusinessKeyIn Filter by a list of business keys. A process instance must have one of the given business keys. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param processInstanceBusinessKeyLike Filter by process instance business key that the parameter is a substring of. (optional)
     * @param rootProcessInstances Restrict the query to all process instances that are top level process instances. (optional)
     * @param finished Only include finished process instances. This flag includes all process instances that are completed or terminated. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param unfinished Only include unfinished process instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withIncidents Only include process instances which have an incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withRootIncidents Only include process instances which have a root incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentStatus Only include process instances which have an incident in status either open or resolved. To get all process instances, use the query parameter withIncidents. (optional)
     * @param incidentMessage Filter by the incident message. Exact match. (optional)
     * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
     * @param startedBefore Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedBefore Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedAfter Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedActivityAfter Restrict to instances that executed an activity after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedActivityBefore Restrict to instances that executed an activity before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedJobAfter Restrict to instances that executed an job after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedJobBefore Restrict to instances that executed an job before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedBy Only include process instances that were started by the given user. (optional)
     * @param superProcessInstanceId Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id. (optional)
     * @param subProcessInstanceId Restrict query to one process instance that has a sub process instance with the given id. (optional)
     * @param superCaseInstanceId Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
     * @param subCaseInstanceId Restrict query to one process instance that has a sub case instance with the given id. (optional)
     * @param caseInstanceId Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
     * @param tenantIdIn Filter by a list of tenant ids. A process instance must have one of the given tenant ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param withoutTenantId Only include historic process instances which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param executedActivityIdIn Restrict to instances that executed an activity with one of given ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param activeActivityIdIn Restrict to instances that have an active activity with one of given ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param active Restrict to instances that are active. (optional)
     * @param suspended Restrict to instances that are suspended. (optional)
     * @param completed Restrict to instances that are completed. (optional)
     * @param externallyTerminated Restrict to instances that are externallyTerminated. (optional)
     * @param internallyTerminated Restrict to instances that are internallyTerminated. (optional)
     * @param variables Only include process instances that have/had variables with certain values. Variable filtering expressions are comma-separated and are structured as follows: A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note:** Values are always treated as String objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;.  Key and value may not contain underscore or comma characters.  (optional)
     * @param variableNamesIgnoreCase Match all variable names provided in variables case-insensitively. If set to &#x60;true&#x60; variableName and variablename are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match all variable values provided in variables case-insensitively. If set to &#x60;true&#x60; variableValue and variablevalue are treated as equal. (optional)
     * @return List&lt;HistoricProcessInstanceDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if a sortOrder parameter is supplied, but no sortBy. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<HistoricProcessInstanceDto> getHistoricProcessInstances(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, Date executedActivityAfter, Date executedActivityBefore, Date executedJobAfter, Date executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase) throws ApiException {
        ApiResponse<List<HistoricProcessInstanceDto>> localVarResp = getHistoricProcessInstancesWithHttpInfo(sortBy, sortOrder, firstResult, maxResults, processInstanceId, processInstanceIds, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, processDefinitionKeyNotIn, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, rootProcessInstances, finished, unfinished, withIncidents, withRootIncidents, incidentType, incidentStatus, incidentMessage, incidentMessageLike, startedBefore, startedAfter, finishedBefore, finishedAfter, executedActivityAfter, executedActivityBefore, executedJobAfter, executedJobBefore, startedBy, superProcessInstanceId, subProcessInstanceId, superCaseInstanceId, subCaseInstanceId, caseInstanceId, tenantIdIn, withoutTenantId, executedActivityIdIn, activeActivityIdIn, active, suspended, completed, externallyTerminated, internallyTerminated, variables, variableNamesIgnoreCase, variableValuesIgnoreCase);
        return localVarResp.getData();
    }

    /**
     * Get List
     * Queries for historic process instances that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Process Instance Count](https://docs.camunda.org/manual/7.17/reference/rest/history/process-instance/get-process-instance-query-count/) method.
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processInstanceIds Filter by process instance ids. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
     * @param processDefinitionId Filter by the process definition the instances run on. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the instances run on. (optional)
     * @param processDefinitionKeyIn Filter by a list of process definition keys. A process instance must have one of the given process definition keys. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
     * @param processDefinitionName Filter by the name of the process definition the instances run on. (optional)
     * @param processDefinitionNameLike Filter by process definition names that the parameter is a substring of. (optional)
     * @param processDefinitionKeyNotIn Exclude instances that belong to a set of process definitions. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
     * @param processInstanceBusinessKey Filter by process instance business key. (optional)
     * @param processInstanceBusinessKeyIn Filter by a list of business keys. A process instance must have one of the given business keys. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param processInstanceBusinessKeyLike Filter by process instance business key that the parameter is a substring of. (optional)
     * @param rootProcessInstances Restrict the query to all process instances that are top level process instances. (optional)
     * @param finished Only include finished process instances. This flag includes all process instances that are completed or terminated. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param unfinished Only include unfinished process instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withIncidents Only include process instances which have an incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withRootIncidents Only include process instances which have a root incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentStatus Only include process instances which have an incident in status either open or resolved. To get all process instances, use the query parameter withIncidents. (optional)
     * @param incidentMessage Filter by the incident message. Exact match. (optional)
     * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
     * @param startedBefore Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedBefore Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedAfter Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedActivityAfter Restrict to instances that executed an activity after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedActivityBefore Restrict to instances that executed an activity before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedJobAfter Restrict to instances that executed an job after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedJobBefore Restrict to instances that executed an job before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedBy Only include process instances that were started by the given user. (optional)
     * @param superProcessInstanceId Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id. (optional)
     * @param subProcessInstanceId Restrict query to one process instance that has a sub process instance with the given id. (optional)
     * @param superCaseInstanceId Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
     * @param subCaseInstanceId Restrict query to one process instance that has a sub case instance with the given id. (optional)
     * @param caseInstanceId Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
     * @param tenantIdIn Filter by a list of tenant ids. A process instance must have one of the given tenant ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param withoutTenantId Only include historic process instances which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param executedActivityIdIn Restrict to instances that executed an activity with one of given ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param activeActivityIdIn Restrict to instances that have an active activity with one of given ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param active Restrict to instances that are active. (optional)
     * @param suspended Restrict to instances that are suspended. (optional)
     * @param completed Restrict to instances that are completed. (optional)
     * @param externallyTerminated Restrict to instances that are externallyTerminated. (optional)
     * @param internallyTerminated Restrict to instances that are internallyTerminated. (optional)
     * @param variables Only include process instances that have/had variables with certain values. Variable filtering expressions are comma-separated and are structured as follows: A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note:** Values are always treated as String objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;.  Key and value may not contain underscore or comma characters.  (optional)
     * @param variableNamesIgnoreCase Match all variable names provided in variables case-insensitively. If set to &#x60;true&#x60; variableName and variablename are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match all variable values provided in variables case-insensitively. If set to &#x60;true&#x60; variableValue and variablevalue are treated as equal. (optional)
     * @return ApiResponse&lt;List&lt;HistoricProcessInstanceDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if a sortOrder parameter is supplied, but no sortBy. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<HistoricProcessInstanceDto>> getHistoricProcessInstancesWithHttpInfo(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, Date executedActivityAfter, Date executedActivityBefore, Date executedJobAfter, Date executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase) throws ApiException {
        okhttp3.Call localVarCall = getHistoricProcessInstancesValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, processInstanceId, processInstanceIds, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, processDefinitionKeyNotIn, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, rootProcessInstances, finished, unfinished, withIncidents, withRootIncidents, incidentType, incidentStatus, incidentMessage, incidentMessageLike, startedBefore, startedAfter, finishedBefore, finishedAfter, executedActivityAfter, executedActivityBefore, executedJobAfter, executedJobBefore, startedBy, superProcessInstanceId, subProcessInstanceId, superCaseInstanceId, subCaseInstanceId, caseInstanceId, tenantIdIn, withoutTenantId, executedActivityIdIn, activeActivityIdIn, active, suspended, completed, externallyTerminated, internallyTerminated, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, null);
        Type localVarReturnType = new TypeToken<List<HistoricProcessInstanceDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get List (asynchronously)
     * Queries for historic process instances that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Process Instance Count](https://docs.camunda.org/manual/7.17/reference/rest/history/process-instance/get-process-instance-query-count/) method.
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processInstanceIds Filter by process instance ids. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
     * @param processDefinitionId Filter by the process definition the instances run on. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the instances run on. (optional)
     * @param processDefinitionKeyIn Filter by a list of process definition keys. A process instance must have one of the given process definition keys. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
     * @param processDefinitionName Filter by the name of the process definition the instances run on. (optional)
     * @param processDefinitionNameLike Filter by process definition names that the parameter is a substring of. (optional)
     * @param processDefinitionKeyNotIn Exclude instances that belong to a set of process definitions. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
     * @param processInstanceBusinessKey Filter by process instance business key. (optional)
     * @param processInstanceBusinessKeyIn Filter by a list of business keys. A process instance must have one of the given business keys. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param processInstanceBusinessKeyLike Filter by process instance business key that the parameter is a substring of. (optional)
     * @param rootProcessInstances Restrict the query to all process instances that are top level process instances. (optional)
     * @param finished Only include finished process instances. This flag includes all process instances that are completed or terminated. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param unfinished Only include unfinished process instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withIncidents Only include process instances which have an incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withRootIncidents Only include process instances which have a root incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentStatus Only include process instances which have an incident in status either open or resolved. To get all process instances, use the query parameter withIncidents. (optional)
     * @param incidentMessage Filter by the incident message. Exact match. (optional)
     * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
     * @param startedBefore Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedBefore Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedAfter Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedActivityAfter Restrict to instances that executed an activity after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedActivityBefore Restrict to instances that executed an activity before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedJobAfter Restrict to instances that executed an job after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedJobBefore Restrict to instances that executed an job before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedBy Only include process instances that were started by the given user. (optional)
     * @param superProcessInstanceId Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id. (optional)
     * @param subProcessInstanceId Restrict query to one process instance that has a sub process instance with the given id. (optional)
     * @param superCaseInstanceId Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
     * @param subCaseInstanceId Restrict query to one process instance that has a sub case instance with the given id. (optional)
     * @param caseInstanceId Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
     * @param tenantIdIn Filter by a list of tenant ids. A process instance must have one of the given tenant ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param withoutTenantId Only include historic process instances which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param executedActivityIdIn Restrict to instances that executed an activity with one of given ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param activeActivityIdIn Restrict to instances that have an active activity with one of given ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param active Restrict to instances that are active. (optional)
     * @param suspended Restrict to instances that are suspended. (optional)
     * @param completed Restrict to instances that are completed. (optional)
     * @param externallyTerminated Restrict to instances that are externallyTerminated. (optional)
     * @param internallyTerminated Restrict to instances that are internallyTerminated. (optional)
     * @param variables Only include process instances that have/had variables with certain values. Variable filtering expressions are comma-separated and are structured as follows: A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note:** Values are always treated as String objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;.  Key and value may not contain underscore or comma characters.  (optional)
     * @param variableNamesIgnoreCase Match all variable names provided in variables case-insensitively. If set to &#x60;true&#x60; variableName and variablename are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match all variable values provided in variables case-insensitively. If set to &#x60;true&#x60; variableValue and variablevalue are treated as equal. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if a sortOrder parameter is supplied, but no sortBy. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricProcessInstancesAsync(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, Date executedActivityAfter, Date executedActivityBefore, Date executedJobAfter, Date executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, final ApiCallback<List<HistoricProcessInstanceDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricProcessInstancesValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, processInstanceId, processInstanceIds, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, processDefinitionKeyNotIn, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, rootProcessInstances, finished, unfinished, withIncidents, withRootIncidents, incidentType, incidentStatus, incidentMessage, incidentMessageLike, startedBefore, startedAfter, finishedBefore, finishedAfter, executedActivityAfter, executedActivityBefore, executedJobAfter, executedJobBefore, startedBy, superProcessInstanceId, subProcessInstanceId, superCaseInstanceId, subCaseInstanceId, caseInstanceId, tenantIdIn, withoutTenantId, executedActivityIdIn, activeActivityIdIn, active, suspended, completed, externallyTerminated, internallyTerminated, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, _callback);
        Type localVarReturnType = new TypeToken<List<HistoricProcessInstanceDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getHistoricProcessInstancesCount
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processInstanceIds Filter by process instance ids. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
     * @param processDefinitionId Filter by the process definition the instances run on. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the instances run on. (optional)
     * @param processDefinitionKeyIn Filter by a list of process definition keys. A process instance must have one of the given process definition keys. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
     * @param processDefinitionName Filter by the name of the process definition the instances run on. (optional)
     * @param processDefinitionNameLike Filter by process definition names that the parameter is a substring of. (optional)
     * @param processDefinitionKeyNotIn Exclude instances that belong to a set of process definitions. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
     * @param processInstanceBusinessKey Filter by process instance business key. (optional)
     * @param processInstanceBusinessKeyIn Filter by a list of business keys. A process instance must have one of the given business keys. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param processInstanceBusinessKeyLike Filter by process instance business key that the parameter is a substring of. (optional)
     * @param rootProcessInstances Restrict the query to all process instances that are top level process instances. (optional)
     * @param finished Only include finished process instances. This flag includes all process instances that are completed or terminated. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param unfinished Only include unfinished process instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withIncidents Only include process instances which have an incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withRootIncidents Only include process instances which have a root incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentStatus Only include process instances which have an incident in status either open or resolved. To get all process instances, use the query parameter withIncidents. (optional)
     * @param incidentMessage Filter by the incident message. Exact match. (optional)
     * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
     * @param startedBefore Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedBefore Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedAfter Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedActivityAfter Restrict to instances that executed an activity after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedActivityBefore Restrict to instances that executed an activity before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedJobAfter Restrict to instances that executed an job after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedJobBefore Restrict to instances that executed an job before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedBy Only include process instances that were started by the given user. (optional)
     * @param superProcessInstanceId Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id. (optional)
     * @param subProcessInstanceId Restrict query to one process instance that has a sub process instance with the given id. (optional)
     * @param superCaseInstanceId Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
     * @param subCaseInstanceId Restrict query to one process instance that has a sub case instance with the given id. (optional)
     * @param caseInstanceId Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
     * @param tenantIdIn Filter by a list of tenant ids. A process instance must have one of the given tenant ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param withoutTenantId Only include historic process instances which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param executedActivityIdIn Restrict to instances that executed an activity with one of given ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param activeActivityIdIn Restrict to instances that have an active activity with one of given ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param active Restrict to instances that are active. (optional)
     * @param suspended Restrict to instances that are suspended. (optional)
     * @param completed Restrict to instances that are completed. (optional)
     * @param externallyTerminated Restrict to instances that are externallyTerminated. (optional)
     * @param internallyTerminated Restrict to instances that are internallyTerminated. (optional)
     * @param variables Only include process instances that have/had variables with certain values. Variable filtering expressions are comma-separated and are structured as follows: A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note:** Values are always treated as String objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;.  Key and value may not contain underscore or comma characters.  (optional)
     * @param variableNamesIgnoreCase Match all variable names provided in variables case-insensitively. If set to &#x60;true&#x60; variableName and variablename are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match all variable values provided in variables case-insensitively. If set to &#x60;true&#x60; variableValue and variablevalue are treated as equal. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricProcessInstancesCountCall(String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, Date executedActivityAfter, Date executedActivityBefore, Date executedJobAfter, Date executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/process-instance/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (processInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }

        if (processInstanceIds != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceIds", processInstanceIds));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }

        if (processDefinitionKeyIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        }

        if (processDefinitionName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionName", processDefinitionName));
        }

        if (processDefinitionNameLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionNameLike", processDefinitionNameLike));
        }

        if (processDefinitionKeyNotIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKeyNotIn", processDefinitionKeyNotIn));
        }

        if (processInstanceBusinessKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceBusinessKey", processInstanceBusinessKey));
        }

        if (processInstanceBusinessKeyIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceBusinessKeyIn", processInstanceBusinessKeyIn));
        }

        if (processInstanceBusinessKeyLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceBusinessKeyLike", processInstanceBusinessKeyLike));
        }

        if (rootProcessInstances != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("rootProcessInstances", rootProcessInstances));
        }

        if (finished != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("finished", finished));
        }

        if (unfinished != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("unfinished", unfinished));
        }

        if (withIncidents != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withIncidents", withIncidents));
        }

        if (withRootIncidents != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withRootIncidents", withRootIncidents));
        }

        if (incidentType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentType", incidentType));
        }

        if (incidentStatus != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentStatus", incidentStatus));
        }

        if (incidentMessage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentMessage", incidentMessage));
        }

        if (incidentMessageLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        }

        if (startedBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startedBefore", startedBefore));
        }

        if (startedAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startedAfter", startedAfter));
        }

        if (finishedBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("finishedBefore", finishedBefore));
        }

        if (finishedAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("finishedAfter", finishedAfter));
        }

        if (executedActivityAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executedActivityAfter", executedActivityAfter));
        }

        if (executedActivityBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executedActivityBefore", executedActivityBefore));
        }

        if (executedJobAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executedJobAfter", executedJobAfter));
        }

        if (executedJobBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executedJobBefore", executedJobBefore));
        }

        if (startedBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startedBy", startedBy));
        }

        if (superProcessInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("superProcessInstanceId", superProcessInstanceId));
        }

        if (subProcessInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("subProcessInstanceId", subProcessInstanceId));
        }

        if (superCaseInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("superCaseInstanceId", superCaseInstanceId));
        }

        if (subCaseInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("subCaseInstanceId", subCaseInstanceId));
        }

        if (caseInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseInstanceId", caseInstanceId));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (executedActivityIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executedActivityIdIn", executedActivityIdIn));
        }

        if (activeActivityIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activeActivityIdIn", activeActivityIdIn));
        }

        if (active != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("active", active));
        }

        if (suspended != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("suspended", suspended));
        }

        if (completed != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("completed", completed));
        }

        if (externallyTerminated != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("externallyTerminated", externallyTerminated));
        }

        if (internallyTerminated != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("internallyTerminated", internallyTerminated));
        }

        if (variables != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variables", variables));
        }

        if (variableNamesIgnoreCase != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
        }

        if (variableValuesIgnoreCase != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricProcessInstancesCountValidateBeforeCall(String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, Date executedActivityAfter, Date executedActivityBefore, Date executedJobAfter, Date executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getHistoricProcessInstancesCountCall(processInstanceId, processInstanceIds, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, processDefinitionKeyNotIn, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, rootProcessInstances, finished, unfinished, withIncidents, withRootIncidents, incidentType, incidentStatus, incidentMessage, incidentMessageLike, startedBefore, startedAfter, finishedBefore, finishedAfter, executedActivityAfter, executedActivityBefore, executedJobAfter, executedJobBefore, startedBy, superProcessInstanceId, subProcessInstanceId, superCaseInstanceId, subCaseInstanceId, caseInstanceId, tenantIdIn, withoutTenantId, executedActivityIdIn, activeActivityIdIn, active, suspended, completed, externallyTerminated, internallyTerminated, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, _callback);
        return localVarCall;

    }

    /**
     * Get List Count
     * Queries for the number of historic process instances that fulfill the given parameters. Takes the same parameters as the [Get Process Instances](https://docs.camunda.org/manual/7.17/reference/rest/history/process-instance/get-process-instance-query/) method.
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processInstanceIds Filter by process instance ids. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
     * @param processDefinitionId Filter by the process definition the instances run on. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the instances run on. (optional)
     * @param processDefinitionKeyIn Filter by a list of process definition keys. A process instance must have one of the given process definition keys. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
     * @param processDefinitionName Filter by the name of the process definition the instances run on. (optional)
     * @param processDefinitionNameLike Filter by process definition names that the parameter is a substring of. (optional)
     * @param processDefinitionKeyNotIn Exclude instances that belong to a set of process definitions. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
     * @param processInstanceBusinessKey Filter by process instance business key. (optional)
     * @param processInstanceBusinessKeyIn Filter by a list of business keys. A process instance must have one of the given business keys. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param processInstanceBusinessKeyLike Filter by process instance business key that the parameter is a substring of. (optional)
     * @param rootProcessInstances Restrict the query to all process instances that are top level process instances. (optional)
     * @param finished Only include finished process instances. This flag includes all process instances that are completed or terminated. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param unfinished Only include unfinished process instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withIncidents Only include process instances which have an incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withRootIncidents Only include process instances which have a root incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentStatus Only include process instances which have an incident in status either open or resolved. To get all process instances, use the query parameter withIncidents. (optional)
     * @param incidentMessage Filter by the incident message. Exact match. (optional)
     * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
     * @param startedBefore Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedBefore Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedAfter Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedActivityAfter Restrict to instances that executed an activity after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedActivityBefore Restrict to instances that executed an activity before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedJobAfter Restrict to instances that executed an job after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedJobBefore Restrict to instances that executed an job before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedBy Only include process instances that were started by the given user. (optional)
     * @param superProcessInstanceId Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id. (optional)
     * @param subProcessInstanceId Restrict query to one process instance that has a sub process instance with the given id. (optional)
     * @param superCaseInstanceId Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
     * @param subCaseInstanceId Restrict query to one process instance that has a sub case instance with the given id. (optional)
     * @param caseInstanceId Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
     * @param tenantIdIn Filter by a list of tenant ids. A process instance must have one of the given tenant ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param withoutTenantId Only include historic process instances which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param executedActivityIdIn Restrict to instances that executed an activity with one of given ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param activeActivityIdIn Restrict to instances that have an active activity with one of given ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param active Restrict to instances that are active. (optional)
     * @param suspended Restrict to instances that are suspended. (optional)
     * @param completed Restrict to instances that are completed. (optional)
     * @param externallyTerminated Restrict to instances that are externallyTerminated. (optional)
     * @param internallyTerminated Restrict to instances that are internallyTerminated. (optional)
     * @param variables Only include process instances that have/had variables with certain values. Variable filtering expressions are comma-separated and are structured as follows: A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note:** Values are always treated as String objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;.  Key and value may not contain underscore or comma characters.  (optional)
     * @param variableNamesIgnoreCase Match all variable names provided in variables case-insensitively. If set to &#x60;true&#x60; variableName and variablename are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match all variable values provided in variables case-insensitively. If set to &#x60;true&#x60; variableValue and variablevalue are treated as equal. (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto getHistoricProcessInstancesCount(String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, Date executedActivityAfter, Date executedActivityBefore, Date executedJobAfter, Date executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = getHistoricProcessInstancesCountWithHttpInfo(processInstanceId, processInstanceIds, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, processDefinitionKeyNotIn, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, rootProcessInstances, finished, unfinished, withIncidents, withRootIncidents, incidentType, incidentStatus, incidentMessage, incidentMessageLike, startedBefore, startedAfter, finishedBefore, finishedAfter, executedActivityAfter, executedActivityBefore, executedJobAfter, executedJobBefore, startedBy, superProcessInstanceId, subProcessInstanceId, superCaseInstanceId, subCaseInstanceId, caseInstanceId, tenantIdIn, withoutTenantId, executedActivityIdIn, activeActivityIdIn, active, suspended, completed, externallyTerminated, internallyTerminated, variables, variableNamesIgnoreCase, variableValuesIgnoreCase);
        return localVarResp.getData();
    }

    /**
     * Get List Count
     * Queries for the number of historic process instances that fulfill the given parameters. Takes the same parameters as the [Get Process Instances](https://docs.camunda.org/manual/7.17/reference/rest/history/process-instance/get-process-instance-query/) method.
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processInstanceIds Filter by process instance ids. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
     * @param processDefinitionId Filter by the process definition the instances run on. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the instances run on. (optional)
     * @param processDefinitionKeyIn Filter by a list of process definition keys. A process instance must have one of the given process definition keys. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
     * @param processDefinitionName Filter by the name of the process definition the instances run on. (optional)
     * @param processDefinitionNameLike Filter by process definition names that the parameter is a substring of. (optional)
     * @param processDefinitionKeyNotIn Exclude instances that belong to a set of process definitions. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
     * @param processInstanceBusinessKey Filter by process instance business key. (optional)
     * @param processInstanceBusinessKeyIn Filter by a list of business keys. A process instance must have one of the given business keys. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param processInstanceBusinessKeyLike Filter by process instance business key that the parameter is a substring of. (optional)
     * @param rootProcessInstances Restrict the query to all process instances that are top level process instances. (optional)
     * @param finished Only include finished process instances. This flag includes all process instances that are completed or terminated. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param unfinished Only include unfinished process instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withIncidents Only include process instances which have an incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withRootIncidents Only include process instances which have a root incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentStatus Only include process instances which have an incident in status either open or resolved. To get all process instances, use the query parameter withIncidents. (optional)
     * @param incidentMessage Filter by the incident message. Exact match. (optional)
     * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
     * @param startedBefore Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedBefore Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedAfter Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedActivityAfter Restrict to instances that executed an activity after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedActivityBefore Restrict to instances that executed an activity before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedJobAfter Restrict to instances that executed an job after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedJobBefore Restrict to instances that executed an job before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedBy Only include process instances that were started by the given user. (optional)
     * @param superProcessInstanceId Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id. (optional)
     * @param subProcessInstanceId Restrict query to one process instance that has a sub process instance with the given id. (optional)
     * @param superCaseInstanceId Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
     * @param subCaseInstanceId Restrict query to one process instance that has a sub case instance with the given id. (optional)
     * @param caseInstanceId Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
     * @param tenantIdIn Filter by a list of tenant ids. A process instance must have one of the given tenant ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param withoutTenantId Only include historic process instances which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param executedActivityIdIn Restrict to instances that executed an activity with one of given ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param activeActivityIdIn Restrict to instances that have an active activity with one of given ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param active Restrict to instances that are active. (optional)
     * @param suspended Restrict to instances that are suspended. (optional)
     * @param completed Restrict to instances that are completed. (optional)
     * @param externallyTerminated Restrict to instances that are externallyTerminated. (optional)
     * @param internallyTerminated Restrict to instances that are internallyTerminated. (optional)
     * @param variables Only include process instances that have/had variables with certain values. Variable filtering expressions are comma-separated and are structured as follows: A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note:** Values are always treated as String objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;.  Key and value may not contain underscore or comma characters.  (optional)
     * @param variableNamesIgnoreCase Match all variable names provided in variables case-insensitively. If set to &#x60;true&#x60; variableName and variablename are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match all variable values provided in variables case-insensitively. If set to &#x60;true&#x60; variableValue and variablevalue are treated as equal. (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> getHistoricProcessInstancesCountWithHttpInfo(String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, Date executedActivityAfter, Date executedActivityBefore, Date executedJobAfter, Date executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase) throws ApiException {
        okhttp3.Call localVarCall = getHistoricProcessInstancesCountValidateBeforeCall(processInstanceId, processInstanceIds, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, processDefinitionKeyNotIn, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, rootProcessInstances, finished, unfinished, withIncidents, withRootIncidents, incidentType, incidentStatus, incidentMessage, incidentMessageLike, startedBefore, startedAfter, finishedBefore, finishedAfter, executedActivityAfter, executedActivityBefore, executedJobAfter, executedJobBefore, startedBy, superProcessInstanceId, subProcessInstanceId, superCaseInstanceId, subCaseInstanceId, caseInstanceId, tenantIdIn, withoutTenantId, executedActivityIdIn, activeActivityIdIn, active, suspended, completed, externallyTerminated, internallyTerminated, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get List Count (asynchronously)
     * Queries for the number of historic process instances that fulfill the given parameters. Takes the same parameters as the [Get Process Instances](https://docs.camunda.org/manual/7.17/reference/rest/history/process-instance/get-process-instance-query/) method.
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processInstanceIds Filter by process instance ids. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
     * @param processDefinitionId Filter by the process definition the instances run on. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the instances run on. (optional)
     * @param processDefinitionKeyIn Filter by a list of process definition keys. A process instance must have one of the given process definition keys. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
     * @param processDefinitionName Filter by the name of the process definition the instances run on. (optional)
     * @param processDefinitionNameLike Filter by process definition names that the parameter is a substring of. (optional)
     * @param processDefinitionKeyNotIn Exclude instances that belong to a set of process definitions. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
     * @param processInstanceBusinessKey Filter by process instance business key. (optional)
     * @param processInstanceBusinessKeyIn Filter by a list of business keys. A process instance must have one of the given business keys. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param processInstanceBusinessKeyLike Filter by process instance business key that the parameter is a substring of. (optional)
     * @param rootProcessInstances Restrict the query to all process instances that are top level process instances. (optional)
     * @param finished Only include finished process instances. This flag includes all process instances that are completed or terminated. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param unfinished Only include unfinished process instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withIncidents Only include process instances which have an incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withRootIncidents Only include process instances which have a root incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentStatus Only include process instances which have an incident in status either open or resolved. To get all process instances, use the query parameter withIncidents. (optional)
     * @param incidentMessage Filter by the incident message. Exact match. (optional)
     * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
     * @param startedBefore Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedBefore Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedAfter Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedActivityAfter Restrict to instances that executed an activity after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedActivityBefore Restrict to instances that executed an activity before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedJobAfter Restrict to instances that executed an job after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param executedJobBefore Restrict to instances that executed an job before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedBy Only include process instances that were started by the given user. (optional)
     * @param superProcessInstanceId Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id. (optional)
     * @param subProcessInstanceId Restrict query to one process instance that has a sub process instance with the given id. (optional)
     * @param superCaseInstanceId Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
     * @param subCaseInstanceId Restrict query to one process instance that has a sub case instance with the given id. (optional)
     * @param caseInstanceId Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
     * @param tenantIdIn Filter by a list of tenant ids. A process instance must have one of the given tenant ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param withoutTenantId Only include historic process instances which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param executedActivityIdIn Restrict to instances that executed an activity with one of given ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param activeActivityIdIn Restrict to instances that have an active activity with one of given ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
     * @param active Restrict to instances that are active. (optional)
     * @param suspended Restrict to instances that are suspended. (optional)
     * @param completed Restrict to instances that are completed. (optional)
     * @param externallyTerminated Restrict to instances that are externallyTerminated. (optional)
     * @param internallyTerminated Restrict to instances that are internallyTerminated. (optional)
     * @param variables Only include process instances that have/had variables with certain values. Variable filtering expressions are comma-separated and are structured as follows: A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note:** Values are always treated as String objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;.  Key and value may not contain underscore or comma characters.  (optional)
     * @param variableNamesIgnoreCase Match all variable names provided in variables case-insensitively. If set to &#x60;true&#x60; variableName and variablename are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match all variable values provided in variables case-insensitively. If set to &#x60;true&#x60; variableValue and variablevalue are treated as equal. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricProcessInstancesCountAsync(String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, Date executedActivityAfter, Date executedActivityBefore, Date executedJobAfter, Date executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricProcessInstancesCountValidateBeforeCall(processInstanceId, processInstanceIds, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, processDefinitionKeyNotIn, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, rootProcessInstances, finished, unfinished, withIncidents, withRootIncidents, incidentType, incidentStatus, incidentMessage, incidentMessageLike, startedBefore, startedAfter, finishedBefore, finishedAfter, executedActivityAfter, executedActivityBefore, executedJobAfter, executedJobBefore, startedBy, superProcessInstanceId, subProcessInstanceId, superCaseInstanceId, subCaseInstanceId, caseInstanceId, tenantIdIn, withoutTenantId, executedActivityIdIn, activeActivityIdIn, active, suspended, completed, externallyTerminated, internallyTerminated, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for queryHistoricProcessInstances
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param historicProcessInstanceQueryDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if a sortOrder parameter is supplied, but no sortBy. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryHistoricProcessInstancesCall(Integer firstResult, Integer maxResults, HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = historicProcessInstanceQueryDto;

        // create path and map variables
        String localVarPath = "/history/process-instance";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryHistoricProcessInstancesValidateBeforeCall(Integer firstResult, Integer maxResults, HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = queryHistoricProcessInstancesCall(firstResult, maxResults, historicProcessInstanceQueryDto, _callback);
        return localVarCall;

    }

    /**
     * Get List (POST)
     * Queries for historic process instances that fulfill the given parameters. This method is slightly more powerful than the [Get Process Instance](https://docs.camunda.org/manual/7.17/reference/rest/history/process-instance/get-process-instance-query/) because it allows filtering by multiple process variables of types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param historicProcessInstanceQueryDto  (optional)
     * @return List&lt;HistoricProcessInstanceDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if a sortOrder parameter is supplied, but no sortBy. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<HistoricProcessInstanceDto> queryHistoricProcessInstances(Integer firstResult, Integer maxResults, HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto) throws ApiException {
        ApiResponse<List<HistoricProcessInstanceDto>> localVarResp = queryHistoricProcessInstancesWithHttpInfo(firstResult, maxResults, historicProcessInstanceQueryDto);
        return localVarResp.getData();
    }

    /**
     * Get List (POST)
     * Queries for historic process instances that fulfill the given parameters. This method is slightly more powerful than the [Get Process Instance](https://docs.camunda.org/manual/7.17/reference/rest/history/process-instance/get-process-instance-query/) because it allows filtering by multiple process variables of types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param historicProcessInstanceQueryDto  (optional)
     * @return ApiResponse&lt;List&lt;HistoricProcessInstanceDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if a sortOrder parameter is supplied, but no sortBy. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<HistoricProcessInstanceDto>> queryHistoricProcessInstancesWithHttpInfo(Integer firstResult, Integer maxResults, HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto) throws ApiException {
        okhttp3.Call localVarCall = queryHistoricProcessInstancesValidateBeforeCall(firstResult, maxResults, historicProcessInstanceQueryDto, null);
        Type localVarReturnType = new TypeToken<List<HistoricProcessInstanceDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get List (POST) (asynchronously)
     * Queries for historic process instances that fulfill the given parameters. This method is slightly more powerful than the [Get Process Instance](https://docs.camunda.org/manual/7.17/reference/rest/history/process-instance/get-process-instance-query/) because it allows filtering by multiple process variables of types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param historicProcessInstanceQueryDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if a sortOrder parameter is supplied, but no sortBy. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryHistoricProcessInstancesAsync(Integer firstResult, Integer maxResults, HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto, final ApiCallback<List<HistoricProcessInstanceDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryHistoricProcessInstancesValidateBeforeCall(firstResult, maxResults, historicProcessInstanceQueryDto, _callback);
        Type localVarReturnType = new TypeToken<List<HistoricProcessInstanceDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for queryHistoricProcessInstancesCount
     * @param historicProcessInstanceQueryDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryHistoricProcessInstancesCountCall(HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = historicProcessInstanceQueryDto;

        // create path and map variables
        String localVarPath = "/history/process-instance/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryHistoricProcessInstancesCountValidateBeforeCall(HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = queryHistoricProcessInstancesCountCall(historicProcessInstanceQueryDto, _callback);
        return localVarCall;

    }

    /**
     * Get List Count (POST)
     * Queries for the number of historic process instances that fulfill the given parameters. This method takes the same message body as the [Get Process Instances (POST)](https://docs.camunda.org/manual/7.17/reference/rest/history/process-instance/get-process-instance-query/) method and therefore it is slightly more powerful than the [Get Process Instance Count](https://docs.camunda.org/manual/7.17/reference/rest/history/process-instance/post-process-instance-query-count/) method.
     * @param historicProcessInstanceQueryDto  (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto queryHistoricProcessInstancesCount(HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = queryHistoricProcessInstancesCountWithHttpInfo(historicProcessInstanceQueryDto);
        return localVarResp.getData();
    }

    /**
     * Get List Count (POST)
     * Queries for the number of historic process instances that fulfill the given parameters. This method takes the same message body as the [Get Process Instances (POST)](https://docs.camunda.org/manual/7.17/reference/rest/history/process-instance/get-process-instance-query/) method and therefore it is slightly more powerful than the [Get Process Instance Count](https://docs.camunda.org/manual/7.17/reference/rest/history/process-instance/post-process-instance-query-count/) method.
     * @param historicProcessInstanceQueryDto  (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> queryHistoricProcessInstancesCountWithHttpInfo(HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto) throws ApiException {
        okhttp3.Call localVarCall = queryHistoricProcessInstancesCountValidateBeforeCall(historicProcessInstanceQueryDto, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get List Count (POST) (asynchronously)
     * Queries for the number of historic process instances that fulfill the given parameters. This method takes the same message body as the [Get Process Instances (POST)](https://docs.camunda.org/manual/7.17/reference/rest/history/process-instance/get-process-instance-query/) method and therefore it is slightly more powerful than the [Get Process Instance Count](https://docs.camunda.org/manual/7.17/reference/rest/history/process-instance/post-process-instance-query-count/) method.
     * @param historicProcessInstanceQueryDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryHistoricProcessInstancesCountAsync(HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryHistoricProcessInstancesCountValidateBeforeCall(historicProcessInstanceQueryDto, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for setRemovalTimeAsync
     * @param setRemovalTimeToHistoricProcessInstancesDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Request was unsuccessfull due to a bad user request. This occurs if some of the query parameters are invalid, e. g. if neither &#x60;historicProcessInstances&#x60; nor &#x60;historicProcessInstanceQuery&#x60; is present or if no mode is specified.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setRemovalTimeAsyncCall(SetRemovalTimeToHistoricProcessInstancesDto setRemovalTimeToHistoricProcessInstancesDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = setRemovalTimeToHistoricProcessInstancesDto;

        // create path and map variables
        String localVarPath = "/history/process-instance/set-removal-time";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call setRemovalTimeAsyncValidateBeforeCall(SetRemovalTimeToHistoricProcessInstancesDto setRemovalTimeToHistoricProcessInstancesDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = setRemovalTimeAsyncCall(setRemovalTimeToHistoricProcessInstancesDto, _callback);
        return localVarCall;

    }

    /**
     * Set Removal Time Async (POST)
     * Sets the removal time to multiple historic process instances asynchronously (batch).  At least &#x60;historicProcessInstanceIds&#x60; or &#x60;historicProcessInstanceQuery&#x60; has to be provided. If both are provided, all instances matching query criterion and instances from the list will be updated with a removal time.
     * @param setRemovalTimeToHistoricProcessInstancesDto  (optional)
     * @return BatchDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Request was unsuccessfull due to a bad user request. This occurs if some of the query parameters are invalid, e. g. if neither &#x60;historicProcessInstances&#x60; nor &#x60;historicProcessInstanceQuery&#x60; is present or if no mode is specified.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public BatchDto setRemovalTimeAsync(SetRemovalTimeToHistoricProcessInstancesDto setRemovalTimeToHistoricProcessInstancesDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = setRemovalTimeAsyncWithHttpInfo(setRemovalTimeToHistoricProcessInstancesDto);
        return localVarResp.getData();
    }

    /**
     * Set Removal Time Async (POST)
     * Sets the removal time to multiple historic process instances asynchronously (batch).  At least &#x60;historicProcessInstanceIds&#x60; or &#x60;historicProcessInstanceQuery&#x60; has to be provided. If both are provided, all instances matching query criterion and instances from the list will be updated with a removal time.
     * @param setRemovalTimeToHistoricProcessInstancesDto  (optional)
     * @return ApiResponse&lt;BatchDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Request was unsuccessfull due to a bad user request. This occurs if some of the query parameters are invalid, e. g. if neither &#x60;historicProcessInstances&#x60; nor &#x60;historicProcessInstanceQuery&#x60; is present or if no mode is specified.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BatchDto> setRemovalTimeAsyncWithHttpInfo(SetRemovalTimeToHistoricProcessInstancesDto setRemovalTimeToHistoricProcessInstancesDto) throws ApiException {
        okhttp3.Call localVarCall = setRemovalTimeAsyncValidateBeforeCall(setRemovalTimeToHistoricProcessInstancesDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Set Removal Time Async (POST) (asynchronously)
     * Sets the removal time to multiple historic process instances asynchronously (batch).  At least &#x60;historicProcessInstanceIds&#x60; or &#x60;historicProcessInstanceQuery&#x60; has to be provided. If both are provided, all instances matching query criterion and instances from the list will be updated with a removal time.
     * @param setRemovalTimeToHistoricProcessInstancesDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Request was unsuccessfull due to a bad user request. This occurs if some of the query parameters are invalid, e. g. if neither &#x60;historicProcessInstances&#x60; nor &#x60;historicProcessInstanceQuery&#x60; is present or if no mode is specified.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setRemovalTimeAsyncAsync(SetRemovalTimeToHistoricProcessInstancesDto setRemovalTimeToHistoricProcessInstancesDto, final ApiCallback<BatchDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = setRemovalTimeAsyncValidateBeforeCall(setRemovalTimeToHistoricProcessInstancesDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
