/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.webapp.impl.security.filter.headersec.provider.impl;

import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.servlet.ServletContext;
import org.camunda.bpm.webapp.impl.security.filter.headersec.provider.HeaderSecurityProvider;

public class ContentSecurityPolicyProvider
extends HeaderSecurityProvider {
    public static final String HEADER_NAME = "Content-Security-Policy";
    public static final String HEADER_NONCE_PLACEHOLDER = "$NONCE";
    public static final String HEADER_DEFAULT_VALUE = "base-uri 'self';script-src $NONCE 'strict-dynamic' 'unsafe-eval' https: 'self' 'unsafe-inline';style-src 'unsafe-inline' 'self';default-src 'self';img-src 'self' data:;block-all-mixed-content;form-action 'self';frame-ancestors 'none';object-src 'none';sandbox allow-forms allow-scripts allow-same-origin allow-popups allow-downloads";
    public static final String DISABLED_PARAM = "contentSecurityPolicyDisabled";
    public static final String VALUE_PARAM = "contentSecurityPolicyValue";
    public static final String ATTR_CSP_FILTER_NONCE = "org.camunda.bpm.csp.nonce";
    public static final Base64.Encoder ENCODER = Base64.getUrlEncoder().withoutPadding();

    @Override
    public Map<String, String> initParams() {
        this.initParams.put(VALUE_PARAM, null);
        this.initParams.put(DISABLED_PARAM, null);
        return this.initParams;
    }

    @Override
    public void parseParams() {
        String disabled = (String)this.initParams.get(DISABLED_PARAM);
        if (this.isEmpty(disabled)) {
            this.setDisabled(false);
        } else {
            this.setDisabled(Boolean.valueOf(disabled));
        }
        String value = (String)this.initParams.get(VALUE_PARAM);
        if (!this.isEmpty(value)) {
            value = this.normalizeString(value);
            this.setValue(value);
        } else {
            this.setValue(HEADER_DEFAULT_VALUE);
        }
    }

    protected String normalizeString(String value) {
        return value.trim().replaceAll("\\s+", " ");
    }

    @Override
    public String getHeaderName() {
        return HEADER_NAME;
    }

    @Override
    public String getHeaderValue(ServletContext servletContext) {
        String nonce = this.generateNonce();
        servletContext.setAttribute(ATTR_CSP_FILTER_NONCE, (Object)nonce);
        return this.value.replaceAll("\\$NONCE", String.format("'nonce-%s'", nonce));
    }

    protected String generateNonce() {
        byte[] bytes = new byte[20];
        ThreadLocalRandom.current().nextBytes(bytes);
        return ENCODER.encodeToString(bytes);
    }
}

