/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.webapp.impl.security.filter.headersec.provider.impl;

import java.util.Map;
import org.camunda.bpm.webapp.impl.security.filter.headersec.provider.HeaderSecurityProvider;

public class ContentSecurityPolicyProvider
extends HeaderSecurityProvider {
    public static final String HEADER_NAME = "Content-Security-Policy";
    public static final String HEADER_DEFAULT_VALUE = "base-uri 'self'";
    public static final String DISABLED_PARAM = "contentSecurityPolicyDisabled";
    public static final String VALUE_PARAM = "contentSecurityPolicyValue";

    @Override
    public Map<String, String> initParams() {
        this.initParams.put(VALUE_PARAM, null);
        this.initParams.put(DISABLED_PARAM, null);
        return this.initParams;
    }

    @Override
    public void parseParams() {
        String disabled = (String)this.initParams.get(DISABLED_PARAM);
        if (this.isEmpty(disabled)) {
            this.setDisabled(false);
        } else {
            this.setDisabled(Boolean.valueOf(disabled));
        }
        String value = (String)this.initParams.get(VALUE_PARAM);
        if (!this.isEmpty(value)) {
            value = this.normalizeString(value);
            this.setValue(value);
        } else {
            this.setValue(HEADER_DEFAULT_VALUE);
        }
    }

    protected String normalizeString(String value) {
        return value.trim().replaceAll("\\s+", " ");
    }

    @Override
    public String getHeaderName() {
        return HEADER_NAME;
    }
}

