/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.admin.impl.plugin.resources;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.camunda.bpm.admin.Admin;
import org.camunda.bpm.admin.resource.AbstractAdminPluginResource;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;
import org.camunda.bpm.engine.rest.dto.metrics.MetricsResultDto;

@Produces(value={"application/json"})
public class MetricsRestService
extends AbstractAdminPluginResource {
    public static final String PATH = "/metrics";
    public static final String QUERY_PARAM_START_DATE = "startDate";
    public static final String QUERY_PARAM_END_DATE = "endDate";
    protected ObjectMapper objectMapper;

    public MetricsRestService(String engineName) {
        super(engineName);
    }

    @GET
    @Path(value="/task-worker/sum")
    @Produces(value={"application/json"})
    public MetricsResultDto countUniqueTaskWorkers(@QueryParam(value="startDate") String startDateAsString, @QueryParam(value="endDate") String endDateAsString) {
        ProcessEngine processEngine = Admin.getRuntimeDelegate().getProcessEngine(this.engineName);
        ProcessEngineConfigurationImpl engineConfig = (ProcessEngineConfigurationImpl)processEngine.getProcessEngineConfiguration();
        return (MetricsResultDto)engineConfig.getCommandExecutorTxRequired().execute(commandContext -> {
            DateConverter dateConverter = new DateConverter();
            dateConverter.setObjectMapper(this.objectMapper);
            Date startDate = this.convertToDate(dateConverter, startDateAsString);
            Date endDate = this.convertToDate(dateConverter, endDateAsString);
            MetricsResultDto result = new MetricsResultDto();
            long count = commandContext.getHistoricTaskInstanceManager().findUniqueTaskWorkerCount(startDate, endDate);
            result.setResult((Number)count);
            return result;
        });
    }

    protected Date convertToDate(DateConverter dateConverter, String dateAsString) {
        return dateConverter.convertQueryParameterToType(dateAsString);
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

