/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cockpit.impl.db;

import java.util.List;
import org.camunda.bpm.cockpit.db.CommandExecutor;
import org.camunda.bpm.cockpit.db.QueryParameters;
import org.camunda.bpm.cockpit.db.QueryService;
import org.camunda.bpm.cockpit.impl.db.QuerySessionFactory;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.QueryMaxResultsLimitUtil;

public class QueryServiceImpl
implements QueryService {
    private CommandExecutor commandExecutor;

    public QueryServiceImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public <T> List<T> executeQuery(final String statement, final QueryParameters<T> parameter) {
        List queryResult = (List)this.commandExecutor.executeCommand(new Command<List<T>>(){

            public List<T> execute(CommandContext commandContext) {
                commandContext.getAuthorizationManager().enableQueryAuthCheck(parameter.getAuthCheck());
                if (parameter.isMaxResultsLimitEnabled()) {
                    QueryMaxResultsLimitUtil.checkMaxResultsLimit((int)parameter.getMaxResults(), (ProcessEngineConfigurationImpl)QueryServiceImpl.this.getProcessEngineConfiguration(commandContext));
                }
                return commandContext.getDbSqlSession().selectList(statement, (Object)parameter);
            }
        });
        return queryResult;
    }

    @Override
    public <T> T executeQuery(final String statement, final Object parameter, Class<T> clazz) {
        Object queryResult = this.commandExecutor.executeCommand(new Command<T>(){

            public T execute(CommandContext commandContext) {
                return commandContext.getDbSqlSession().selectOne(statement, parameter);
            }
        });
        return queryResult;
    }

    @Override
    public Long executeQueryRowCount(final String statement, final ListQueryParameterObject parameter) {
        Long queryResult = this.commandExecutor.executeCommand(new Command<Long>(){

            public Long execute(CommandContext commandContext) {
                commandContext.getAuthorizationManager().enableQueryAuthCheck(parameter.getAuthCheck());
                return (Long)commandContext.getDbSqlSession().selectOne(statement, (Object)parameter);
            }
        });
        return queryResult;
    }

    protected ProcessEngineConfigurationImpl getProcessEngineConfiguration(CommandContext commandContext) {
        QuerySessionFactory querySessionFactory = (QuerySessionFactory)commandContext.getProcessEngineConfiguration();
        ProcessEngineConfigurationImpl processEngineConfiguration = null;
        if (querySessionFactory != null) {
            processEngineConfiguration = querySessionFactory.getWrappedConfiguration();
        }
        if (processEngineConfiguration == null) {
            throw new ProcessEngineException("Process Engine Configuration missing!");
        }
        return processEngineConfiguration;
    }
}

