/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.spin;

import java.util.ArrayList;
import java.util.Optional;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.util.ClassLoaderUtil;
import org.camunda.bpm.spring.boot.starter.spin.CamundaJacksonFormatConfiguratorJSR310;
import org.camunda.bpm.spring.boot.starter.spin.CamundaJacksonFormatConfiguratorJdk8;
import org.camunda.bpm.spring.boot.starter.spin.CamundaJacksonFormatConfiguratorParameterNames;
import org.camunda.spin.DataFormats;
import org.camunda.spin.plugin.impl.SpinProcessEnginePlugin;
import org.camunda.spin.spi.DataFormatConfigurator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.support.SpringFactoriesLoader;

public class SpringBootSpinProcessEnginePlugin
extends SpinProcessEnginePlugin {
    @Autowired
    protected Optional<CamundaJacksonFormatConfiguratorJSR310> dataFormatConfiguratorJsr310;
    @Autowired
    protected Optional<CamundaJacksonFormatConfiguratorParameterNames> dataFormatConfiguratorParameterNames;
    @Autowired
    protected Optional<CamundaJacksonFormatConfiguratorJdk8> dataFormatConfiguratorJdk8;

    public void preInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
        ClassLoader classloader = ClassLoaderUtil.getClassloader(SpringBootSpinProcessEnginePlugin.class);
        this.loadSpringBootDataFormats(classloader);
    }

    protected void loadSpringBootDataFormats(ClassLoader classloader) {
        ArrayList configurators = new ArrayList();
        this.dataFormatConfiguratorJsr310.ifPresent(configurator -> configurators.add(configurator));
        this.dataFormatConfiguratorParameterNames.ifPresent(configurator -> configurators.add(configurator));
        this.dataFormatConfiguratorJdk8.ifPresent(configurator -> configurators.add(configurator));
        configurators.addAll(SpringFactoriesLoader.loadFactories(DataFormatConfigurator.class, (ClassLoader)classloader));
        DataFormats.loadDataFormats((ClassLoader)classloader, configurators);
    }
}

