/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter;

import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.spring.ProcessEngineFactoryBean;
import org.camunda.bpm.engine.spring.SpringProcessEngineServicesConfiguration;
import org.camunda.bpm.spring.boot.starter.CamundaBpmActuatorConfiguration;
import org.camunda.bpm.spring.boot.starter.CamundaBpmConfiguration;
import org.camunda.bpm.spring.boot.starter.CamundaBpmPluginConfiguration;
import org.camunda.bpm.spring.boot.starter.event.ProcessApplicationEventPublisher;
import org.camunda.bpm.spring.boot.starter.property.CamundaBpmProperties;
import org.camunda.bpm.spring.boot.starter.property.ManagementProperties;
import org.camunda.bpm.spring.boot.starter.util.CamundaBpmVersion;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

@EnableConfigurationProperties(value={CamundaBpmProperties.class, ManagementProperties.class})
@Import(value={CamundaBpmConfiguration.class, CamundaBpmActuatorConfiguration.class, CamundaBpmPluginConfiguration.class, SpringProcessEngineServicesConfiguration.class})
@Configuration
@ConditionalOnProperty(prefix="camunda.bpm", name={"enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={HibernateJpaAutoConfiguration.class})
public class CamundaBpmAutoConfiguration {
    @Bean
    public CamundaBpmVersion camundaBpmVersion() {
        return new CamundaBpmVersion();
    }

    @Bean
    public ProcessApplicationEventPublisher processApplicationEventPublisher(ApplicationEventPublisher publisher) {
        return new ProcessApplicationEventPublisher(publisher);
    }

    @Configuration
    class ProcessEngineConfigurationImplDependingConfiguration {
        @Autowired
        protected ProcessEngineConfigurationImpl processEngineConfigurationImpl;

        ProcessEngineConfigurationImplDependingConfiguration() {
        }

        @Bean
        public ProcessEngineFactoryBean processEngineFactoryBean() {
            ProcessEngineFactoryBean factoryBean = new ProcessEngineFactoryBean();
            factoryBean.setProcessEngineConfiguration(this.processEngineConfigurationImpl);
            return factoryBean;
        }

        @Bean
        @Primary
        public CommandExecutor commandExecutorTxRequired() {
            return this.processEngineConfigurationImpl.getCommandExecutorTxRequired();
        }

        @Bean
        public CommandExecutor commandExecutorTxRequiresNew() {
            return this.processEngineConfigurationImpl.getCommandExecutorTxRequiresNew();
        }

        @Bean
        public CommandExecutor commandExecutorSchemaOperations() {
            return this.processEngineConfigurationImpl.getCommandExecutorSchemaOperations();
        }
    }
}

