/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.process_test_coverage.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;

public class ClassLocationURL {
    static File fileFor(Class aclass) {
        URL location = ClassLocationURL.locationFor(aclass);
        if (location == null) {
            throw new IllegalStateException("Could not locate " + aclass.getCanonicalName());
        }
        try {
            return new File(location.toURI());
        }
        catch (URISyntaxException ex) {
            return new File(location.getPath());
        }
    }

    static URL locationFor(Class aclass) {
        URL location = ClassLocationURL.urlFromCodeSource(aclass);
        return location != null ? location : ClassLocationURL.urlFromResource(aclass);
    }

    static URL urlFromCodeSource(Class aclass) {
        try {
            CodeSource codeSource = aclass.getProtectionDomain().getCodeSource();
            URL url = codeSource != null ? codeSource.getLocation() : null;
            return url;
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    static URL urlFromResource(Class aclass) {
        URL url = aclass.getResource(aclass.getSimpleName() + ".class");
        String suffix = aclass.getName().replace(".", "/") + ".class";
        try {
            String u = url.toExternalForm();
            return new URL(u.startsWith("jar:") ? u.replaceFirst("jar:", "").replace("!/" + suffix, "") : u.replace(suffix, ""));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

