/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.process_test_coverage.junit5;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParseListener;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.event.EventHandler;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.extension.junit5.test.ProcessEngineExtension;
import org.camunda.bpm.extension.process_test_coverage.engine.CompensationEventCoverageHandler;
import org.camunda.bpm.extension.process_test_coverage.engine.ElementCoverageParseListener;
import org.camunda.bpm.extension.process_test_coverage.engine.ExecutionContextModelProvider;
import org.camunda.bpm.extension.process_test_coverage.engine.ModelProvider;
import org.camunda.bpm.extension.process_test_coverage.junit5.ProcessEngineCoverageExtensionKt;
import org.camunda.bpm.extension.process_test_coverage.model.Collector;
import org.camunda.bpm.extension.process_test_coverage.model.DefaultCollector;
import org.camunda.bpm.extension.process_test_coverage.model.Run;
import org.camunda.bpm.extension.process_test_coverage.model.Suite;
import org.camunda.bpm.extension.process_test_coverage.util.CoverageReportUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 /2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002./B)\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u001c\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J$\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u000e2\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\bH\u0002J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u0006\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010#\u001a\u00020\u001aH\u0002J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010%\u001a\u00020\u0005H\u0002J\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*H\u0002J\u001a\u0010+\u001a\u00020\u001a2\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0012\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/camunda/bpm/extension/process_test_coverage/junit5/ProcessEngineCoverageExtension;", "Lorg/camunda/bpm/extension/junit5/test/ProcessEngineExtension;", "Lorg/junit/jupiter/api/extension/BeforeAllCallback;", "Lorg/junit/jupiter/api/extension/AfterAllCallback;", "detailedCoverageLogging", "", "handleTestMethodCoverage", "excludedProcessDefinitionKeys", "", "", "(ZZLjava/util/List;)V", "classCoverageAssertionConditions", "", "Lorg/assertj/core/api/Condition;", "", "coverageCollector", "Lorg/camunda/bpm/extension/process_test_coverage/model/DefaultCollector;", "suiteInitialized", "testMethodNameToCoverageConditions", "", "addClassCoverageAtLeast", "percentage", "addTestMethodCoverageCondition", "methodName", "condition", "afterAll", "", "context", "Lorg/junit/jupiter/api/extension/ExtensionContext;", "afterTestExecution", "assertCoverage", "coverage", "conditions", "beforeAll", "beforeTestExecution", "initializeListeners", "initializeSuite", "isRelevantTestMethod", "logCoverageDetail", "run", "Lorg/camunda/bpm/extension/process_test_coverage/model/Run;", "suite", "Lorg/camunda/bpm/extension/process_test_coverage/model/Suite;", "postProcessTestInstance", "testInstance", "", "Builder", "Companion", "camunda-bpm-process-test-coverage-junit5"})
public final class ProcessEngineCoverageExtension
extends ProcessEngineExtension
implements BeforeAllCallback,
AfterAllCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean detailedCoverageLogging;
    private final boolean handleTestMethodCoverage;
    @NotNull
    private final List<String> excludedProcessDefinitionKeys;
    @NotNull
    private final DefaultCollector coverageCollector;
    @NotNull
    private final List<Condition<Double>> classCoverageAssertionConditions;
    @NotNull
    private final Map<String, List<Condition<Double>>> testMethodNameToCoverageConditions;
    private boolean suiteInitialized;

    public ProcessEngineCoverageExtension(boolean detailedCoverageLogging, boolean handleTestMethodCoverage, @NotNull List<String> excludedProcessDefinitionKeys) {
        Intrinsics.checkNotNullParameter(excludedProcessDefinitionKeys, (String)"excludedProcessDefinitionKeys");
        this.detailedCoverageLogging = detailedCoverageLogging;
        this.handleTestMethodCoverage = handleTestMethodCoverage;
        this.excludedProcessDefinitionKeys = excludedProcessDefinitionKeys;
        this.coverageCollector = new DefaultCollector((ModelProvider)new ExecutionContextModelProvider());
        this.classCoverageAssertionConditions = new ArrayList();
        this.testMethodNameToCoverageConditions = new LinkedHashMap();
    }

    public /* synthetic */ ProcessEngineCoverageExtension(boolean bl, boolean bl2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(bl, bl2, list);
    }

    public void postProcessTestInstance(@Nullable Object testInstance, @NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.postProcessTestInstance(testInstance, context);
        this.initializeListeners();
    }

    public void beforeTestExecution(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.beforeTestExecution(context);
        if (this.isRelevantTestMethod()) {
            if (!this.suiteInitialized) {
                this.initializeSuite(context);
            }
            String string = context.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.uniqueId");
            String runId = string;
            string = context.getRequiredTestMethod().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.requiredTestMethod.name");
            this.coverageCollector.createRun(new Run(runId, string), this.coverageCollector.getActiveSuite().getId());
            this.coverageCollector.activateRun(runId);
        }
    }

    public void afterTestExecution(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.handleTestMethodCoverage && this.isRelevantTestMethod()) {
            this.handleTestMethodCoverage(context);
        }
        super.afterTestExecution(context);
    }

    public void beforeAll(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.suiteInitialized) {
            this.initializeSuite(context);
        }
    }

    private final void initializeSuite(ExtensionContext context) {
        String string = context.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.uniqueId");
        String suiteId = string;
        string = context.getRequiredTestClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.requiredTestClass.name");
        this.coverageCollector.createSuite(new Suite(suiteId, string));
        this.coverageCollector.setExcludedProcessDefinitionKeys(this.excludedProcessDefinitionKeys);
        this.coverageCollector.activateSuite(suiteId);
        this.suiteInitialized = true;
    }

    public void afterAll(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Suite suite = this.coverageCollector.getActiveSuite();
        if (Intrinsics.areEqual((Object)context.getUniqueId(), (Object)suite.getId())) {
            double suiteCoveragePercentage = suite.calculateCoverage(this.coverageCollector.getModels());
            Companion.getLogger().info(suite.getName() + " test class coverage is: " + suiteCoveragePercentage);
            this.logCoverageDetail(suite);
            this.assertCoverage(suiteCoveragePercentage, this.classCoverageAssertionConditions);
            CoverageReportUtil.createReport((DefaultCollector)this.coverageCollector);
            CoverageReportUtil.createJsonReport((DefaultCollector)this.coverageCollector);
        }
    }

    private final void initializeListeners() {
        ProcessEngineConfigurationImpl processEngineConfiguration = this.processEngineConfiguration;
        List bpmnParseListeners = processEngineConfiguration.getCustomPostBPMNParseListeners();
        for (BpmnParseListener parseListener : bpmnParseListeners) {
            if (!(parseListener instanceof ElementCoverageParseListener)) continue;
            ((ElementCoverageParseListener)parseListener).setCoverageState((Collector)this.coverageCollector);
        }
        EventHandler compensationEventHandler = processEngineConfiguration.getEventHandler("compensate");
        if (compensationEventHandler instanceof CompensationEventCoverageHandler) {
            ((CompensationEventCoverageHandler)compensationEventHandler).setCoverageState((Collector)this.coverageCollector);
        } else {
            Companion.getLogger().warn("CompensationEventCoverageHandler not registered with process engine configuration! Compensation boundary events coverage will not be registered.");
        }
    }

    private final void handleTestMethodCoverage(ExtensionContext context) {
        Suite suite = this.coverageCollector.getActiveSuite();
        String string = context.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.uniqueId");
        Run run = suite.getRun(string);
        if (run == null) {
            return;
        }
        Run run2 = run;
        double coveragePercentage = run2.calculateCoverage(this.coverageCollector.getModels());
        Companion.getLogger().info(run2.getName() + " test method coverage is " + coveragePercentage);
        this.logCoverageDetail(run2);
        List<Condition<Double>> list = this.testMethodNameToCoverageConditions.get(run2.getName());
        if (list != null) {
            List<Condition<Double>> it = list;
            boolean bl = false;
            this.assertCoverage(coveragePercentage, it);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRelevantTestMethod() {
        boolean bl;
        if (this.deploymentId == null) return false;
        List list = this.processEngine.getRepositoryService().createProcessDefinitionQuery().deploymentId(this.deploymentId).list();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"processEngine.repository\u2026)\n                .list()");
        Iterable $this$any$iv = list;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            ProcessDefinition it = (ProcessDefinition)element$iv;
            boolean bl2 = false;
            if (!this.excludedProcessDefinitionKeys.contains(it.getKey())) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final void logCoverageDetail(Suite suite) {
        if (Companion.getLogger().isDebugEnabled() && this.detailedCoverageLogging) {
            Companion.getLogger().debug(suite.toString());
        }
    }

    private final void logCoverageDetail(Run run) {
        if (Companion.getLogger().isDebugEnabled() && this.detailedCoverageLogging) {
            Companion.getLogger().debug(run.toString());
        }
    }

    private final void assertCoverage(double coverage, List<? extends Condition<Double>> conditions) {
        Iterable $this$forEach$iv = conditions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Condition it = (Condition)element$iv;
            boolean bl = false;
            Assertions.assertThat((double)coverage).satisfies(it);
        }
    }

    public final boolean addTestMethodCoverageCondition(@NotNull String methodName, @NotNull Condition<Double> condition) {
        List list;
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Map<String, List<Condition<Double>>> $this$getOrPut$iv = this.testMethodNameToCoverageConditions;
        boolean $i$f$getOrPut = false;
        List value$iv = $this$getOrPut$iv.get(methodName);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(methodName, answer$iv);
            list = answer$iv;
        } else {
            list = value$iv;
        }
        return list.add(condition);
    }

    private final boolean addClassCoverageAtLeast(double percentage) {
        return this.classCoverageAssertionConditions.add((Condition<Double>)new Condition(arg_0 -> ProcessEngineCoverageExtension.addClassCoverageAtLeast$lambda-4(percentage, arg_0), Intrinsics.stringPlus((String)"matches if the coverage ratio is at least ", (Object)percentage), new Object[0]));
    }

    private static final boolean addClassCoverageAtLeast$lambda-4(double $percentage, Double p) {
        Intrinsics.checkNotNullExpressionValue((Object)p, (String)"p");
        return p >= $percentage;
    }

    public ProcessEngineCoverageExtension() {
        this(false, false, null, 7, null);
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    @JvmStatic
    @NotNull
    public static final Builder builder(@NotNull String configurationResource2) {
        return Companion.builder(configurationResource2);
    }

    @JvmStatic
    @NotNull
    public static final Builder builder(@NotNull ProcessEngineConfiguration processEngineConfiguration) {
        return Companion.builder(processEngineConfiguration);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lorg/camunda/bpm/extension/process_test_coverage/junit5/ProcessEngineCoverageExtension$Companion;", "Lmu/KLogging;", "()V", "builder", "Lorg/camunda/bpm/extension/process_test_coverage/junit5/ProcessEngineCoverageExtension$Builder;", "configurationResource", "", "processEngineConfiguration", "Lorg/camunda/bpm/engine/ProcessEngineConfiguration;", "camunda-bpm-process-test-coverage-junit5"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder(null, null, false, false, null, null, null, 127, null);
        }

        @JvmStatic
        @NotNull
        public final Builder builder(@NotNull String configurationResource2) {
            Intrinsics.checkNotNullParameter((Object)configurationResource2, (String)"configurationResource");
            return new Builder(configurationResource2, null, false, false, null, null, null, 126, null);
        }

        @JvmStatic
        @NotNull
        public final Builder builder(@NotNull ProcessEngineConfiguration processEngineConfiguration) {
            Intrinsics.checkNotNullParameter((Object)processEngineConfiguration, (String)"processEngineConfiguration");
            return new Builder(null, processEngineConfiguration, false, false, null, null, null, 125, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 A2\u00020\u0001:\u0001ABW\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\nJ\u0006\u0010(\u001a\u00020)J\u000b\u0010*\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010+\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010,\u001a\u00020\u0007H\u00c6\u0003J\t\u0010-\u001a\u00020\u0007H\u00c6\u0003J\u0010\u0010.\u001a\u0004\u0018\u00010\nH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0014J\u000f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u00c6\u0003J\t\u00100\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003H\u0007J`\u00101\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\b\b\u0002\u0010\r\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u00102J\u0017\u00103\u001a\u0004\u0018\u00010\n2\u0006\u00104\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u00105J\u0013\u00106\u001a\u00020\u00072\b\u00107\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u001f\u00108\u001a\u00020\u00002\u0012\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030:\"\u00020\u0003\u00a2\u0006\u0002\u0010;J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0007J\t\u0010<\u001a\u00020=H\u00d6\u0001J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u0003J\t\u0010?\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010@\u001a\u00020\u0000R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0017\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0019\"\u0004\b!\u0010\u001bR\u001a\u0010\r\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0010\"\u0004\b#\u0010\u0012R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006B"}, d2={"Lorg/camunda/bpm/extension/process_test_coverage/junit5/ProcessEngineCoverageExtension$Builder;", "", "configurationResource", "", "processEngineConfiguration", "Lorg/camunda/bpm/engine/ProcessEngineConfiguration;", "detailedCoverageLogging", "", "handleTestMethodCoverage", "coverageAtLeast", "", "excludedProcessDefinitionKeys", "", "optionalAssertCoverageAtLeastProperty", "(Ljava/lang/String;Lorg/camunda/bpm/engine/ProcessEngineConfiguration;ZZLjava/lang/Double;Ljava/util/List;Ljava/lang/String;)V", "getConfigurationResource", "()Ljava/lang/String;", "setConfigurationResource", "(Ljava/lang/String;)V", "getCoverageAtLeast", "()Ljava/lang/Double;", "setCoverageAtLeast", "(Ljava/lang/Double;)V", "Ljava/lang/Double;", "getDetailedCoverageLogging", "()Z", "setDetailedCoverageLogging", "(Z)V", "getExcludedProcessDefinitionKeys", "()Ljava/util/List;", "setExcludedProcessDefinitionKeys", "(Ljava/util/List;)V", "getHandleTestMethodCoverage", "setHandleTestMethodCoverage", "getOptionalAssertCoverageAtLeastProperty", "setOptionalAssertCoverageAtLeastProperty", "getProcessEngineConfiguration", "()Lorg/camunda/bpm/engine/ProcessEngineConfiguration;", "assertClassCoverageAtLeast", "percentage", "build", "Lorg/camunda/bpm/extension/process_test_coverage/junit5/ProcessEngineCoverageExtension;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(Ljava/lang/String;Lorg/camunda/bpm/engine/ProcessEngineConfiguration;ZZLjava/lang/Double;Ljava/util/List;Ljava/lang/String;)Lorg/camunda/bpm/extension/process_test_coverage/junit5/ProcessEngineCoverageExtension$Builder;", "coverageFromSystemProperty", "key", "(Ljava/lang/String;)Ljava/lang/Double;", "equals", "other", "excludeProcessDefinitionKeys", "processDefinitionKeys", "", "([Ljava/lang/String;)Lorg/camunda/bpm/extension/process_test_coverage/junit5/ProcessEngineCoverageExtension$Builder;", "hashCode", "", "property", "toString", "withDetailedCoverageLogging", "Companion", "camunda-bpm-process-test-coverage-junit5"})
    public static final class Builder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private String configurationResource;
        @Nullable
        private final ProcessEngineConfiguration processEngineConfiguration;
        private boolean detailedCoverageLogging;
        private boolean handleTestMethodCoverage;
        @Nullable
        private Double coverageAtLeast;
        @NotNull
        private List<String> excludedProcessDefinitionKeys;
        @NotNull
        private String optionalAssertCoverageAtLeastProperty;
        @NotNull
        public static final String DEFAULT_ASSERT_AT_LEAST_PROPERTY = "org.camunda.bpm.extension.process_test_coverage.ASSERT_AT_LEAST";

        public Builder(@Nullable String configurationResource2, @Nullable ProcessEngineConfiguration processEngineConfiguration, boolean detailedCoverageLogging, boolean handleTestMethodCoverage, @Nullable Double coverageAtLeast, @NotNull List<String> excludedProcessDefinitionKeys, @NotNull String optionalAssertCoverageAtLeastProperty) {
            Intrinsics.checkNotNullParameter(excludedProcessDefinitionKeys, (String)"excludedProcessDefinitionKeys");
            Intrinsics.checkNotNullParameter((Object)optionalAssertCoverageAtLeastProperty, (String)"optionalAssertCoverageAtLeastProperty");
            this.configurationResource = configurationResource2;
            this.processEngineConfiguration = processEngineConfiguration;
            this.detailedCoverageLogging = detailedCoverageLogging;
            this.handleTestMethodCoverage = handleTestMethodCoverage;
            this.coverageAtLeast = coverageAtLeast;
            this.excludedProcessDefinitionKeys = excludedProcessDefinitionKeys;
            this.optionalAssertCoverageAtLeastProperty = optionalAssertCoverageAtLeastProperty;
        }

        public /* synthetic */ Builder(String string, ProcessEngineConfiguration processEngineConfiguration, boolean bl, boolean bl2, Double d, List list, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                processEngineConfiguration = null;
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                bl2 = true;
            }
            if ((n & 0x10) != 0) {
                d = null;
            }
            if ((n & 0x20) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n & 0x40) != 0) {
                string2 = DEFAULT_ASSERT_AT_LEAST_PROPERTY;
            }
            this(string, processEngineConfiguration, bl, bl2, d, list, string2);
        }

        @Nullable
        public final String getConfigurationResource() {
            return this.configurationResource;
        }

        public final void setConfigurationResource(@Nullable String string) {
            this.configurationResource = string;
        }

        @Nullable
        public final ProcessEngineConfiguration getProcessEngineConfiguration() {
            return this.processEngineConfiguration;
        }

        public final boolean getDetailedCoverageLogging() {
            return this.detailedCoverageLogging;
        }

        public final void setDetailedCoverageLogging(boolean bl) {
            this.detailedCoverageLogging = bl;
        }

        public final boolean getHandleTestMethodCoverage() {
            return this.handleTestMethodCoverage;
        }

        public final void setHandleTestMethodCoverage(boolean bl) {
            this.handleTestMethodCoverage = bl;
        }

        @Nullable
        public final Double getCoverageAtLeast() {
            return this.coverageAtLeast;
        }

        public final void setCoverageAtLeast(@Nullable Double d) {
            this.coverageAtLeast = d;
        }

        @NotNull
        public final List<String> getExcludedProcessDefinitionKeys() {
            return this.excludedProcessDefinitionKeys;
        }

        public final void setExcludedProcessDefinitionKeys(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.excludedProcessDefinitionKeys = list;
        }

        @NotNull
        public final String getOptionalAssertCoverageAtLeastProperty() {
            return this.optionalAssertCoverageAtLeastProperty;
        }

        public final void setOptionalAssertCoverageAtLeastProperty(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.optionalAssertCoverageAtLeastProperty = string;
        }

        @Deprecated(message="Pass the configuration resource directly when creating the builder", replaceWith=@ReplaceWith(expression="ProcessEngineCoverageExtension.builder(configurationResource)", imports={"org.camunda.bpm.extension.process_test_coverage.junit5.ProcessEngineCoverageExtension"}))
        @NotNull
        public final Builder configurationResource(@NotNull String configurationResource2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)configurationResource2, (String)"configurationResource");
            if (this.configurationResource != null) {
                Companion.getLogger().warn((Function0)new Function0<Object>(this, configurationResource2){
                    final /* synthetic */ Builder this$0;
                    final /* synthetic */ String $configurationResource;
                    {
                        this.this$0 = $receiver;
                        this.$configurationResource = $configurationResource;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "configuration resource " + this.this$0.getConfigurationResource() + " already configured, ignoring " + this.$configurationResource;
                    }
                });
                builder = this;
            } else if (this.processEngineConfiguration != null) {
                Companion.getLogger().warn((Function0)new Function0<Object>(this, configurationResource2){
                    final /* synthetic */ Builder this$0;
                    final /* synthetic */ String $configurationResource;
                    {
                        this.this$0 = $receiver;
                        this.$configurationResource = $configurationResource;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "process engine configuration " + this.this$0.getProcessEngineConfiguration() + " already configured, ignoring " + this.$configurationResource;
                    }
                });
                builder = this;
            } else {
                Builder builder2;
                Builder $this$configurationResource_u24lambda_u2d0 = builder2 = this;
                boolean bl = false;
                $this$configurationResource_u24lambda_u2d0.setConfigurationResource(configurationResource2);
                builder = builder2;
            }
            return builder;
        }

        @NotNull
        public final Builder withDetailedCoverageLogging() {
            Builder builder;
            Builder $this$withDetailedCoverageLogging_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            $this$withDetailedCoverageLogging_u24lambda_u2d1.setDetailedCoverageLogging(true);
            return builder;
        }

        @NotNull
        public final Builder handleTestMethodCoverage(boolean handleTestMethodCoverage) {
            Builder builder;
            Builder $this$handleTestMethodCoverage_u24lambda_u2d2 = builder = this;
            boolean bl = false;
            $this$handleTestMethodCoverage_u24lambda_u2d2.setHandleTestMethodCoverage(handleTestMethodCoverage);
            return builder;
        }

        @NotNull
        public final Builder assertClassCoverageAtLeast(double percentage) {
            Builder builder;
            Builder $this$assertClassCoverageAtLeast_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            $this$assertClassCoverageAtLeast_u24lambda_u2d3.setCoverageAtLeast(ProcessEngineCoverageExtensionKt.checkPercentage(percentage));
            return builder;
        }

        @NotNull
        public final Builder excludeProcessDefinitionKeys(String ... processDefinitionKeys) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)processDefinitionKeys, (String)"processDefinitionKeys");
            Builder $this$excludeProcessDefinitionKeys_u24lambda_u2d4 = builder = this;
            boolean bl = false;
            $this$excludeProcessDefinitionKeys_u24lambda_u2d4.setExcludedProcessDefinitionKeys(ArraysKt.toList((Object[])processDefinitionKeys));
            return builder;
        }

        @NotNull
        public final Builder optionalAssertCoverageAtLeastProperty(@NotNull String property) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            Builder $this$optionalAssertCoverageAtLeastProperty_u24lambda_u2d5 = builder = this;
            boolean bl = false;
            $this$optionalAssertCoverageAtLeastProperty_u24lambda_u2d5.setOptionalAssertCoverageAtLeastProperty(property);
            return builder;
        }

        private final Double coverageFromSystemProperty(String key) {
            Double d;
            String string = System.getProperty(key);
            if (string == null) {
                d = null;
            } else {
                double d2;
                String it = string;
                boolean bl = false;
                try {
                    d2 = ProcessEngineCoverageExtensionKt.checkPercentage(Double.parseDouble(it));
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("BAD TEST CONFIGURATION: system property \"" + key + "\" must be double");
                }
                d = d2;
            }
            return d;
        }

        @NotNull
        public final ProcessEngineCoverageExtension build() {
            double it;
            ProcessEngineCoverageExtension processEngineCoverageExtension;
            ProcessEngineCoverageExtension $this$build_u24lambda_u2d10 = processEngineCoverageExtension = new ProcessEngineCoverageExtension(this.detailedCoverageLogging, this.handleTestMethodCoverage, this.excludedProcessDefinitionKeys);
            boolean bl = false;
            Double d = this.coverageFromSystemProperty(this.getOptionalAssertCoverageAtLeastProperty());
            if (d != null) {
                it = ((Number)d).doubleValue();
                boolean bl2 = false;
                $this$build_u24lambda_u2d10.addClassCoverageAtLeast(it);
            }
            Double d2 = this.getCoverageAtLeast();
            if (d2 != null) {
                it = ((Number)d2).doubleValue();
                boolean bl3 = false;
                $this$build_u24lambda_u2d10.addClassCoverageAtLeast(it);
            }
            String string = this.getConfigurationResource();
            if (string != null) {
                String it2 = string;
                boolean bl4 = false;
                $this$build_u24lambda_u2d10.configurationResource(it2);
            }
            if (this.getProcessEngineConfiguration() != null) {
                $this$build_u24lambda_u2d10.processEngine = this.getProcessEngineConfiguration().buildProcessEngine();
                ProcessEngineConfiguration processEngineConfiguration = $this$build_u24lambda_u2d10.processEngine.getProcessEngineConfiguration();
                if (processEngineConfiguration == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl");
                }
                $this$build_u24lambda_u2d10.processEngineConfiguration = (ProcessEngineConfigurationImpl)processEngineConfiguration;
            } else if ($this$build_u24lambda_u2d10.processEngine == null) {
                $this$build_u24lambda_u2d10.initializeProcessEngine();
            }
            $this$build_u24lambda_u2d10.initializeListeners();
            return processEngineCoverageExtension;
        }

        @Nullable
        public final String component1() {
            return this.configurationResource;
        }

        @Nullable
        public final ProcessEngineConfiguration component2() {
            return this.processEngineConfiguration;
        }

        public final boolean component3() {
            return this.detailedCoverageLogging;
        }

        public final boolean component4() {
            return this.handleTestMethodCoverage;
        }

        @Nullable
        public final Double component5() {
            return this.coverageAtLeast;
        }

        @NotNull
        public final List<String> component6() {
            return this.excludedProcessDefinitionKeys;
        }

        @NotNull
        public final String component7() {
            return this.optionalAssertCoverageAtLeastProperty;
        }

        @NotNull
        public final Builder copy(@Nullable String configurationResource2, @Nullable ProcessEngineConfiguration processEngineConfiguration, boolean detailedCoverageLogging, boolean handleTestMethodCoverage, @Nullable Double coverageAtLeast, @NotNull List<String> excludedProcessDefinitionKeys, @NotNull String optionalAssertCoverageAtLeastProperty) {
            Intrinsics.checkNotNullParameter(excludedProcessDefinitionKeys, (String)"excludedProcessDefinitionKeys");
            Intrinsics.checkNotNullParameter((Object)optionalAssertCoverageAtLeastProperty, (String)"optionalAssertCoverageAtLeastProperty");
            return new Builder(configurationResource2, processEngineConfiguration, detailedCoverageLogging, handleTestMethodCoverage, coverageAtLeast, excludedProcessDefinitionKeys, optionalAssertCoverageAtLeastProperty);
        }

        public static /* synthetic */ Builder copy$default(Builder builder, String string, ProcessEngineConfiguration processEngineConfiguration, boolean bl, boolean bl2, Double d, List list, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = builder.configurationResource;
            }
            if ((n & 2) != 0) {
                processEngineConfiguration = builder.processEngineConfiguration;
            }
            if ((n & 4) != 0) {
                bl = builder.detailedCoverageLogging;
            }
            if ((n & 8) != 0) {
                bl2 = builder.handleTestMethodCoverage;
            }
            if ((n & 0x10) != 0) {
                d = builder.coverageAtLeast;
            }
            if ((n & 0x20) != 0) {
                list = builder.excludedProcessDefinitionKeys;
            }
            if ((n & 0x40) != 0) {
                string2 = builder.optionalAssertCoverageAtLeastProperty;
            }
            return builder.copy(string, processEngineConfiguration, bl, bl2, d, list, string2);
        }

        @NotNull
        public String toString() {
            return "Builder(configurationResource=" + this.configurationResource + ", processEngineConfiguration=" + this.processEngineConfiguration + ", detailedCoverageLogging=" + this.detailedCoverageLogging + ", handleTestMethodCoverage=" + this.handleTestMethodCoverage + ", coverageAtLeast=" + this.coverageAtLeast + ", excludedProcessDefinitionKeys=" + this.excludedProcessDefinitionKeys + ", optionalAssertCoverageAtLeastProperty=" + this.optionalAssertCoverageAtLeastProperty + ')';
        }

        public int hashCode() {
            int result = this.configurationResource == null ? 0 : this.configurationResource.hashCode();
            result = result * 31 + (this.processEngineConfiguration == null ? 0 : this.processEngineConfiguration.hashCode());
            int n = this.detailedCoverageLogging ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n2 = this.handleTestMethodCoverage ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            result = result * 31 + (this.coverageAtLeast == null ? 0 : ((Object)this.coverageAtLeast).hashCode());
            result = result * 31 + ((Object)this.excludedProcessDefinitionKeys).hashCode();
            result = result * 31 + this.optionalAssertCoverageAtLeastProperty.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Builder)) {
                return false;
            }
            Builder builder = (Builder)other;
            if (!Intrinsics.areEqual((Object)this.configurationResource, (Object)builder.configurationResource)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.processEngineConfiguration, (Object)builder.processEngineConfiguration)) {
                return false;
            }
            if (this.detailedCoverageLogging != builder.detailedCoverageLogging) {
                return false;
            }
            if (this.handleTestMethodCoverage != builder.handleTestMethodCoverage) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.coverageAtLeast, (Object)builder.coverageAtLeast)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.excludedProcessDefinitionKeys, builder.excludedProcessDefinitionKeys)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.optionalAssertCoverageAtLeastProperty, (Object)builder.optionalAssertCoverageAtLeastProperty);
        }

        public Builder() {
            this(null, null, false, false, null, null, null, 127, null);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/camunda/bpm/extension/process_test_coverage/junit5/ProcessEngineCoverageExtension$Builder$Companion;", "", "()V", "DEFAULT_ASSERT_AT_LEAST_PROPERTY", "", "camunda-bpm-process-test-coverage-junit5"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

