/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.process_test_coverage.junit.rules;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParseListener;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.event.EventHandler;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.extension.process_test_coverage.engine.CompensationEventCoverageHandler;
import org.camunda.bpm.extension.process_test_coverage.engine.ElementCoverageParseListener;
import org.camunda.bpm.extension.process_test_coverage.engine.ExecutionContextModelProvider;
import org.camunda.bpm.extension.process_test_coverage.engine.ModelProvider;
import org.camunda.bpm.extension.process_test_coverage.junit.rules.MinimalCoverageMatcher;
import org.camunda.bpm.extension.process_test_coverage.model.Collector;
import org.camunda.bpm.extension.process_test_coverage.model.DefaultCollector;
import org.camunda.bpm.extension.process_test_coverage.model.Run;
import org.camunda.bpm.extension.process_test_coverage.model.Suite;
import org.camunda.bpm.extension.process_test_coverage.util.CoverageReportUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestCoverageProcessEngineRule
extends ProcessEngineRule {
    private static final Logger logger = Logger.getLogger(TestCoverageProcessEngineRule.class.getCanonicalName());
    private final DefaultCollector coverageCollector = new DefaultCollector((ModelProvider)new ExecutionContextModelProvider());
    private final AtomicBoolean firstRun = new AtomicBoolean(true);
    private boolean detailedCoverageLogging = false;
    private boolean handleTestMethodCoverage = true;
    private final Collection<Matcher<Double>> classCoverageAssertionMatchers = new LinkedList<Matcher<Double>>();
    private final Map<String, Collection<Matcher<Double>>> testMethodNameToCoverageMatchers = new HashMap<String, Collection<Matcher<Double>>>();
    private List<String> excludedProcessDefinitionKeys = Collections.emptyList();

    TestCoverageProcessEngineRule() {
    }

    TestCoverageProcessEngineRule(ProcessEngine processEngine) {
        super(processEngine);
    }

    public void addTestMethodCoverageAssertionMatcher(String testMethodName, Matcher<Double> matcher) {
        Collection matchers = this.testMethodNameToCoverageMatchers.computeIfAbsent(testMethodName, k -> new LinkedList());
        matchers.add(matcher);
    }

    public void addClassCoverageAssertionMatcher(MinimalCoverageMatcher matcher) {
        this.classCoverageAssertionMatchers.add((Matcher<Double>)matcher);
    }

    public void setExcludedProcessDefinitionKeys(List<String> excludedProcessDefinitionKeys) {
        this.excludedProcessDefinitionKeys = excludedProcessDefinitionKeys;
    }

    public void starting(Description description) {
        this.validateClassRuleAnnotations(description);
        if (this.processEngine == null) {
            super.initializeProcessEngine();
        }
        this.initializeSuite(description);
        super.starting(description);
        if (this.isRelevantTestMethod(description)) {
            this.initializeRun(description);
        }
    }

    public void finished(Description description) {
        if (this.handleTestMethodCoverage && this.isRelevantTestMethod(description)) {
            this.handleTestMethodCoverage(description);
        }
        if (!description.isTest()) {
            this.handleClassCoverage();
        }
        if (this.processEngineConfiguration != null) {
            super.finished(description);
        }
    }

    private void validateClassRuleAnnotations(Description description) {
        if (!description.isTest() && this.firstRun.get()) {
            int numberOfCoverageRules = 0;
            for (Field field : description.getTestClass().getFields()) {
                Class<?> fieldType = field.getType();
                if (!((Object)((Object)this)).getClass().isAssignableFrom(fieldType)) continue;
                ++numberOfCoverageRules;
                boolean isClassRule = field.isAnnotationPresent(ClassRule.class);
                boolean isRule = field.isAnnotationPresent(Rule.class);
                if (!isClassRule || isRule) continue;
                throw new RuntimeException(((Object)((Object)this)).getClass().getCanonicalName() + " can only be used as a @ClassRule if it is also a @Rule!");
            }
            if (numberOfCoverageRules > 1) {
                throw new RuntimeException("Only one coverage rule can be used per test class!");
            }
        }
    }

    private void initializeSuite(Description description) {
        if (this.firstRun.compareAndSet(true, false)) {
            String suiteId = description.getClassName();
            this.coverageCollector.createSuite(new Suite(suiteId, description.getClassName()));
            this.coverageCollector.setExcludedProcessDefinitionKeys(this.excludedProcessDefinitionKeys);
            this.coverageCollector.activateSuite(suiteId);
            this.initializeListeners();
        }
    }

    private void initializeRun(Description description) {
        String runId = description.getMethodName();
        this.coverageCollector.createRun(new Run(runId, description.getMethodName()), this.coverageCollector.getActiveSuite().getId());
        this.coverageCollector.activateRun(runId);
    }

    private void initializeListeners() {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration();
        List bpmnParseListeners = processEngineConfiguration.getCustomPostBPMNParseListeners();
        for (BpmnParseListener parseListener : bpmnParseListeners) {
            if (!(parseListener instanceof ElementCoverageParseListener)) continue;
            ElementCoverageParseListener listener = (ElementCoverageParseListener)parseListener;
            listener.setCoverageState((Collector)this.coverageCollector);
        }
        EventHandler compensationEventHandler = processEngineConfiguration.getEventHandler("compensate");
        if (compensationEventHandler instanceof CompensationEventCoverageHandler) {
            CompensationEventCoverageHandler compensationEventCoverageHandler = (CompensationEventCoverageHandler)compensationEventHandler;
            compensationEventCoverageHandler.setCoverageState((Collector)this.coverageCollector);
        } else {
            logger.warning("CompensationEventCoverageHandler not registered with process engine configuration! Compensation boundary events coverage will not be registered.");
        }
    }

    private void handleTestMethodCoverage(Description description) {
        String testName = description.getMethodName();
        Suite suite = this.coverageCollector.getActiveSuite();
        Run run = suite.getRun(testName);
        if (run == null) {
            return;
        }
        double coveragePercentage = run.calculateCoverage(this.coverageCollector.getModels());
        logger.info(testName + " test method coverage is " + coveragePercentage);
        this.logCoverageDetail(run);
        if (this.testMethodNameToCoverageMatchers.containsKey(testName)) {
            this.assertCoverage(coveragePercentage, this.testMethodNameToCoverageMatchers.get(testName));
        }
    }

    private boolean isRelevantTestMethod(Description description) {
        return description.isTest() && this.deploymentId != null && this.processEngine.getRepositoryService().createProcessDefinitionQuery().deploymentId(this.deploymentId).list().stream().anyMatch(it -> !this.isExcluded((ProcessDefinition)it));
    }

    private void handleClassCoverage() {
        Suite suite = this.coverageCollector.getActiveSuite();
        double suiteCoveragePercentage = suite.calculateCoverage(this.coverageCollector.getModels());
        logger.info(suite.getName() + " test class coverage is: " + suiteCoveragePercentage);
        this.logCoverageDetail(suite);
        CoverageReportUtil.createReport((DefaultCollector)this.coverageCollector);
        CoverageReportUtil.createJsonReport((DefaultCollector)this.coverageCollector);
        this.assertCoverage(suiteCoveragePercentage, this.classCoverageAssertionMatchers);
    }

    private void assertCoverage(double coverage, Collection<Matcher<Double>> matchers) {
        for (Matcher<Double> matcher : matchers) {
            MatcherAssert.assertThat((Object)coverage, matcher);
        }
    }

    private void logCoverageDetail(Suite suite) {
        if (logger.isLoggable(Level.FINE) || this.isDetailedCoverageLogging()) {
            logger.log(Level.INFO, suite.toString());
        }
    }

    private void logCoverageDetail(Run run) {
        if (logger.isLoggable(Level.FINE) || this.isDetailedCoverageLogging()) {
            logger.log(Level.INFO, run.toString());
        }
    }

    private boolean isExcluded(ProcessDefinition processDefinition) {
        if (this.excludedProcessDefinitionKeys != null) {
            return this.excludedProcessDefinitionKeys.contains(processDefinition.getKey());
        }
        return false;
    }

    public boolean isDetailedCoverageLogging() {
        return this.detailedCoverageLogging;
    }

    public void setDetailedCoverageLogging(boolean detailedCoverageLogging) {
        this.detailedCoverageLogging = detailedCoverageLogging;
    }

    public void setHandleTestMethodCoverage(boolean handleTestMethodCoverage) {
        this.handleTestMethodCoverage = handleTestMethodCoverage;
    }

    public Statement apply(Statement base, Description description) {
        return super.apply(base, description);
    }

    protected void succeeded(Description description) {
        super.succeeded(description);
        logger.info(description.getDisplayName() + " succeeded.");
    }

    protected void failed(Throwable e, Description description) {
        super.failed(e, description);
        logger.info(description.getDisplayName() + " failed.");
    }
}

