/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.executor.BatchExecutorException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.util.StringUtil;

public class ExceptionUtil {
    public static String getExceptionStacktrace(Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static String getExceptionStacktrace(ByteArrayEntity byteArray) {
        String result = null;
        if (byteArray != null) {
            result = StringUtil.fromBytes(byteArray.getBytes());
        }
        return result;
    }

    public static ByteArrayEntity createJobExceptionByteArray(byte[] byteArray) {
        return ExceptionUtil.createExceptionByteArray("job.exceptionByteArray", byteArray);
    }

    public static ByteArrayEntity createExceptionByteArray(String name, byte[] byteArray) {
        ByteArrayEntity result = null;
        if (byteArray != null) {
            result = new ByteArrayEntity(name, byteArray);
            Context.getCommandContext().getDbEntityManager().insert(result);
        }
        return result;
    }

    public static boolean checkValueTooLongException(ProcessEngineException exception) {
        List<SQLException> sqlExceptionList = ExceptionUtil.findRelatedSqlExceptions(exception);
        for (SQLException ex : sqlExceptionList) {
            if (!ex.getMessage().contains("too long") && !ex.getMessage().contains("too large") && !ex.getMessage().contains("ORA-01461") && !ex.getMessage().contains("ORA-01401") && !ex.getMessage().contains("data would be truncated") && !ex.getMessage().contains("SQLCODE=-302, SQLSTATE=22001")) continue;
            return true;
        }
        return false;
    }

    public static List<SQLException> findRelatedSqlExceptions(Throwable exception) {
        ArrayList<SQLException> sqlExceptionList = new ArrayList<SQLException>();
        Throwable cause = exception;
        do {
            if (!(cause instanceof SQLException)) continue;
            SQLException sqlEx = (SQLException)cause;
            sqlExceptionList.add(sqlEx);
            while (sqlEx.getNextException() != null) {
                sqlExceptionList.add(sqlEx.getNextException());
                sqlEx = sqlEx.getNextException();
            }
        } while ((cause = cause.getCause()) != null);
        return sqlExceptionList;
    }

    public static boolean checkForeignKeyConstraintViolation(Throwable cause) {
        List<SQLException> relatedSqlExceptions = ExceptionUtil.findRelatedSqlExceptions(cause);
        for (SQLException exception : relatedSqlExceptions) {
            if ("23503".equals(exception.getSQLState()) && exception.getErrorCode() == 0) {
                return false;
            }
            if (!(exception.getMessage().toLowerCase().contains("foreign key constraint") || "23000".equals(exception.getSQLState()) && exception.getErrorCode() == 547 || exception.getMessage().toLowerCase().contains("foreign key constraint") || "23000".equals(exception.getSQLState()) && exception.getErrorCode() == 1452 || exception.getMessage().toLowerCase().contains("integrity constraint") || "23000".equals(exception.getSQLState()) && exception.getErrorCode() == 2291 || "23506".equals(exception.getSQLState()) && exception.getErrorCode() == 23506) && (!exception.getMessage().toLowerCase().contains("sqlstate=23503") || !exception.getMessage().toLowerCase().contains("sqlcode=-530"))) continue;
            return true;
        }
        return false;
    }

    public static boolean checkVariableIntegrityViolation(Throwable cause) {
        List<SQLException> relatedSqlExceptions = ExceptionUtil.findRelatedSqlExceptions(cause);
        for (SQLException exception : relatedSqlExceptions) {
            if (!(exception.getMessage().toLowerCase().contains("act_uniq_variable") && "23000".equals(exception.getSQLState()) && exception.getErrorCode() == 1062 || exception.getMessage().toLowerCase().contains("act_uniq_variable") && "23505".equals(exception.getSQLState()) && exception.getErrorCode() == 0 || exception.getMessage().toLowerCase().contains("act_uniq_variable") && "23000".equals(exception.getSQLState()) && exception.getErrorCode() == 2601 || exception.getMessage().toLowerCase().contains("act_uniq_variable") && "23000".equals(exception.getSQLState()) && exception.getErrorCode() == 1) && (!exception.getMessage().toLowerCase().contains("act_uniq_variable_index_c") || !"23505".equals(exception.getSQLState()) || exception.getErrorCode() != 23505)) continue;
            return true;
        }
        return false;
    }

    public static BatchExecutorException findBatchExecutorException(Throwable exception) {
        Throwable cause = exception;
        do {
            if (!(cause instanceof BatchExecutorException)) continue;
            return (BatchExecutorException)cause;
        } while ((cause = cause.getCause()) != null);
        return null;
    }
}

