/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.ProcessDefinitionQueryProperty;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParse;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.event.EventType;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.util.CompareUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.Documentation;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class ProcessDefinitionQueryImpl
extends AbstractQuery<ProcessDefinitionQuery, ProcessDefinition>
implements ProcessDefinitionQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String[] ids;
    protected String category;
    protected String categoryLike;
    protected String name;
    protected String nameLike;
    protected String deploymentId;
    protected String key;
    protected String[] keys;
    protected String keyLike;
    protected String resourceName;
    protected String resourceNameLike;
    protected Integer version;
    protected boolean latest = false;
    protected SuspensionState suspensionState;
    protected String authorizationUserId;
    protected String procDefId;
    protected String incidentType;
    protected String incidentId;
    protected String incidentMessage;
    protected String incidentMessageLike;
    protected String eventSubscriptionName;
    protected String eventSubscriptionType;
    protected boolean isTenantIdSet = false;
    protected String[] tenantIds;
    protected boolean includeDefinitionsWithoutTenantId = false;
    protected String versionTag;
    protected String versionTagLike;

    public ProcessDefinitionQueryImpl() {
    }

    public ProcessDefinitionQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionId(String processDefinitionId) {
        this.id = processDefinitionId;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionIdIn(String ... ids) {
        this.ids = ids;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionCategory(String category) {
        EnsureUtil.ensureNotNull("category", (Object)category);
        this.category = category;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionCategoryLike(String categoryLike) {
        EnsureUtil.ensureNotNull("categoryLike", (Object)categoryLike);
        this.categoryLike = categoryLike;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionName(String name) {
        EnsureUtil.ensureNotNull("name", (Object)name);
        this.name = name;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionNameLike(String nameLike) {
        EnsureUtil.ensureNotNull("nameLike", (Object)nameLike);
        this.nameLike = nameLike;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl deploymentId(String deploymentId) {
        EnsureUtil.ensureNotNull("deploymentId", (Object)deploymentId);
        this.deploymentId = deploymentId;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionKey(String key) {
        EnsureUtil.ensureNotNull("key", (Object)key);
        this.key = key;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionKeysIn(String ... keys) {
        EnsureUtil.ensureNotNull("keys", keys);
        this.keys = keys;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionKeyLike(String keyLike) {
        EnsureUtil.ensureNotNull("keyLike", (Object)keyLike);
        this.keyLike = keyLike;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionResourceName(String resourceName) {
        EnsureUtil.ensureNotNull("resourceName", (Object)resourceName);
        this.resourceName = resourceName;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionResourceNameLike(String resourceNameLike) {
        EnsureUtil.ensureNotNull("resourceNameLike", (Object)resourceNameLike);
        this.resourceNameLike = resourceNameLike;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionVersion(Integer version) {
        EnsureUtil.ensureNotNull("version", (Object)version);
        EnsureUtil.ensurePositive("version", version.longValue());
        this.version = version;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl latestVersion() {
        this.latest = true;
        return this;
    }

    @Override
    public ProcessDefinitionQuery active() {
        this.suspensionState = SuspensionState.ACTIVE;
        return this;
    }

    @Override
    public ProcessDefinitionQuery suspended() {
        this.suspensionState = SuspensionState.SUSPENDED;
        return this;
    }

    @Override
    public ProcessDefinitionQuery messageEventSubscription(String messageName) {
        return this.eventSubscription(EventType.MESSAGE, messageName);
    }

    @Override
    public ProcessDefinitionQuery messageEventSubscriptionName(String messageName) {
        return this.eventSubscription(EventType.MESSAGE, messageName);
    }

    public ProcessDefinitionQuery processDefinitionStarter(String procDefId) {
        this.procDefId = procDefId;
        return this;
    }

    public ProcessDefinitionQuery eventSubscription(EventType eventType, String eventName) {
        EnsureUtil.ensureNotNull("event type", (Object)eventType);
        EnsureUtil.ensureNotNull("event name", (Object)eventName);
        this.eventSubscriptionType = eventType.name();
        this.eventSubscriptionName = eventName;
        return this;
    }

    @Override
    public ProcessDefinitionQuery incidentType(String incidentType) {
        EnsureUtil.ensureNotNull("incident type", (Object)incidentType);
        this.incidentType = incidentType;
        return this;
    }

    @Override
    public ProcessDefinitionQuery incidentId(String incidentId) {
        EnsureUtil.ensureNotNull("incident id", (Object)incidentId);
        this.incidentId = incidentId;
        return this;
    }

    @Override
    public ProcessDefinitionQuery incidentMessage(String incidentMessage) {
        EnsureUtil.ensureNotNull("incident message", (Object)incidentMessage);
        this.incidentMessage = incidentMessage;
        return this;
    }

    @Override
    public ProcessDefinitionQuery incidentMessageLike(String incidentMessageLike) {
        EnsureUtil.ensureNotNull("incident messageLike", (Object)incidentMessageLike);
        this.incidentMessageLike = incidentMessageLike;
        return this;
    }

    @Override
    protected boolean hasExcludingConditions() {
        return super.hasExcludingConditions() || CompareUtil.elementIsNotContainedInArray(this.id, this.ids);
    }

    @Override
    public ProcessDefinitionQueryImpl tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull("tenantIds", tenantIds);
        this.tenantIds = tenantIds;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public ProcessDefinitionQuery withoutTenantId() {
        this.isTenantIdSet = true;
        this.tenantIds = null;
        return this;
    }

    @Override
    public ProcessDefinitionQuery includeProcessDefinitionsWithoutTenantId() {
        this.includeDefinitionsWithoutTenantId = true;
        return this;
    }

    @Override
    public ProcessDefinitionQuery versionTag(String versionTag) {
        EnsureUtil.ensureNotNull("versionTag", (Object)versionTag);
        this.versionTag = versionTag;
        return this;
    }

    @Override
    public ProcessDefinitionQuery versionTagLike(String versionTagLike) {
        EnsureUtil.ensureNotNull("versionTagLike", (Object)versionTagLike);
        this.versionTagLike = versionTagLike;
        return this;
    }

    @Override
    public ProcessDefinitionQuery orderByDeploymentId() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.DEPLOYMENT_ID);
    }

    @Override
    public ProcessDefinitionQuery orderByProcessDefinitionKey() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.PROCESS_DEFINITION_KEY);
    }

    @Override
    public ProcessDefinitionQuery orderByProcessDefinitionCategory() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.PROCESS_DEFINITION_CATEGORY);
    }

    @Override
    public ProcessDefinitionQuery orderByProcessDefinitionId() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.PROCESS_DEFINITION_ID);
    }

    @Override
    public ProcessDefinitionQuery orderByProcessDefinitionVersion() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.PROCESS_DEFINITION_VERSION);
    }

    @Override
    public ProcessDefinitionQuery orderByProcessDefinitionName() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.PROCESS_DEFINITION_NAME);
    }

    @Override
    public ProcessDefinitionQuery orderByTenantId() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.TENANT_ID);
    }

    @Override
    public ProcessDefinitionQuery orderByVersionTag() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.VERSION_TAG);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getProcessDefinitionManager().findProcessDefinitionCountByQueryCriteria(this);
    }

    @Override
    public List<ProcessDefinition> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        List<ProcessDefinition> list = commandContext.getProcessDefinitionManager().findProcessDefinitionsByQueryCriteria(this, page);
        boolean shouldQueryAddBpmnModelInstancesToCache = commandContext.getProcessEngineConfiguration().getEnableFetchProcessDefinitionDescription();
        if (shouldQueryAddBpmnModelInstancesToCache) {
            this.addProcessDefinitionToCacheAndRetrieveDocumentation(list);
        }
        return list;
    }

    protected void addProcessDefinitionToCacheAndRetrieveDocumentation(List<ProcessDefinition> list) {
        for (ProcessDefinition processDefinition : list) {
            BpmnModelInstance bpmnModelInstance = Context.getProcessEngineConfiguration().getDeploymentCache().findBpmnModelInstanceForProcessDefinition((ProcessDefinitionEntity)processDefinition);
            ModelElementInstance processElement = bpmnModelInstance.getModelElementById(processDefinition.getKey());
            if (processElement == null) continue;
            Collection documentations = processElement.getChildElementsByType(Documentation.class);
            ArrayList<String> docStrings = new ArrayList<String>();
            for (Documentation documentation : documentations) {
                docStrings.add(documentation.getTextContent());
            }
            ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity)processDefinition;
            processDefinitionEntity.setProperty("documentation", BpmnParse.parseDocumentation(docStrings));
        }
    }

    @Override
    public void checkQueryOk() {
        super.checkQueryOk();
        if (this.latest && (this.id != null || this.version != null || this.deploymentId != null)) {
            throw new ProcessEngineException("Calling latest() can only be used in combination with key(String) and keyLike(String) or name(String) and nameLike(String)");
        }
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getId() {
        return this.id;
    }

    public String[] getIds() {
        return this.ids;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyLike() {
        return this.keyLike;
    }

    public Integer getVersion() {
        return this.version;
    }

    public boolean isLatest() {
        return this.latest;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategoryLike() {
        return this.categoryLike;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourceNameLike() {
        return this.resourceNameLike;
    }

    public SuspensionState getSuspensionState() {
        return this.suspensionState;
    }

    public void setSuspensionState(SuspensionState suspensionState) {
        this.suspensionState = suspensionState;
    }

    public String getIncidentId() {
        return this.incidentId;
    }

    public String getIncidentType() {
        return this.incidentType;
    }

    public String getIncidentMessage() {
        return this.incidentMessage;
    }

    public String getIncidentMessageLike() {
        return this.incidentMessageLike;
    }

    public String getVersionTag() {
        return this.versionTag;
    }

    @Override
    public ProcessDefinitionQueryImpl startableByUser(String userId) {
        EnsureUtil.ensureNotNull("userId", (Object)userId);
        this.authorizationUserId = userId;
        return this;
    }
}

