/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.List;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.impl.HistoricIncidentQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.persistence.AbstractHistoricManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricIncidentEntity;

public class HistoricIncidentManager
extends AbstractHistoricManager {
    public long findHistoricIncidentCountByQueryCriteria(HistoricIncidentQueryImpl query) {
        this.configureQuery(query);
        return (Long)this.getDbEntityManager().selectOne("selectHistoricIncidentCountByQueryCriteria", query);
    }

    public List<HistoricIncident> findHistoricIncidentByQueryCriteria(HistoricIncidentQueryImpl query, Page page) {
        this.configureQuery(query);
        return this.getDbEntityManager().selectList("selectHistoricIncidentByQueryCriteria", query, page);
    }

    public void deleteHistoricIncidentsByProcessInstanceIds(List<String> processInstanceIds) {
        this.getDbEntityManager().deletePreserveOrder(HistoricIncidentEntity.class, "deleteHistoricIncidentsByProcessInstanceIds", processInstanceIds);
    }

    public void deleteHistoricIncidentsByProcessDefinitionId(String processDefinitionId) {
        if (this.isHistoryLevelFullEnabled()) {
            this.getDbEntityManager().delete(HistoricIncidentEntity.class, "deleteHistoricIncidentsByProcessDefinitionId", processDefinitionId);
        }
    }

    public void deleteHistoricIncidentsByJobDefinitionId(String jobDefinitionId) {
        if (this.isHistoryLevelFullEnabled()) {
            this.getDbEntityManager().delete(HistoricIncidentEntity.class, "deleteHistoricIncidentsByJobDefinitionId", jobDefinitionId);
        }
    }

    public void deleteHistoricIncidentsByBatchId(List<String> historicBatchIds) {
        if (this.isHistoryLevelFullEnabled()) {
            this.getDbEntityManager().delete(HistoricIncidentEntity.class, "deleteHistoricIncidentsByBatchIds", historicBatchIds);
        }
    }

    protected void configureQuery(HistoricIncidentQueryImpl query) {
        this.getAuthorizationManager().configureHistoricIncidentQuery(query);
        this.getTenantManager().configureQuery(query);
    }
}

