/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cfg.auth;

import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.HistoricCaseInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.history.HistoricBatchEntity;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.CompositePermissionCheck;
import org.camunda.bpm.engine.impl.db.PermissionCheck;
import org.camunda.bpm.engine.impl.db.PermissionCheckBuilder;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionRequirementsDefinitionEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricExternalTaskLogEntity;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogEventEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;

public class AuthorizationCommandChecker
implements CommandChecker {
    @Override
    public void checkEvaluateDecision(DecisionDefinition decisionDefinition) {
        this.getAuthorizationManager().checkAuthorization(Permissions.CREATE_INSTANCE, Resources.DECISION_DEFINITION, decisionDefinition.getKey());
    }

    @Override
    public void checkCreateProcessInstance(ProcessDefinition processDefinition) {
        this.getAuthorizationManager().checkAuthorization(Permissions.CREATE, Resources.PROCESS_INSTANCE);
        this.getAuthorizationManager().checkAuthorization(Permissions.CREATE_INSTANCE, Resources.PROCESS_DEFINITION, processDefinition.getKey());
    }

    @Override
    public void checkReadProcessDefinition(ProcessDefinition processDefinition) {
        this.getAuthorizationManager().checkAuthorization(Permissions.READ, Resources.PROCESS_DEFINITION, processDefinition.getKey());
    }

    @Override
    public void checkCreateCaseInstance(CaseDefinition caseDefinition) {
    }

    @Override
    public void checkUpdateProcessDefinitionById(String processDefinitionId) {
        ProcessDefinitionEntity processDefinition;
        if (this.getAuthorizationManager().isAuthorizationEnabled() && (processDefinition = this.findLatestProcessDefinitionById(processDefinitionId)) != null) {
            this.checkUpdateProcessDefinitionByKey(processDefinition.getKey());
        }
    }

    @Override
    public void checkUpdateDecisionDefinitionById(String decisionDefinitionId) {
        DecisionDefinitionEntity decisionDefinition;
        if (this.getAuthorizationManager().isAuthorizationEnabled() && (decisionDefinition = this.findLatestDecisionDefinitionById(decisionDefinitionId)) != null) {
            this.checkUpdateDecisionDefinition(decisionDefinition);
        }
    }

    @Override
    public void checkUpdateProcessDefinitionByKey(String processDefinitionKey) {
        this.getAuthorizationManager().checkAuthorization(Permissions.UPDATE, Resources.PROCESS_DEFINITION, processDefinitionKey);
    }

    @Override
    public void checkDeleteProcessDefinitionById(String processDefinitionId) {
        ProcessDefinitionEntity processDefinition;
        if (this.getAuthorizationManager().isAuthorizationEnabled() && (processDefinition = this.findLatestProcessDefinitionById(processDefinitionId)) != null) {
            this.checkDeleteProcessDefinitionByKey(processDefinition.getKey());
        }
    }

    @Override
    public void checkDeleteProcessDefinitionByKey(String processDefinitionKey) {
        this.getAuthorizationManager().checkAuthorization(Permissions.DELETE, Resources.PROCESS_DEFINITION, processDefinitionKey);
    }

    @Override
    public void checkUpdateProcessInstanceByProcessDefinitionId(String processDefinitionId) {
        ProcessDefinitionEntity processDefinition;
        if (this.getAuthorizationManager().isAuthorizationEnabled() && (processDefinition = this.findLatestProcessDefinitionById(processDefinitionId)) != null) {
            this.checkUpdateProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        }
    }

    @Override
    public void checkUpdateProcessInstanceByProcessDefinitionKey(String processDefinitionKey) {
        PermissionCheck firstCheck = new PermissionCheck();
        firstCheck.setPermission(Permissions.UPDATE);
        firstCheck.setResource(Resources.PROCESS_INSTANCE);
        PermissionCheck secondCheck = new PermissionCheck();
        secondCheck.setPermission(Permissions.UPDATE_INSTANCE);
        secondCheck.setResource(Resources.PROCESS_DEFINITION);
        secondCheck.setResourceId(processDefinitionKey);
        secondCheck.setAuthorizationNotFoundReturnValue(0L);
        this.getAuthorizationManager().checkAuthorization(firstCheck, secondCheck);
    }

    @Override
    public void checkReadProcessInstance(String processInstanceId) {
        ExecutionEntity execution = this.findExecutionById(processInstanceId);
        if (execution != null) {
            this.checkReadProcessInstance(execution);
        }
    }

    @Override
    public void checkDeleteProcessInstance(ExecutionEntity execution) {
        ProcessDefinitionEntity processDefinition = execution.getProcessDefinition();
        PermissionCheck firstCheck = new PermissionCheck();
        firstCheck.setPermission(Permissions.DELETE);
        firstCheck.setResource(Resources.PROCESS_INSTANCE);
        firstCheck.setResourceId(execution.getProcessInstanceId());
        PermissionCheck secondCheck = new PermissionCheck();
        secondCheck.setPermission(Permissions.DELETE_INSTANCE);
        secondCheck.setResource(Resources.PROCESS_DEFINITION);
        secondCheck.setResourceId(processDefinition.getKey());
        secondCheck.setAuthorizationNotFoundReturnValue(0L);
        this.getAuthorizationManager().checkAuthorization(firstCheck, secondCheck);
    }

    @Override
    public void checkUpdateProcessInstanceById(String processInstanceId) {
        ExecutionEntity execution = this.findExecutionById(processInstanceId);
        if (execution != null) {
            this.checkUpdateProcessInstance(execution);
        }
    }

    @Override
    public void checkUpdateProcessInstance(ExecutionEntity execution) {
        ProcessDefinitionEntity processDefinition = execution.getProcessDefinition();
        PermissionCheck firstCheck = new PermissionCheck();
        firstCheck.setPermission(Permissions.UPDATE);
        firstCheck.setResource(Resources.PROCESS_INSTANCE);
        firstCheck.setResourceId(execution.getProcessInstanceId());
        PermissionCheck secondCheck = new PermissionCheck();
        secondCheck.setPermission(Permissions.UPDATE_INSTANCE);
        secondCheck.setResource(Resources.PROCESS_DEFINITION);
        secondCheck.setResourceId(processDefinition.getKey());
        secondCheck.setAuthorizationNotFoundReturnValue(0L);
        this.getAuthorizationManager().checkAuthorization(firstCheck, secondCheck);
    }

    @Override
    public void checkUpdateJob(JobEntity job) {
        if (job.getProcessDefinitionKey() == null) {
            return;
        }
        PermissionCheck firstCheck = this.getAuthorizationManager().newPermissionCheck();
        firstCheck.setPermission(Permissions.UPDATE);
        firstCheck.setResource(Resources.PROCESS_INSTANCE);
        firstCheck.setResourceId(job.getProcessInstanceId());
        PermissionCheck secondCheck = this.getAuthorizationManager().newPermissionCheck();
        secondCheck.setPermission(Permissions.UPDATE_INSTANCE);
        secondCheck.setResource(Resources.PROCESS_DEFINITION);
        secondCheck.setResourceId(job.getProcessDefinitionKey());
        secondCheck.setAuthorizationNotFoundReturnValue(0L);
        this.getAuthorizationManager().checkAuthorization(firstCheck, secondCheck);
    }

    @Override
    public void checkCreateMigrationPlan(ProcessDefinition sourceProcessDefinition, ProcessDefinition targetProcessDefinition) {
        this.checkReadProcessDefinition(sourceProcessDefinition);
        this.checkReadProcessDefinition(targetProcessDefinition);
    }

    @Override
    public void checkMigrateProcessInstance(ExecutionEntity processInstance, ProcessDefinition targetProcessDefinition) {
    }

    @Override
    public void checkReadProcessInstance(ExecutionEntity execution) {
        ProcessDefinitionEntity processDefinition = execution.getProcessDefinition();
        PermissionCheck firstCheck = new PermissionCheck();
        firstCheck.setPermission(Permissions.READ);
        firstCheck.setResource(Resources.PROCESS_INSTANCE);
        firstCheck.setResourceId(execution.getProcessInstanceId());
        PermissionCheck secondCheck = new PermissionCheck();
        secondCheck.setPermission(Permissions.READ_INSTANCE);
        secondCheck.setResource(Resources.PROCESS_DEFINITION);
        secondCheck.setResourceId(processDefinition.getKey());
        secondCheck.setAuthorizationNotFoundReturnValue(0L);
        this.getAuthorizationManager().checkAuthorization(firstCheck, secondCheck);
    }

    @Override
    public void checkReadJob(JobEntity job) {
        if (job.getProcessDefinitionKey() == null) {
            return;
        }
        PermissionCheck firstCheck = this.getAuthorizationManager().newPermissionCheck();
        firstCheck.setPermission(Permissions.READ);
        firstCheck.setResource(Resources.PROCESS_INSTANCE);
        firstCheck.setResourceId(job.getProcessInstanceId());
        PermissionCheck secondCheck = this.getAuthorizationManager().newPermissionCheck();
        secondCheck.setPermission(Permissions.READ_INSTANCE);
        secondCheck.setResource(Resources.PROCESS_DEFINITION);
        secondCheck.setResourceId(job.getProcessDefinitionKey());
        secondCheck.setAuthorizationNotFoundReturnValue(0L);
        this.getAuthorizationManager().checkAuthorization(firstCheck, secondCheck);
    }

    @Override
    public void checkReadTask(TaskEntity task) {
        String taskId = task.getId();
        String executionId = task.getExecutionId();
        if (executionId != null) {
            ExecutionEntity execution = task.getExecution();
            ProcessDefinitionEntity processDefinition = execution.getProcessDefinition();
            PermissionCheck readPermissionCheck = this.getAuthorizationManager().newPermissionCheck();
            readPermissionCheck.setPermission(Permissions.READ);
            readPermissionCheck.setResource(Resources.TASK);
            readPermissionCheck.setResourceId(taskId);
            PermissionCheck readTaskPermissionCheck = this.getAuthorizationManager().newPermissionCheck();
            readTaskPermissionCheck.setPermission(Permissions.READ_TASK);
            readTaskPermissionCheck.setResource(Resources.PROCESS_DEFINITION);
            readTaskPermissionCheck.setResourceId(processDefinition.getKey());
            readTaskPermissionCheck.setAuthorizationNotFoundReturnValue(0L);
            this.getAuthorizationManager().checkAuthorization(readPermissionCheck, readTaskPermissionCheck);
        } else {
            String caseExecutionId = task.getCaseExecutionId();
            if (caseExecutionId == null) {
                this.getAuthorizationManager().checkAuthorization(Permissions.READ, Resources.TASK, taskId);
            }
        }
    }

    @Override
    public void checkUpdateTask(TaskEntity task) {
        String taskId = task.getId();
        String executionId = task.getExecutionId();
        if (executionId != null) {
            ExecutionEntity execution = task.getExecution();
            ProcessDefinitionEntity processDefinition = execution.getProcessDefinition();
            PermissionCheck updatePermissionCheck = new PermissionCheck();
            updatePermissionCheck.setPermission(Permissions.UPDATE);
            updatePermissionCheck.setResource(Resources.TASK);
            updatePermissionCheck.setResourceId(taskId);
            PermissionCheck updateTaskPermissionCheck = new PermissionCheck();
            updateTaskPermissionCheck.setPermission(Permissions.UPDATE_TASK);
            updateTaskPermissionCheck.setResource(Resources.PROCESS_DEFINITION);
            updateTaskPermissionCheck.setResourceId(processDefinition.getKey());
            updateTaskPermissionCheck.setAuthorizationNotFoundReturnValue(0L);
            this.getAuthorizationManager().checkAuthorization(updatePermissionCheck, updateTaskPermissionCheck);
        } else {
            String caseExecutionId = task.getCaseExecutionId();
            if (caseExecutionId == null) {
                this.getAuthorizationManager().checkAuthorization(Permissions.UPDATE, Resources.TASK, taskId);
            }
        }
    }

    @Override
    public void checkDeleteBatch(BatchEntity batch) {
        this.getAuthorizationManager().checkAuthorization(Permissions.DELETE, Resources.BATCH, batch.getId());
    }

    @Override
    public void checkDeleteHistoricBatch(HistoricBatchEntity batch) {
        this.getAuthorizationManager().checkAuthorization(Permissions.DELETE_HISTORY, Resources.BATCH, batch.getId());
    }

    @Override
    public void checkSuspendBatch(BatchEntity batch) {
        this.getAuthorizationManager().checkAuthorization(Permissions.UPDATE, Resources.BATCH, batch.getId());
    }

    @Override
    public void checkActivateBatch(BatchEntity batch) {
        this.getAuthorizationManager().checkAuthorization(Permissions.UPDATE, Resources.BATCH, batch.getId());
    }

    @Override
    public void checkReadHistoricBatch() {
        this.getAuthorizationManager().checkAuthorization(Permissions.READ_HISTORY, Resources.BATCH);
    }

    @Override
    public void checkCreateDeployment() {
        this.getAuthorizationManager().checkAuthorization(Permissions.CREATE, Resources.DEPLOYMENT);
    }

    @Override
    public void checkReadDeployment(String deploymentId) {
        this.getAuthorizationManager().checkAuthorization(Permissions.READ, Resources.DEPLOYMENT, deploymentId);
    }

    @Override
    public void checkDeleteDeployment(String deploymentId) {
        this.getAuthorizationManager().checkAuthorization(Permissions.DELETE, Resources.DEPLOYMENT, deploymentId);
    }

    @Override
    public void checkReadDecisionDefinition(DecisionDefinitionEntity decisionDefinition) {
        this.getAuthorizationManager().checkAuthorization(Permissions.READ, Resources.DECISION_DEFINITION, decisionDefinition.getKey());
    }

    public void checkUpdateDecisionDefinition(DecisionDefinitionEntity decisionDefinition) {
        this.getAuthorizationManager().checkAuthorization(Permissions.UPDATE, Resources.DECISION_DEFINITION, decisionDefinition.getKey());
    }

    @Override
    public void checkReadDecisionRequirementsDefinition(DecisionRequirementsDefinitionEntity decisionRequirementsDefinition) {
        this.getAuthorizationManager().checkAuthorization(Permissions.READ, Resources.DECISION_REQUIREMENTS_DEFINITION, decisionRequirementsDefinition.getKey());
    }

    @Override
    public void checkReadCaseDefinition(CaseDefinition caseDefinition) {
    }

    @Override
    public void checkUpdateCaseDefinition(CaseDefinition caseDefinition) {
    }

    @Override
    public void checkDeleteHistoricTaskInstance(HistoricTaskInstanceEntity task) {
        if (task != null && task.getProcessDefinitionKey() != null) {
            this.getAuthorizationManager().checkAuthorization(Permissions.DELETE_HISTORY, Resources.PROCESS_DEFINITION, task.getProcessDefinitionKey());
        }
    }

    @Override
    public void checkDeleteHistoricProcessInstance(HistoricProcessInstance instance) {
        this.getAuthorizationManager().checkAuthorization(Permissions.DELETE_HISTORY, Resources.PROCESS_DEFINITION, instance.getProcessDefinitionKey());
    }

    @Override
    public void checkDeleteHistoricCaseInstance(HistoricCaseInstance instance) {
    }

    @Override
    public void checkDeleteHistoricDecisionInstance(String decisionDefinitionKey) {
        this.getAuthorizationManager().checkAuthorization(Permissions.DELETE_HISTORY, Resources.DECISION_DEFINITION, decisionDefinitionKey);
    }

    @Override
    public void checkDeleteHistoricDecisionInstance(HistoricDecisionInstance decisionInstance) {
        this.getAuthorizationManager().checkAuthorization(Permissions.DELETE_HISTORY, Resources.DECISION_DEFINITION, decisionInstance.getDecisionDefinitionKey());
    }

    @Override
    public void checkReadHistoricJobLog(HistoricJobLogEventEntity historicJobLog) {
        if (historicJobLog.getProcessDefinitionKey() != null) {
            this.getAuthorizationManager().checkAuthorization(Permissions.READ_HISTORY, Resources.PROCESS_DEFINITION, historicJobLog.getProcessDefinitionKey());
        }
    }

    @Override
    public void checkReadHistoryAnyProcessDefinition() {
        this.getAuthorizationManager().checkAuthorization(Permissions.READ_HISTORY, Resources.PROCESS_DEFINITION, "*");
    }

    @Override
    public void checkReadHistoryAnyTaskInstance() {
        this.getAuthorizationManager().checkAuthorization(Permissions.READ_HISTORY, Resources.TASK, "*");
    }

    @Override
    public void checkUpdateCaseInstance(CaseExecution caseExecution) {
    }

    @Override
    public void checkReadCaseInstance(CaseExecution caseExecution) {
    }

    protected AuthorizationManager getAuthorizationManager() {
        return Context.getCommandContext().getAuthorizationManager();
    }

    protected ProcessDefinitionEntity findLatestProcessDefinitionById(String processDefinitionId) {
        return Context.getCommandContext().getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId);
    }

    protected DecisionDefinitionEntity findLatestDecisionDefinitionById(String decisionDefinitionId) {
        return Context.getCommandContext().getDecisionDefinitionManager().findDecisionDefinitionById(decisionDefinitionId);
    }

    protected ExecutionEntity findExecutionById(String processInstanceId) {
        return Context.getCommandContext().getExecutionManager().findExecutionById(processInstanceId);
    }

    @Override
    public void checkTaskAssign(TaskEntity task) {
        String taskId = task.getId();
        String executionId = task.getExecutionId();
        if (executionId != null) {
            CompositePermissionCheck taskWorkPermission = new PermissionCheckBuilder().disjunctive().atomicCheckForResourceId(Resources.TASK, taskId, Permissions.TASK_ASSIGN).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, task.getProcessDefinition().getKey(), Permissions.TASK_ASSIGN).atomicCheckForResourceId(Resources.TASK, taskId, Permissions.UPDATE).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, task.getProcessDefinition().getKey(), Permissions.UPDATE_TASK).build();
            this.getAuthorizationManager().checkAuthorization(taskWorkPermission);
        } else {
            String caseExecutionId = task.getCaseExecutionId();
            if (caseExecutionId == null) {
                CompositePermissionCheck taskWorkPermission = new PermissionCheckBuilder().disjunctive().atomicCheckForResourceId(Resources.TASK, taskId, Permissions.TASK_ASSIGN).atomicCheckForResourceId(Resources.TASK, taskId, Permissions.UPDATE).build();
                this.getAuthorizationManager().checkAuthorization(taskWorkPermission);
            }
        }
    }

    @Override
    public void checkCreateTask(TaskEntity entity) {
        this.getAuthorizationManager().checkAuthorization(Permissions.CREATE, Resources.TASK);
    }

    @Override
    public void checkCreateTask() {
        this.getAuthorizationManager().checkAuthorization(Permissions.CREATE, Resources.TASK);
    }

    @Override
    public void checkTaskWork(TaskEntity task) {
        String taskId = task.getId();
        String executionId = task.getExecutionId();
        if (executionId != null) {
            CompositePermissionCheck taskWorkPermission = new PermissionCheckBuilder().disjunctive().atomicCheckForResourceId(Resources.TASK, taskId, Permissions.TASK_WORK).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, task.getProcessDefinition().getKey(), Permissions.TASK_WORK).atomicCheckForResourceId(Resources.TASK, taskId, Permissions.UPDATE).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, task.getProcessDefinition().getKey(), Permissions.UPDATE_TASK).build();
            this.getAuthorizationManager().checkAuthorization(taskWorkPermission);
        } else {
            String caseExecutionId = task.getCaseExecutionId();
            if (caseExecutionId == null) {
                CompositePermissionCheck taskWorkPermission = new PermissionCheckBuilder().disjunctive().atomicCheckForResourceId(Resources.TASK, taskId, Permissions.TASK_WORK).atomicCheckForResourceId(Resources.TASK, taskId, Permissions.UPDATE).build();
                this.getAuthorizationManager().checkAuthorization(taskWorkPermission);
            }
        }
    }

    @Override
    public void checkDeleteTask(TaskEntity task) {
        String taskId = task.getId();
        String executionId = task.getExecutionId();
        String caseExecutionId = task.getCaseExecutionId();
        if (executionId == null && caseExecutionId == null) {
            this.getAuthorizationManager().checkAuthorization(Permissions.DELETE, Resources.TASK, taskId);
        }
    }

    @Override
    public void checkDeleteUserOperationLog(UserOperationLogEntry entry) {
        String processDefinitionKey;
        if (entry != null && (processDefinitionKey = entry.getProcessDefinitionKey()) != null) {
            this.getAuthorizationManager().checkAuthorization(Permissions.DELETE_HISTORY, Resources.PROCESS_DEFINITION, processDefinitionKey);
        }
    }

    @Override
    public void checkReadHistoricExternalTaskLog(HistoricExternalTaskLogEntity historicExternalTaskLog) {
        if (historicExternalTaskLog.getProcessDefinitionKey() != null) {
            this.getAuthorizationManager().checkAuthorization(Permissions.READ_HISTORY, Resources.PROCESS_DEFINITION, historicExternalTaskLog.getProcessDefinitionKey());
        }
    }
}

