/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.application.AbstractProcessApplication;
import org.camunda.bpm.application.ProcessApplication;
import org.camunda.bpm.application.impl.metadata.ProcessesXmlParser;
import org.camunda.bpm.application.impl.metadata.spi.ProcessesXml;
import org.camunda.bpm.container.impl.ContainerIntegrationLogger;
import org.camunda.bpm.container.impl.spi.DeploymentOperation;
import org.camunda.bpm.container.impl.spi.DeploymentOperationStep;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.util.IoUtil;

public class ParseProcessesXmlStep
extends DeploymentOperationStep {
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;

    @Override
    public String getName() {
        return "Parse processes.xml deployment descriptor files.";
    }

    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        AbstractProcessApplication processApplication = (AbstractProcessApplication)operationContext.getAttachment("processApplication");
        Map<URL, ProcessesXml> parsedFiles = this.parseProcessesXmlFiles(processApplication);
        operationContext.addAttachment("processesXmlList", parsedFiles);
    }

    protected Map<URL, ProcessesXml> parseProcessesXmlFiles(AbstractProcessApplication processApplication) {
        String[] deploymentDescriptors = this.getDeploymentDescriptorLocations(processApplication);
        List<URL> processesXmlUrls = this.getProcessesXmlUrls(deploymentDescriptors, processApplication);
        HashMap<URL, ProcessesXml> parsedFiles = new HashMap<URL, ProcessesXml>();
        for (URL url : processesXmlUrls) {
            LOG.foundProcessesXmlFile(url.toString());
            if (this.isEmptyFile(url)) {
                parsedFiles.put(url, ProcessesXml.EMPTY_PROCESSES_XML);
                LOG.emptyProcessesXml();
                continue;
            }
            parsedFiles.put(url, this.parseProcessesXml(url));
        }
        if (parsedFiles.isEmpty()) {
            LOG.noProcessesXmlForPa(processApplication.getName());
        }
        return parsedFiles;
    }

    protected List<URL> getProcessesXmlUrls(String[] deploymentDescriptors, AbstractProcessApplication processApplication) {
        ClassLoader processApplicationClassloader = processApplication.getProcessApplicationClassloader();
        ArrayList<URL> result = new ArrayList<URL>();
        for (String deploymentDescriptor : deploymentDescriptors) {
            Enumeration<URL> processesXmlFileLocations = null;
            try {
                processesXmlFileLocations = processApplicationClassloader.getResources(deploymentDescriptor);
            }
            catch (IOException e) {
                throw LOG.exceptionWhileReadingProcessesXml(deploymentDescriptor, e);
            }
            while (processesXmlFileLocations.hasMoreElements()) {
                result.add(processesXmlFileLocations.nextElement());
            }
        }
        return result;
    }

    protected String[] getDeploymentDescriptorLocations(AbstractProcessApplication processApplication) {
        ProcessApplication annotation = processApplication.getClass().getAnnotation(ProcessApplication.class);
        if (annotation == null) {
            return new String[]{"META-INF/processes.xml"};
        }
        return annotation.deploymentDescriptors();
    }

    protected boolean isEmptyFile(URL url) {
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
            boolean bl = inputStream.available() == 0;
            return bl;
        }
        catch (IOException e) {
            throw LOG.exceptionWhileReadingProcessesXml(url.toString(), e);
        }
        finally {
            IoUtil.closeSilently(inputStream);
        }
    }

    protected ProcessesXml parseProcessesXml(URL url) {
        ProcessesXmlParser processesXmlParser = new ProcessesXmlParser();
        ProcessesXml processesXml = processesXmlParser.createParse().sourceUrl(url).execute().getProcessesXml();
        return processesXml;
    }
}

