/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime;

import java.util.Map;
import org.camunda.bpm.engine.impl.core.instance.CoreExecution;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.runtime.InstantiationStack;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;

public class ExecutionStartContext {
    protected boolean delayFireHistoricVariableEvents;
    protected InstantiationStack instantiationStack;
    protected Map<String, Object> variables;
    protected Map<String, Object> variablesLocal;

    public ExecutionStartContext() {
        this(true);
    }

    public ExecutionStartContext(boolean delayFireHistoricVariableEvents) {
        this.delayFireHistoricVariableEvents = delayFireHistoricVariableEvents;
    }

    public void executionStarted(PvmExecutionImpl execution) {
        if (execution instanceof ExecutionEntity && this.delayFireHistoricVariableEvents) {
            ExecutionEntity executionEntity = (ExecutionEntity)execution;
            executionEntity.fireHistoricVariableInstanceCreateEvents();
        }
        for (PvmExecutionImpl parent = execution; parent != null && parent.getExecutionStartContext() != null; parent = parent.getParent()) {
            parent.disposeExecutionStartContext();
        }
    }

    public void applyVariables(CoreExecution execution) {
        execution.setVariables(this.variables);
        execution.setVariablesLocal(this.variablesLocal);
    }

    public boolean isDelayFireHistoricVariableEvents() {
        return this.delayFireHistoricVariableEvents;
    }

    public InstantiationStack getInstantiationStack() {
        return this.instantiationStack;
    }

    public void setInstantiationStack(InstantiationStack instantiationStack) {
        this.instantiationStack = instantiationStack;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public void setVariablesLocal(Map<String, Object> variablesLocal) {
        this.variablesLocal = variablesLocal;
    }
}

