/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.persistence.AbstractHistoricManager;
import org.camunda.bpm.engine.impl.persistence.entity.AttachmentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.task.Attachment;

public class AttachmentManager
extends AbstractHistoricManager {
    public List<Attachment> findAttachmentsByProcessInstanceId(String processInstanceId) {
        this.checkHistoryEnabled();
        return this.getDbEntityManager().selectList("selectAttachmentsByProcessInstanceId", processInstanceId);
    }

    public List<Attachment> findAttachmentsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        return this.getDbEntityManager().selectList("selectAttachmentsByTaskId", taskId);
    }

    public void deleteAttachmentsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        List attachments = this.getDbEntityManager().selectList("selectAttachmentsByTaskId", taskId);
        for (AttachmentEntity attachment : attachments) {
            String contentId = attachment.getContentId();
            if (contentId != null) {
                this.getByteArrayManager().deleteByteArrayById(contentId);
            }
            this.getDbEntityManager().delete(attachment);
        }
    }

    public void deleteAttachmentsByProcessInstanceIds(List<String> processInstanceIds) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceIds", processInstanceIds);
        this.deleteAttachments(parameters);
    }

    public void deleteAttachmentsByTaskProcessInstanceIds(List<String> processInstanceIds) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("taskProcessInstanceIds", processInstanceIds);
        this.deleteAttachments(parameters);
    }

    public void deleteAttachmentsByTaskCaseInstanceIds(List<String> caseInstanceIds) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("caseInstanceIds", caseInstanceIds);
        this.deleteAttachments(parameters);
    }

    protected void deleteAttachments(Map<String, Object> parameters) {
        this.getDbEntityManager().deletePreserveOrder(ByteArrayEntity.class, "deleteAttachmentByteArraysByIds", parameters);
        this.getDbEntityManager().deletePreserveOrder(AttachmentEntity.class, "deleteAttachmentByIds", parameters);
    }

    public Attachment findAttachmentByTaskIdAndAttachmentId(String taskId, String attachmentId) {
        this.checkHistoryEnabled();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("taskId", taskId);
        parameters.put("id", attachmentId);
        return (AttachmentEntity)this.getDbEntityManager().selectOne("selectAttachmentByTaskIdAndAttachmentId", parameters);
    }
}

