/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.instance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventProcessor;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.migration.MigrationLogger;
import org.camunda.bpm.engine.impl.migration.instance.EmergingInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingCompensationEventSubscriptionInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingEventScopeInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingProcessElementInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingScopeInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingTransitionInstance;
import org.camunda.bpm.engine.impl.migration.instance.RemovingInstance;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.delegate.CompositeActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.delegate.MigrationObserverBehavior;
import org.camunda.bpm.engine.impl.pvm.delegate.ModificationObserverBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.migration.MigrationInstruction;
import org.camunda.bpm.engine.runtime.ActivityInstance;

public class MigratingActivityInstance
extends MigratingScopeInstance
implements MigratingInstance {
    public static final MigrationLogger MIGRATION_LOGGER = ProcessEngineLogger.MIGRATION_LOGGER;
    protected ActivityInstance activityInstance;
    protected ExecutionEntity representativeExecution;
    protected boolean activeState;
    protected List<RemovingInstance> removingDependentInstances = new ArrayList<RemovingInstance>();
    protected List<MigratingInstance> migratingDependentInstances = new ArrayList<MigratingInstance>();
    protected List<EmergingInstance> emergingDependentInstances = new ArrayList<EmergingInstance>();
    protected Set<MigratingActivityInstance> childActivityInstances = new HashSet<MigratingActivityInstance>();
    protected Set<MigratingTransitionInstance> childTransitionInstances = new HashSet<MigratingTransitionInstance>();
    protected Set<MigratingEventScopeInstance> childCompensationInstances = new HashSet<MigratingEventScopeInstance>();
    protected Set<MigratingCompensationEventSubscriptionInstance> childCompensationSubscriptionInstances = new HashSet<MigratingCompensationEventSubscriptionInstance>();
    protected MigratingActivityInstanceBehavior instanceBehavior;

    public MigratingActivityInstance(ActivityInstance activityInstance, MigrationInstruction migrationInstruction, ScopeImpl sourceScope, ScopeImpl targetScope, ExecutionEntity scopeExecution) {
        this.activityInstance = activityInstance;
        this.migrationInstruction = migrationInstruction;
        this.sourceScope = sourceScope;
        this.currentScope = sourceScope;
        this.targetScope = targetScope;
        this.representativeExecution = scopeExecution;
        this.instanceBehavior = this.determineBehavior(sourceScope);
        if (activityInstance.getChildActivityInstances().length == 0 && activityInstance.getChildTransitionInstances().length == 0) {
            this.activeState = this.representativeExecution.isActive();
        }
    }

    public MigratingActivityInstance(ScopeImpl targetScope, ExecutionEntity scopeExecution) {
        this.targetScope = targetScope;
        this.currentScope = targetScope;
        this.representativeExecution = scopeExecution;
        this.instanceBehavior = this.determineBehavior(targetScope);
    }

    protected MigratingActivityInstanceBehavior determineBehavior(ScopeImpl scope) {
        if (scope.isScope()) {
            return new MigratingScopeActivityInstanceBehavior();
        }
        return new MigratingNonScopeActivityInstanceBehavior();
    }

    @Override
    public void detachChildren() {
        HashSet<MigratingActivityInstance> childrenCopy = new HashSet<MigratingActivityInstance>(this.childActivityInstances);
        for (MigratingActivityInstance child : childrenCopy) {
            child.detachDependentInstances();
        }
        for (MigratingActivityInstance child : childrenCopy) {
            child.detachState();
        }
        HashSet<MigratingTransitionInstance> transitionChildrenCopy = new HashSet<MigratingTransitionInstance>(this.childTransitionInstances);
        for (MigratingTransitionInstance child : transitionChildrenCopy) {
            child.detachState();
        }
        HashSet<MigratingEventScopeInstance> compensationChildrenCopy = new HashSet<MigratingEventScopeInstance>(this.childCompensationInstances);
        for (MigratingEventScopeInstance child : compensationChildrenCopy) {
            child.detachState();
        }
        HashSet<MigratingCompensationEventSubscriptionInstance> compensationSubscriptionsChildrenCopy = new HashSet<MigratingCompensationEventSubscriptionInstance>(this.childCompensationSubscriptionInstances);
        for (MigratingCompensationEventSubscriptionInstance child : compensationSubscriptionsChildrenCopy) {
            child.detachState();
        }
    }

    public void detachDependentInstances() {
        for (MigratingInstance dependentInstance : this.migratingDependentInstances) {
            if (dependentInstance.isDetached()) continue;
            dependentInstance.detachState();
        }
    }

    @Override
    public boolean isDetached() {
        return this.instanceBehavior.isDetached();
    }

    @Override
    public void detachState() {
        this.detachDependentInstances();
        this.instanceBehavior.detachState();
        this.setParent(null);
    }

    @Override
    public void attachState(MigratingScopeInstance activityInstance) {
        this.setParent(activityInstance);
        this.instanceBehavior.attachState();
        for (MigratingInstance dependentInstance : this.migratingDependentInstances) {
            dependentInstance.attachState(this);
        }
    }

    @Override
    public void attachState(MigratingTransitionInstance targetTransitionInstance) {
        throw MIGRATION_LOGGER.cannotAttachToTransitionInstance(this);
    }

    @Override
    public void migrateDependentEntities() {
        for (MigratingInstance migratingInstance : this.migratingDependentInstances) {
            migratingInstance.migrateState();
            migratingInstance.migrateDependentEntities();
        }
        ExecutionEntity representativeExecution = this.resolveRepresentativeExecution();
        for (EmergingInstance emergingInstance : this.emergingDependentInstances) {
            emergingInstance.create(representativeExecution);
        }
    }

    @Override
    public ExecutionEntity resolveRepresentativeExecution() {
        return this.instanceBehavior.resolveRepresentativeExecution();
    }

    @Override
    public void addMigratingDependentInstance(MigratingInstance migratingInstance) {
        this.migratingDependentInstances.add(migratingInstance);
    }

    public List<MigratingInstance> getMigratingDependentInstances() {
        return this.migratingDependentInstances;
    }

    public void addRemovingDependentInstance(RemovingInstance removingInstance) {
        this.removingDependentInstances.add(removingInstance);
    }

    public void addEmergingDependentInstance(EmergingInstance emergingInstance) {
        this.emergingDependentInstances.add(emergingInstance);
    }

    public void addChild(MigratingTransitionInstance transitionInstance) {
        this.childTransitionInstances.add(transitionInstance);
    }

    public void removeChild(MigratingTransitionInstance transitionInstance) {
        this.childTransitionInstances.remove(transitionInstance);
    }

    public void addChild(MigratingActivityInstance activityInstance) {
        this.childActivityInstances.add(activityInstance);
    }

    public void removeChild(MigratingActivityInstance activityInstance) {
        this.childActivityInstances.remove(activityInstance);
    }

    @Override
    public void addChild(MigratingScopeInstance migratingActivityInstance) {
        if (migratingActivityInstance instanceof MigratingActivityInstance) {
            this.addChild((MigratingActivityInstance)migratingActivityInstance);
        } else if (migratingActivityInstance instanceof MigratingEventScopeInstance) {
            this.addChild((MigratingEventScopeInstance)migratingActivityInstance);
        } else {
            throw MIGRATION_LOGGER.cannotHandleChild(this, migratingActivityInstance);
        }
    }

    @Override
    public void removeChild(MigratingScopeInstance child) {
        if (child instanceof MigratingActivityInstance) {
            this.removeChild((MigratingActivityInstance)child);
        } else if (child instanceof MigratingEventScopeInstance) {
            this.removeChild((MigratingEventScopeInstance)child);
        } else {
            throw MIGRATION_LOGGER.cannotHandleChild(this, child);
        }
    }

    public void addChild(MigratingEventScopeInstance compensationInstance) {
        this.childCompensationInstances.add(compensationInstance);
    }

    public void removeChild(MigratingEventScopeInstance compensationInstance) {
        this.childCompensationInstances.remove(compensationInstance);
    }

    @Override
    public void addChild(MigratingCompensationEventSubscriptionInstance migratingEventSubscription) {
        this.childCompensationSubscriptionInstances.add(migratingEventSubscription);
    }

    @Override
    public void removeChild(MigratingCompensationEventSubscriptionInstance migratingEventSubscription) {
        this.childCompensationSubscriptionInstances.remove(migratingEventSubscription);
    }

    public ActivityInstance getActivityInstance() {
        return this.activityInstance;
    }

    public String getActivityInstanceId() {
        if (this.activityInstance != null) {
            return this.activityInstance.getId();
        }
        ExecutionEntity execution = this.resolveRepresentativeExecution();
        return execution.getParentActivityInstanceId();
    }

    @Override
    public MigratingActivityInstance getParent() {
        return (MigratingActivityInstance)super.getParent();
    }

    public Set<MigratingProcessElementInstance> getChildren() {
        HashSet<MigratingProcessElementInstance> childInstances = new HashSet<MigratingProcessElementInstance>();
        childInstances.addAll(this.childActivityInstances);
        childInstances.addAll(this.childTransitionInstances);
        childInstances.addAll(this.childCompensationInstances);
        childInstances.addAll(this.childCompensationSubscriptionInstances);
        return childInstances;
    }

    @Override
    public Collection<MigratingScopeInstance> getChildScopeInstances() {
        HashSet<MigratingScopeInstance> childInstances = new HashSet<MigratingScopeInstance>();
        childInstances.addAll(this.childActivityInstances);
        childInstances.addAll(this.childCompensationInstances);
        return childInstances;
    }

    public Set<MigratingActivityInstance> getChildActivityInstances() {
        return this.childActivityInstances;
    }

    public Set<MigratingTransitionInstance> getChildTransitionInstances() {
        return this.childTransitionInstances;
    }

    public Set<MigratingEventScopeInstance> getChildCompensationInstances() {
        return this.childCompensationInstances;
    }

    @Override
    public boolean migrates() {
        return this.targetScope != null;
    }

    @Override
    public void removeUnmappedDependentInstances() {
        for (RemovingInstance removingInstance : this.removingDependentInstances) {
            removingInstance.remove();
        }
    }

    @Override
    public void remove(boolean skipCustomListeners, boolean skipIoMappings) {
        this.instanceBehavior.remove(skipCustomListeners, skipIoMappings);
    }

    @Override
    public void migrateState() {
        this.instanceBehavior.migrateState();
    }

    protected void migrateHistory(DelegateExecution execution) {
        if (this.activityInstance.getId().equals(this.activityInstance.getProcessInstanceId())) {
            this.migrateProcessInstanceHistory(execution);
        } else {
            this.migrateActivityInstanceHistory(execution);
        }
    }

    protected void migrateProcessInstanceHistory(final DelegateExecution execution) {
        HistoryLevel historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        if (!historyLevel.isHistoryEventProduced(HistoryEventTypes.PROCESS_INSTANCE_MIGRATE, this)) {
            return;
        }
        HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

            @Override
            public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                return producer.createProcessInstanceUpdateEvt(execution);
            }
        });
    }

    protected void migrateActivityInstanceHistory(DelegateExecution execution) {
        HistoryLevel historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        if (!historyLevel.isHistoryEventProduced(HistoryEventTypes.ACTIVITY_INSTANCE_MIGRATE, this)) {
            return;
        }
        HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

            @Override
            public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                return producer.createActivityInstanceMigrateEvt(MigratingActivityInstance.this);
            }
        });
    }

    public ExecutionEntity createAttachableExecution() {
        return this.instanceBehavior.createAttachableExecution();
    }

    public void destroyAttachableExecution(ExecutionEntity execution) {
        this.instanceBehavior.destroyAttachableExecution(execution);
    }

    @Override
    public void setParent(MigratingScopeInstance parentInstance) {
        if (this.parentInstance != null) {
            this.parentInstance.removeChild(this);
        }
        this.parentInstance = parentInstance;
        if (parentInstance != null) {
            parentInstance.addChild(this);
        }
    }

    protected class MigratingScopeActivityInstanceBehavior
    implements MigratingActivityInstanceBehavior {
        protected MigratingScopeActivityInstanceBehavior() {
        }

        @Override
        public boolean isDetached() {
            ExecutionEntity representativeExecution = this.resolveRepresentativeExecution();
            return representativeExecution != representativeExecution.getProcessInstance() && representativeExecution.getParent() == null;
        }

        @Override
        public void detachState() {
            ExecutionEntity currentScopeExecution = this.resolveRepresentativeExecution();
            ExecutionEntity parentExecution = currentScopeExecution.getParent();
            currentScopeExecution.setParent(null);
            if (MigratingActivityInstance.this.sourceScope.getActivityBehavior() instanceof CompositeActivityBehavior) {
                parentExecution.leaveActivityInstance();
            }
            MigratingActivityInstance.this.getParent().destroyAttachableExecution(parentExecution);
        }

        @Override
        public void attachState() {
            ExecutionEntity newParentExecution = MigratingActivityInstance.this.getParent().createAttachableExecution();
            ExecutionEntity currentScopeExecution = this.resolveRepresentativeExecution();
            currentScopeExecution.setParent(newParentExecution);
            if (MigratingActivityInstance.this.sourceScope.getActivityBehavior() instanceof CompositeActivityBehavior) {
                newParentExecution.setActivityInstanceId(MigratingActivityInstance.this.activityInstance.getId());
            }
        }

        @Override
        public void migrateState() {
            ExecutionEntity currentScopeExecution = this.resolveRepresentativeExecution();
            currentScopeExecution.setProcessDefinition(MigratingActivityInstance.this.targetScope.getProcessDefinition());
            ExecutionEntity parentExecution = currentScopeExecution.getParent();
            if (parentExecution != null && parentExecution.isConcurrent()) {
                parentExecution.setProcessDefinition(MigratingActivityInstance.this.targetScope.getProcessDefinition());
            }
            MigratingActivityInstance.this.currentScope = MigratingActivityInstance.this.targetScope;
            if (!MigratingActivityInstance.this.targetScope.isScope()) {
                this.becomeNonScope();
                currentScopeExecution = this.resolveRepresentativeExecution();
            }
            if (this.isLeafActivity(MigratingActivityInstance.this.targetScope)) {
                currentScopeExecution.setActivity((PvmActivity)((Object)MigratingActivityInstance.this.targetScope));
            }
            if (MigratingActivityInstance.this.sourceScope.getActivityBehavior() instanceof MigrationObserverBehavior) {
                ((MigrationObserverBehavior)((Object)MigratingActivityInstance.this.sourceScope.getActivityBehavior())).migrateScope(currentScopeExecution);
            }
            MigratingActivityInstance.this.migrateHistory(currentScopeExecution);
        }

        protected void becomeNonScope() {
            for (MigratingInstance dependentInstance : MigratingActivityInstance.this.migratingDependentInstances) {
                dependentInstance.detachState();
            }
            ExecutionEntity parentExecution = MigratingActivityInstance.this.representativeExecution.getParent();
            parentExecution.setActivity(MigratingActivityInstance.this.representativeExecution.getActivity());
            parentExecution.setActivityInstanceId(MigratingActivityInstance.this.representativeExecution.getActivityInstanceId());
            MigratingActivityInstance.this.representativeExecution.remove();
            MigratingActivityInstance.this.representativeExecution = parentExecution;
            for (MigratingInstance dependentInstance : MigratingActivityInstance.this.migratingDependentInstances) {
                dependentInstance.attachState(MigratingActivityInstance.this);
            }
            MigratingActivityInstance.this.instanceBehavior = new MigratingNonScopeActivityInstanceBehavior();
        }

        protected boolean isLeafActivity(ScopeImpl scope) {
            return scope.getActivities().isEmpty();
        }

        @Override
        public ExecutionEntity resolveRepresentativeExecution() {
            return MigratingActivityInstance.this.representativeExecution;
        }

        @Override
        public void remove(boolean skipCustomListeners, boolean skipIoMappings) {
            ExecutionEntity currentExecution = this.resolveRepresentativeExecution();
            ExecutionEntity parentExecution = currentExecution.getParent();
            currentExecution.setActivity((PvmActivity)((Object)MigratingActivityInstance.this.sourceScope));
            currentExecution.setActivityInstanceId(MigratingActivityInstance.this.activityInstance.getId());
            currentExecution.deleteCascade("migration", skipCustomListeners, skipIoMappings);
            MigratingActivityInstance.this.getParent().destroyAttachableExecution(parentExecution);
            MigratingActivityInstance.this.setParent(null);
            for (MigratingTransitionInstance migratingTransitionInstance : MigratingActivityInstance.this.childTransitionInstances) {
                migratingTransitionInstance.setParent(null);
            }
            for (MigratingActivityInstance migratingActivityInstance : MigratingActivityInstance.this.childActivityInstances) {
                migratingActivityInstance.setParent(null);
            }
            for (MigratingEventScopeInstance migratingEventScopeInstance : MigratingActivityInstance.this.childCompensationInstances) {
                migratingEventScopeInstance.setParent(null);
            }
        }

        @Override
        public ExecutionEntity createAttachableExecution() {
            ExecutionEntity scopeExecution;
            ExecutionEntity attachableExecution = scopeExecution = this.resolveRepresentativeExecution();
            if (MigratingActivityInstance.this.currentScope.getActivityBehavior() instanceof ModificationObserverBehavior) {
                ModificationObserverBehavior behavior = (ModificationObserverBehavior)MigratingActivityInstance.this.currentScope.getActivityBehavior();
                attachableExecution = (ExecutionEntity)behavior.createInnerInstance(scopeExecution);
            } else if (!scopeExecution.getNonEventScopeExecutions().isEmpty() || scopeExecution.getActivity() != null) {
                attachableExecution = (ExecutionEntity)scopeExecution.createConcurrentExecution();
                attachableExecution.setActive(false);
                scopeExecution.forceUpdate();
            }
            return attachableExecution;
        }

        @Override
        public void destroyAttachableExecution(ExecutionEntity execution) {
            if (MigratingActivityInstance.this.currentScope.getActivityBehavior() instanceof ModificationObserverBehavior) {
                ModificationObserverBehavior behavior = (ModificationObserverBehavior)MigratingActivityInstance.this.currentScope.getActivityBehavior();
                behavior.destroyInnerInstance(execution);
            } else if (execution.isConcurrent()) {
                execution.remove();
                execution.getParent().tryPruneLastConcurrentChild();
                execution.getParent().forceUpdate();
            }
        }
    }

    protected class MigratingNonScopeActivityInstanceBehavior
    implements MigratingActivityInstanceBehavior {
        protected MigratingNonScopeActivityInstanceBehavior() {
        }

        @Override
        public boolean isDetached() {
            return this.resolveRepresentativeExecution().getActivity() == null;
        }

        @Override
        public void detachState() {
            ExecutionEntity currentExecution = this.resolveRepresentativeExecution();
            currentExecution.setActivity(null);
            currentExecution.leaveActivityInstance();
            currentExecution.setActive(false);
            MigratingActivityInstance.this.getParent().destroyAttachableExecution(currentExecution);
        }

        @Override
        public void attachState() {
            MigratingActivityInstance.this.representativeExecution = MigratingActivityInstance.this.getParent().createAttachableExecution();
            MigratingActivityInstance.this.representativeExecution.setActivity((PvmActivity)((Object)MigratingActivityInstance.this.sourceScope));
            MigratingActivityInstance.this.representativeExecution.setActivityInstanceId(MigratingActivityInstance.this.activityInstance.getId());
            MigratingActivityInstance.this.representativeExecution.setActive(MigratingActivityInstance.this.activeState);
        }

        @Override
        public void migrateState() {
            ExecutionEntity currentExecution = this.resolveRepresentativeExecution();
            currentExecution.setProcessDefinition(MigratingActivityInstance.this.targetScope.getProcessDefinition());
            currentExecution.setActivity((PvmActivity)((Object)MigratingActivityInstance.this.targetScope));
            MigratingActivityInstance.this.currentScope = MigratingActivityInstance.this.targetScope;
            if (MigratingActivityInstance.this.targetScope.isScope()) {
                this.becomeScope();
            }
            MigratingActivityInstance.this.migrateHistory(currentExecution);
        }

        protected void becomeScope() {
            for (MigratingInstance dependentInstance : MigratingActivityInstance.this.migratingDependentInstances) {
                dependentInstance.detachState();
            }
            ExecutionEntity currentExecution = this.resolveRepresentativeExecution();
            currentExecution = currentExecution.createExecution();
            ExecutionEntity parent = currentExecution.getParent();
            parent.setActivity(null);
            if (!parent.isConcurrent()) {
                parent.leaveActivityInstance();
            }
            MigratingActivityInstance.this.representativeExecution = currentExecution;
            for (MigratingInstance dependentInstance : MigratingActivityInstance.this.migratingDependentInstances) {
                dependentInstance.attachState(MigratingActivityInstance.this);
            }
            MigratingActivityInstance.this.instanceBehavior = new MigratingScopeActivityInstanceBehavior();
        }

        @Override
        public ExecutionEntity resolveRepresentativeExecution() {
            if (MigratingActivityInstance.this.representativeExecution.getReplacedBy() != null) {
                return MigratingActivityInstance.this.representativeExecution.resolveReplacedBy();
            }
            return MigratingActivityInstance.this.representativeExecution;
        }

        @Override
        public void remove(boolean skipCustomListeners, boolean skipIoMappings) {
        }

        @Override
        public ExecutionEntity createAttachableExecution() {
            throw MIGRATION_LOGGER.cannotBecomeSubordinateInNonScope(MigratingActivityInstance.this);
        }

        @Override
        public void destroyAttachableExecution(ExecutionEntity execution) {
            throw MIGRATION_LOGGER.cannotDestroySubordinateInNonScope(MigratingActivityInstance.this);
        }
    }

    protected static interface MigratingActivityInstanceBehavior {
        public boolean isDetached();

        public void detachState();

        public void attachState();

        public void migrateState();

        public void remove(boolean var1, boolean var2);

        public ExecutionEntity resolveRepresentativeExecution();

        public ExecutionEntity createAttachableExecution();

        public void destroyAttachableExecution(ExecutionEntity var1);
    }
}

