/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmd.AbstractSetProcessDefinitionStateCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandler;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandlerConfiguration;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.repository.UpdateProcessDefinitionSuspensionStateBuilderImpl;
import org.camunda.bpm.engine.impl.util.json.JSONObject;

public abstract class TimerChangeProcessDefinitionSuspensionStateJobHandler
implements JobHandler<ProcessDefinitionSuspensionStateConfiguration> {
    protected static final String JOB_HANDLER_CFG_BY = "by";
    protected static final String JOB_HANDLER_CFG_PROCESS_DEFINITION_ID = "processDefinitionId";
    protected static final String JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    protected static final String JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID = "processDefinitionTenantId";
    protected static final String JOB_HANDLER_CFG_INCLUDE_PROCESS_INSTANCES = "includeProcessInstances";

    @Override
    public void execute(ProcessDefinitionSuspensionStateConfiguration configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        AbstractSetProcessDefinitionStateCmd cmd = this.getCommand(configuration);
        cmd.disableLogUserOperation();
        cmd.execute(commandContext);
    }

    protected abstract AbstractSetProcessDefinitionStateCmd getCommand(ProcessDefinitionSuspensionStateConfiguration var1);

    @Override
    public ProcessDefinitionSuspensionStateConfiguration newConfiguration(String canonicalString) {
        JSONObject jsonObject = new JSONObject(canonicalString);
        return ProcessDefinitionSuspensionStateConfiguration.fromJson(jsonObject);
    }

    @Override
    public void onDelete(ProcessDefinitionSuspensionStateConfiguration configuration, JobEntity jobEntity) {
    }

    public static class ProcessDefinitionSuspensionStateConfiguration
    implements JobHandlerConfiguration {
        protected String processDefinitionKey;
        protected String processDefinitionId;
        protected boolean includeProcessInstances;
        protected String tenantId;
        protected boolean isTenantIdSet;
        protected String by;

        @Override
        public String toCanonicalString() {
            JSONObject json = new JSONObject();
            json.put(TimerChangeProcessDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_BY, this.by);
            json.put(TimerChangeProcessDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY, this.processDefinitionKey);
            json.put(TimerChangeProcessDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_INCLUDE_PROCESS_INSTANCES, this.includeProcessInstances);
            json.put(TimerChangeProcessDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_ID, this.processDefinitionId);
            if (this.isTenantIdSet) {
                if (this.tenantId != null) {
                    json.put(TimerChangeProcessDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID, this.tenantId);
                } else {
                    json.put(TimerChangeProcessDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID, JSONObject.NULL);
                }
            }
            return json.toString();
        }

        public UpdateProcessDefinitionSuspensionStateBuilderImpl createBuilder() {
            UpdateProcessDefinitionSuspensionStateBuilderImpl builder = new UpdateProcessDefinitionSuspensionStateBuilderImpl();
            if (this.by.equals(TimerChangeProcessDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_ID)) {
                builder.byProcessDefinitionId(this.processDefinitionId);
            } else if (this.by.equals(TimerChangeProcessDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY)) {
                builder.byProcessDefinitionKey(this.processDefinitionKey);
                if (this.isTenantIdSet) {
                    if (this.tenantId != null) {
                        builder.processDefinitionTenantId(this.tenantId);
                    } else {
                        builder.processDefinitionWithoutTenantId();
                    }
                }
            } else {
                throw new ProcessEngineException("Unexpected job handler configuration for property 'by': " + this.by);
            }
            builder.includeProcessInstances(this.includeProcessInstances);
            return builder;
        }

        public static ProcessDefinitionSuspensionStateConfiguration fromJson(JSONObject jsonObject) {
            ProcessDefinitionSuspensionStateConfiguration config = new ProcessDefinitionSuspensionStateConfiguration();
            config.by = jsonObject.getString(TimerChangeProcessDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_BY);
            if (jsonObject.has(TimerChangeProcessDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_ID)) {
                config.processDefinitionId = jsonObject.getString(TimerChangeProcessDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_ID);
            }
            if (jsonObject.has(TimerChangeProcessDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY)) {
                config.processDefinitionKey = jsonObject.getString(TimerChangeProcessDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY);
            }
            if (jsonObject.has(TimerChangeProcessDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID)) {
                config.isTenantIdSet = true;
                if (!jsonObject.isNull(TimerChangeProcessDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID)) {
                    config.tenantId = jsonObject.getString(TimerChangeProcessDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID);
                }
            }
            if (jsonObject.has(TimerChangeProcessDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_INCLUDE_PROCESS_INSTANCES)) {
                config.includeProcessInstances = jsonObject.getBoolean(TimerChangeProcessDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_INCLUDE_PROCESS_INSTANCES);
            }
            return config;
        }

        public static ProcessDefinitionSuspensionStateConfiguration byProcessDefinitionId(String processDefinitionId, boolean includeProcessInstances) {
            ProcessDefinitionSuspensionStateConfiguration configuration = new ProcessDefinitionSuspensionStateConfiguration();
            configuration.by = TimerChangeProcessDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_ID;
            configuration.processDefinitionId = processDefinitionId;
            configuration.includeProcessInstances = includeProcessInstances;
            return configuration;
        }

        public static ProcessDefinitionSuspensionStateConfiguration byProcessDefinitionKey(String processDefinitionKey, boolean includeProcessInstances) {
            ProcessDefinitionSuspensionStateConfiguration configuration = new ProcessDefinitionSuspensionStateConfiguration();
            configuration.by = TimerChangeProcessDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY;
            configuration.processDefinitionKey = processDefinitionKey;
            configuration.includeProcessInstances = includeProcessInstances;
            return configuration;
        }

        public static ProcessDefinitionSuspensionStateConfiguration byProcessDefinitionKeyAndTenantId(String processDefinitionKey, String tenantId, boolean includeProcessInstances) {
            ProcessDefinitionSuspensionStateConfiguration configuration = ProcessDefinitionSuspensionStateConfiguration.byProcessDefinitionKey(processDefinitionKey, includeProcessInstances);
            configuration.isTenantIdSet = true;
            configuration.tenantId = tenantId;
            return configuration;
        }
    }
}

