/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class UpdateCaseDefinitionHistoryTimeToLiveCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String caseDefinitionId;
    protected Integer historyTimeToLive;

    public UpdateCaseDefinitionHistoryTimeToLiveCmd(String caseDefinitionId, Integer historyTimeToLive) {
        this.caseDefinitionId = caseDefinitionId;
        this.historyTimeToLive = historyTimeToLive;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "caseDefinitionId", (Object)this.caseDefinitionId);
        if (this.historyTimeToLive != null) {
            EnsureUtil.ensureGreaterThanOrEqual(BadUserRequestException.class, "", "historyTimeToLive", this.historyTimeToLive.intValue(), 0L);
        }
        CaseDefinitionEntity caseDefinitionEntity = commandContext.getCaseDefinitionManager().findLatestDefinitionById(this.caseDefinitionId);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateCaseDefinition(caseDefinitionEntity);
        }
        caseDefinitionEntity.setHistoryTimeToLive(this.historyTimeToLive);
        return null;
    }
}

