/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch.deletion;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.impl.batch.deletion.DeleteProcessInstanceBatchConfiguration;
import org.camunda.bpm.engine.impl.json.JsonObjectConverter;
import org.camunda.bpm.engine.impl.util.JsonUtil;
import org.camunda.bpm.engine.impl.util.json.JSONObject;

public class DeleteProcessInstanceBatchConfigurationJsonConverter
extends JsonObjectConverter<DeleteProcessInstanceBatchConfiguration> {
    public static final DeleteProcessInstanceBatchConfigurationJsonConverter INSTANCE = new DeleteProcessInstanceBatchConfigurationJsonConverter();
    public static final String DELETE_REASON = "deleteReason";
    public static final String PROCESS_INSTANCE_IDS = "processInstanceIds";
    public static final String SKIP_CUSTOM_LISTENERS = "skipCustomListeners";

    @Override
    public JSONObject toJsonObject(DeleteProcessInstanceBatchConfiguration configuration) {
        JSONObject json = new JSONObject();
        JsonUtil.addField(json, DELETE_REASON, configuration.getDeleteReason());
        JsonUtil.addListField(json, PROCESS_INSTANCE_IDS, configuration.getIds());
        JsonUtil.addField(json, SKIP_CUSTOM_LISTENERS, configuration.isSkipCustomListeners());
        return json;
    }

    @Override
    public DeleteProcessInstanceBatchConfiguration toObject(JSONObject json) {
        DeleteProcessInstanceBatchConfiguration configuration = new DeleteProcessInstanceBatchConfiguration(this.readProcessInstanceIds(json), json.optBoolean(SKIP_CUSTOM_LISTENERS));
        String deleteReason = json.optString(DELETE_REASON);
        if (deleteReason != null && !deleteReason.isEmpty()) {
            configuration.setDeleteReason(deleteReason);
        }
        return configuration;
    }

    protected List<String> readProcessInstanceIds(JSONObject jsonObject) {
        List<Object> objects = JsonUtil.jsonArrayAsList(jsonObject.getJSONArray(PROCESS_INSTANCE_IDS));
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        for (Object object : objects) {
            processInstanceIds.add((String)object);
        }
        return processInstanceIds;
    }
}

