/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.scripting.engine;

import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;

public class ScriptEngineResolver {
    protected final ScriptEngineManager scriptEngineManager;
    protected Map<String, ScriptEngine> cachedEngines = new HashMap<String, ScriptEngine>();

    public ScriptEngineResolver(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
    }

    public void addScriptEngineFactory(ScriptEngineFactory scriptEngineFactory) {
        this.scriptEngineManager.registerEngineName(scriptEngineFactory.getEngineName(), scriptEngineFactory);
    }

    public ScriptEngineManager getScriptEngineManager() {
        return this.scriptEngineManager;
    }

    public ScriptEngine getScriptEngine(String language, boolean resolveFromCache) {
        ScriptEngine scriptEngine = null;
        if (resolveFromCache) {
            scriptEngine = this.cachedEngines.get(language);
            if (scriptEngine == null && (scriptEngine = this.scriptEngineManager.getEngineByName(language)) != null) {
                if ("groovy".equals(language)) {
                    this.configureGroovyScriptEngine(scriptEngine);
                }
                if (this.isCachable(scriptEngine)) {
                    this.cachedEngines.put(language, scriptEngine);
                }
            }
        } else {
            scriptEngine = this.scriptEngineManager.getEngineByName(language);
        }
        return scriptEngine;
    }

    protected boolean isCachable(ScriptEngine scriptEngine) {
        Object threadingParameter = scriptEngine.getFactory().getParameter("THREADING");
        return threadingParameter != null;
    }

    protected void configureGroovyScriptEngine(ScriptEngine scriptEngine) {
        scriptEngine.getContext().setAttribute("#jsr223.groovy.engine.keep.globals", "weak", 100);
    }
}

