/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor.historycleanup;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupBatch;

public abstract class HistoryCleanupHelper {
    private static final SimpleDateFormat TIME_FORMAT_WITHOUT_SECONDS = new SimpleDateFormat("HH:mm");
    public static final SimpleDateFormat TIME_FORMAT_WITHOUT_SECONDS_WITH_TIMEZONE = new SimpleDateFormat("HH:mmZ");

    public static Date getNextRunWithinBatchWindow(Date date, CommandContext commandContext) {
        return HistoryCleanupHelper.getNextRunWithinBatchWindow(date, HistoryCleanupHelper.getBatchWindowStartTime(commandContext));
    }

    public static Date getNextRunWithinBatchWindow(Date date, Date batchWindowStartTime) {
        if (batchWindowStartTime != null) {
            Date todayPossibleRun = HistoryCleanupHelper.updateTime(date, batchWindowStartTime);
            if (todayPossibleRun.after(date)) {
                return todayPossibleRun;
            }
            return HistoryCleanupHelper.addDays(todayPossibleRun, 1);
        }
        throw new ProcessEngineException("Batch window must be configured");
    }

    public static Date getBatchWindowStartTime(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().getHistoryCleanupBatchWindowStartTimeAsDate();
    }

    public static Date getBatchWindowEndTime(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().getHistoryCleanupBatchWindowEndTimeAsDate();
    }

    public static boolean isBatchWindowConfigured(CommandContext commandContext) {
        return HistoryCleanupHelper.getBatchWindowStartTime(commandContext) != null;
    }

    public static boolean isWithinBatchWindow(Date date, CommandContext commandContext) {
        if (HistoryCleanupHelper.isBatchWindowConfigured(commandContext)) {
            Date todaysBatchWindowStartTime = HistoryCleanupHelper.updateTime(date, HistoryCleanupHelper.getBatchWindowStartTime(commandContext));
            Date todaysBatchWindowEndTime = HistoryCleanupHelper.updateTime(date, HistoryCleanupHelper.getBatchWindowEndTime(commandContext));
            if (todaysBatchWindowEndTime.after(todaysBatchWindowStartTime)) {
                return (date.after(todaysBatchWindowStartTime) || date.equals(todaysBatchWindowStartTime)) && date.before(todaysBatchWindowEndTime);
            }
            return date.after(todaysBatchWindowStartTime) || date.equals(todaysBatchWindowStartTime) || date.before(todaysBatchWindowEndTime);
        }
        return false;
    }

    private static Date updateTime(Date now, Date newTime) {
        Calendar c = Calendar.getInstance();
        c.setTime(now);
        Calendar newTimeCalendar = Calendar.getInstance();
        newTimeCalendar.setTime(newTime);
        c.set(11, newTimeCalendar.get(11));
        c.set(12, newTimeCalendar.get(12));
        c.set(13, newTimeCalendar.get(13));
        c.set(14, newTimeCalendar.get(14));
        return c.getTime();
    }

    private static Date addDays(Date date, int amount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, amount);
        return c.getTime();
    }

    public static Date parseTimeConfiguration(String time) throws ParseException {
        try {
            return TIME_FORMAT_WITHOUT_SECONDS_WITH_TIMEZONE.parse(time);
        }
        catch (ParseException ex) {
            return TIME_FORMAT_WITHOUT_SECONDS.parse(time);
        }
    }

    private static Integer getHistoryCleanupBatchSize(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().getHistoryCleanupBatchSize();
    }

    public static HistoryCleanupBatch getNextBatch(CommandContext commandContext) {
        List<String> historicCaseInstanceIds;
        List<String> historicDecisionInstanceIds;
        Integer batchSize = HistoryCleanupHelper.getHistoryCleanupBatchSize(commandContext);
        HistoryCleanupBatch historyCleanupBatch = new HistoryCleanupBatch();
        List<String> historicProcessInstanceIds = commandContext.getHistoricProcessInstanceManager().findHistoricProcessInstanceIdsForCleanup(batchSize);
        if (historicProcessInstanceIds.size() > 0) {
            historyCleanupBatch.setHistoricProcessInstanceIds(historicProcessInstanceIds);
        }
        if (historyCleanupBatch.size() < batchSize && commandContext.getProcessEngineConfiguration().isDmnEnabled() && (historicDecisionInstanceIds = commandContext.getHistoricDecisionInstanceManager().findHistoricDecisionInstanceIdsForCleanup(batchSize - historyCleanupBatch.size())).size() > 0) {
            historyCleanupBatch.setHistoricDecisionInstanceIds(historicDecisionInstanceIds);
        }
        if (historyCleanupBatch.size() < batchSize && commandContext.getProcessEngineConfiguration().isCmmnEnabled() && (historicCaseInstanceIds = commandContext.getHistoricCaseInstanceManager().findHistoricCaseInstanceIdsForCleanup(batchSize - historyCleanupBatch.size())).size() > 0) {
            historyCleanupBatch.setHistoricCaseInstanceIds(historicCaseInstanceIds);
        }
        return historyCleanupBatch;
    }
}

