/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.dmn.transformer;

import org.camunda.bpm.dmn.engine.impl.DmnDecisionImpl;
import org.camunda.bpm.dmn.engine.impl.spi.transform.DmnElementTransformContext;
import org.camunda.bpm.dmn.engine.impl.transform.DmnDecisionTransformHandler;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.model.dmn.instance.Decision;

public class DecisionDefinitionHandler
extends DmnDecisionTransformHandler {
    protected DmnDecisionImpl createDmnElement() {
        return new DecisionDefinitionEntity();
    }

    protected DmnDecisionImpl createFromDecision(DmnElementTransformContext context, Decision decision) {
        DecisionDefinitionEntity decisionDefinition = (DecisionDefinitionEntity)super.createFromDecision(context, decision);
        String category = context.getModelInstance().getDefinitions().getNamespace();
        decisionDefinition.setCategory(category);
        Integer historyTimeToLive = decision.getCamundaHistoryTimeToLive();
        this.validateHistoryTimeToLive(historyTimeToLive);
        decisionDefinition.setHistoryTimeToLive(historyTimeToLive);
        return decisionDefinition;
    }

    private void validateHistoryTimeToLive(Integer historyTimeToLive) {
        if (historyTimeToLive != null) {
            EnsureUtil.ensureGreaterThanOrEqual("", "historyTimeToLive", historyTimeToLive.intValue(), 0L);
        }
    }
}

