/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.handler;

import org.camunda.bpm.engine.impl.cmmn.behavior.CallingTaskActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.handler.CmmnHandlerContext;
import org.camunda.bpm.engine.impl.cmmn.handler.TaskItemHandler;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.core.model.BaseCallableElement;
import org.camunda.bpm.engine.impl.core.model.DefaultCallableElementTenantIdProvider;
import org.camunda.bpm.engine.impl.core.variable.mapping.value.ConstantValueProvider;
import org.camunda.bpm.engine.impl.core.variable.mapping.value.NullValueProvider;
import org.camunda.bpm.engine.impl.core.variable.mapping.value.ParameterValueProvider;
import org.camunda.bpm.engine.impl.el.ElValueProvider;
import org.camunda.bpm.engine.impl.el.Expression;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.model.cmmn.instance.CmmnElement;

public abstract class CallingTaskItemHandler
extends TaskItemHandler {
    @Override
    protected void initializeActivity(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        super.initializeActivity(element, activity, context);
        this.initializeCallableElement(element, activity, context);
    }

    protected void initializeCallableElement(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        Deployment deployment = context.getDeployment();
        String deploymentId = null;
        if (deployment != null) {
            deploymentId = deployment.getId();
        }
        BaseCallableElement callableElement = this.createCallableElement();
        callableElement.setDeploymentId(deploymentId);
        CallingTaskActivityBehavior behavior = (CallingTaskActivityBehavior)activity.getActivityBehavior();
        behavior.setCallableElement(callableElement);
        this.initializeDefinitionKey(element, activity, context, callableElement);
        this.initializeBinding(element, activity, context, callableElement);
        this.initializeVersion(element, activity, context, callableElement);
        this.initializeTenantId(element, activity, context, callableElement);
    }

    protected void initializeDefinitionKey(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context, BaseCallableElement callableElement) {
        ExpressionManager expressionManager = context.getExpressionManager();
        String definitionKey = this.getDefinitionKey(element, activity, context);
        ParameterValueProvider definitionKeyProvider = this.createParameterValueProvider(definitionKey, expressionManager);
        callableElement.setDefinitionKeyValueProvider(definitionKeyProvider);
    }

    protected void initializeBinding(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context, BaseCallableElement callableElement) {
        String binding = this.getBinding(element, activity, context);
        if (BaseCallableElement.CallableElementBinding.DEPLOYMENT.getValue().equals(binding)) {
            callableElement.setBinding(BaseCallableElement.CallableElementBinding.DEPLOYMENT);
        } else if (BaseCallableElement.CallableElementBinding.LATEST.getValue().equals(binding)) {
            callableElement.setBinding(BaseCallableElement.CallableElementBinding.LATEST);
        } else if (BaseCallableElement.CallableElementBinding.VERSION.getValue().equals(binding)) {
            callableElement.setBinding(BaseCallableElement.CallableElementBinding.VERSION);
        }
    }

    protected void initializeVersion(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context, BaseCallableElement callableElement) {
        ExpressionManager expressionManager = context.getExpressionManager();
        String version = this.getVersion(element, activity, context);
        ParameterValueProvider versionProvider = this.createParameterValueProvider(version, expressionManager);
        callableElement.setVersionValueProvider(versionProvider);
    }

    protected void initializeTenantId(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context, BaseCallableElement callableElement) {
        ExpressionManager expressionManager = context.getExpressionManager();
        String tenantId = this.getTenantId(element, activity, context);
        ParameterValueProvider tenantIdProvider = tenantId != null && tenantId.length() > 0 ? this.createParameterValueProvider(tenantId, expressionManager) : new DefaultCallableElementTenantIdProvider();
        callableElement.setTenantIdProvider(tenantIdProvider);
    }

    protected ParameterValueProvider createParameterValueProvider(String value, ExpressionManager expressionManager) {
        if (value == null) {
            return new NullValueProvider();
        }
        if (StringUtil.isCompositeExpression(value, expressionManager)) {
            Expression expression = expressionManager.createExpression(value);
            return new ElValueProvider(expression);
        }
        return new ConstantValueProvider(value);
    }

    protected abstract BaseCallableElement createCallableElement();

    protected abstract String getDefinitionKey(CmmnElement var1, CmmnActivity var2, CmmnHandlerContext var3);

    protected abstract String getBinding(CmmnElement var1, CmmnActivity var2, CmmnHandlerContext var3);

    protected abstract String getVersion(CmmnElement var1, CmmnActivity var2, CmmnHandlerContext var3);

    protected abstract String getTenantId(CmmnElement var1, CmmnActivity var2, CmmnHandlerContext var3);
}

